/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.jdbc2;

import com.vertica.Driver;
import com.vertica.PGNotification;
import com.vertica.core.BaseConnection;
import com.vertica.core.BaseStatement;
import com.vertica.core.ConnectionFactory;
import com.vertica.core.Encoding;
import com.vertica.core.Field;
import com.vertica.core.Logger;
import com.vertica.core.ProtocolConnection;
import com.vertica.core.Query;
import com.vertica.core.QueryExecutor;
import com.vertica.core.ResultCursor;
import com.vertica.core.ResultHandler;
import com.vertica.core.Utils;
import com.vertica.core.VectorTuple;
import com.vertica.fastpath.Fastpath;
import com.vertica.geometric.PGbox;
import com.vertica.geometric.PGcircle;
import com.vertica.geometric.PGline;
import com.vertica.geometric.PGlseg;
import com.vertica.geometric.PGpath;
import com.vertica.geometric.PGpoint;
import com.vertica.geometric.PGpolygon;
import com.vertica.jdbc2.AbstractJdbc2Statement;
import com.vertica.jdbc2.TimestampUtils;
import com.vertica.jdbc2.TypeInfoCache;
import com.vertica.largeobject.LargeObjectManager;
import com.vertica.util.GT;
import com.vertica.util.PGmoney;
import com.vertica.util.PGobject;
import com.vertica.util.PSQLException;
import com.vertica.util.PSQLState;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.CallableStatement;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;

public abstract class AbstractJdbc2Connection
implements BaseConnection {
    private static int nextConnectionID = 1;
    private final Logger logger;
    private final String creatingURL;
    private Throwable openStackTrace;
    private final ProtocolConnection protoConnection;
    private final String compatible;
    private final String dbVersionNumber;
    private final String vtVersionNumber;
    private final Query commitQuery;
    private final Query rollbackQuery;
    private TypeInfoCache _typeCache;
    private int txnIsolationLevel = -1;
    protected int prepareThreshold;
    protected boolean streamingLRS;
    protected int maxLRSMemory;
    protected boolean directBatchInsert;
    protected boolean batchInsertEnforceLength;
    protected boolean abortBatchInsertOnError;
    protected String batchInsertRecordTerminator;
    protected boolean binaryBatchInsert;
    protected boolean use35CopyFormat;
    public boolean autoCommit = true;
    public boolean readOnly = false;
    public final boolean bindStringAsVarchar;
    public SQLWarning firstWarning = null;
    private final TimestampUtils timestampUtils;
    protected Map typemap;
    private Fastpath fastpath = null;
    private LargeObjectManager largeobject = null;
    protected DatabaseMetaData metadata;

    public abstract DatabaseMetaData getMetaData() throws SQLException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected AbstractJdbc2Connection(String string, int n, String string2, String string3, Properties properties, String string4) throws SQLException {
        this.creatingURL = string4;
        int n2 = Driver.getLogLevel();
        String string5 = properties.getProperty("loglevel");
        if (string5 != null) {
            try {
                n2 = Integer.parseInt(string5);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Object object = AbstractJdbc2Connection.class;
        synchronized (AbstractJdbc2Connection.class) {
            this.logger = new Logger(nextConnectionID++);
            this.logger.setLogLevel(n2);
            // ** MonitorExit[var9_10] (shouldn't be in output)
            if (n2 > 0) {
                this.enableDriverManagerLogging();
            }
            this.prepareThreshold = 5;
            try {
                this.prepareThreshold = Integer.parseInt(properties.getProperty("prepareThreshold", "5"));
                if (this.prepareThreshold < 0) {
                    this.prepareThreshold = 0;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.streamingLRS = true;
            try {
                this.streamingLRS = Boolean.parseBoolean(properties.getProperty("streamingLRS", "true"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.maxLRSMemory = 0x800000;
            try {
                this.maxLRSMemory = Integer.parseInt(properties.getProperty("maxLRSMemory", "8388608"));
                if (this.maxLRSMemory < 16384) {
                    this.maxLRSMemory = 16384;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.directBatchInsert = false;
            try {
                this.directBatchInsert = Boolean.parseBoolean(properties.getProperty("directBatchInsert", "false"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.batchInsertEnforceLength = false;
            try {
                this.batchInsertEnforceLength = Boolean.parseBoolean(properties.getProperty("batchInsertEnforceLength", "false"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.batchInsertRecordTerminator = "\b\t\f";
            try {
                this.batchInsertRecordTerminator = properties.getProperty("batchInsertRecordTerminator", "\b\t\f");
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.abortBatchInsertOnError = false;
            try {
                this.abortBatchInsertOnError = Boolean.parseBoolean(properties.getProperty("AbortBatchInsertOnError", "false"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.binaryBatchInsert = false;
            try {
                this.binaryBatchInsert = Boolean.parseBoolean(properties.getProperty("binaryBatchInsert", "false"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.use35CopyFormat = false;
            try {
                this.use35CopyFormat = Boolean.parseBoolean(properties.getProperty("use35CopyFormat", "false"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.autoCommit = Boolean.parseBoolean(properties.getProperty("defaultAutoCommit", "true"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.logger.logInfo()) {
                this.logger.info(Driver.getVersion());
            }
            this.protoConnection = ConnectionFactory.openConnection(string, n, string2, string3, properties, this.logger);
            this.protoConnection.setConnection(this);
            this.dbVersionNumber = this.protoConnection.getServerVersion();
            this.vtVersionNumber = this.protoConnection.getVTServerVersion();
            if (this.getServerMajorVersion() < 4) {
                throw new PSQLException(GT.tr("Vertica Database server version 4.0 or later is required. Detected version {0}.", this.vtVersionNumber), PSQLState.CONNECTION_FAILURE);
            }
            this.compatible = properties.getProperty("compatible", Driver.getMajorVersionStatic() + "." + Driver.getMinorVersionStatic());
            if (this.logger.logDebug()) {
                this.logger.debug("    compatible = " + this.compatible);
                this.logger.debug("    loglevel = " + n2);
                this.logger.debug("    prepare threshold = " + this.prepareThreshold);
            }
            if ((object = properties.getProperty("stringtype")) != null) {
                if (((String)object).equalsIgnoreCase("unspecified")) {
                    this.bindStringAsVarchar = false;
                } else {
                    if (!((String)object).equalsIgnoreCase("varchar")) throw new PSQLException(GT.tr("Unsupported value for stringtype parameter: {0}", object), PSQLState.INVALID_PARAMETER_VALUE);
                    this.bindStringAsVarchar = true;
                }
            } else {
                this.bindStringAsVarchar = true;
            }
            this.timestampUtils = new TimestampUtils(this.haveMinimumServerVersion("7.4"));
            this.commitQuery = this.getQueryExecutor().createSimpleQuery("COMMIT");
            this.rollbackQuery = this.getQueryExecutor().createSimpleQuery("ROLLBACK");
            this._typeCache = new TypeInfoCache(this);
            this.initObjectTypes(properties);
            if (Boolean.valueOf(properties.getProperty("logUnclosedConnections")).booleanValue()) {
                this.openStackTrace = new Throwable("Connection was created at this point:");
                this.enableDriverManagerLogging();
            }
            this.checkLicenseStatus();
            return;
        }
    }

    private void checkLicenseStatus() {
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            int n;
            int n2 = n = this.dbVersionNumber == null ? 0 : Integer.parseInt(this.dbVersionNumber.split(".")[0]);
            if (n >= 5) {
                statement = this.createStatement();
                if (statement.execute("select compliance_level, compliance_message from vs_databases")) {
                    resultSet = statement.getResultSet();
                    int n3 = resultSet.getInt(1);
                    String string = resultSet.getString(2);
                    if (n3 == 3) {
                        this.addWarning(new SQLWarning(string));
                        this.logger.log(string, null);
                    }
                    resultSet.close();
                }
                statement.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public TimestampUtils getTimestampUtils() {
        return this.timestampUtils;
    }

    public Statement createStatement() throws SQLException {
        return this.createStatement(1003, 1007);
    }

    public abstract Statement createStatement(int var1, int var2) throws SQLException;

    public PreparedStatement prepareStatement(String string) throws SQLException {
        return this.prepareStatement(string, 1003, 1007);
    }

    public abstract PreparedStatement prepareStatement(String var1, int var2, int var3) throws SQLException;

    public CallableStatement prepareCall(String string) throws SQLException {
        return this.prepareCall(string, 1003, 1007);
    }

    public abstract CallableStatement prepareCall(String var1, int var2, int var3) throws SQLException;

    public Map getTypeMap() throws SQLException {
        return this.typemap;
    }

    public QueryExecutor getQueryExecutor() {
        return this.protoConnection.getQueryExecutor();
    }

    public void addWarning(SQLWarning sQLWarning) {
        if (this.firstWarning != null) {
            this.firstWarning.setNextWarning(sQLWarning);
        } else {
            this.firstWarning = sQLWarning;
        }
    }

    public ResultSet execSQLQuery(String string) throws SQLException {
        BaseStatement baseStatement = (BaseStatement)this.createStatement();
        boolean bl = baseStatement.executeWithFlags(string, 16);
        while (!bl && baseStatement.getUpdateCount() != -1) {
            bl = baseStatement.getMoreResults();
        }
        if (!bl) {
            throw new PSQLException(GT.tr("No results were returned by the query."), PSQLState.NO_DATA);
        }
        SQLWarning sQLWarning = baseStatement.getWarnings();
        if (sQLWarning != null) {
            this.addWarning(sQLWarning);
        }
        return baseStatement.getResultSet();
    }

    public void execSQLUpdate(String string) throws SQLException {
        BaseStatement baseStatement = (BaseStatement)this.createStatement();
        if (baseStatement.executeWithFlags(string, 22)) {
            throw new PSQLException(GT.tr("A result was returned when none was expected."), PSQLState.TOO_MANY_RESULTS);
        }
        SQLWarning sQLWarning = baseStatement.getWarnings();
        if (sQLWarning != null) {
            this.addWarning(sQLWarning);
        }
        baseStatement.close();
    }

    public void setCursorName(String string) throws SQLException {
    }

    public String getCursorName() throws SQLException {
        return null;
    }

    public String getURL() throws SQLException {
        return this.creatingURL;
    }

    public String getUserName() throws SQLException {
        return this.protoConnection.getUser();
    }

    public Fastpath getFastpathAPI() throws SQLException {
        if (this.fastpath == null) {
            this.fastpath = new Fastpath(this);
        }
        return this.fastpath;
    }

    public LargeObjectManager getLargeObjectAPI() throws SQLException {
        if (this.largeobject == null) {
            this.largeobject = new LargeObjectManager(this);
        }
        return this.largeobject;
    }

    public Object getObject(String string, String string2) throws SQLException {
        Object object;
        if (this.typemap != null && (object = (SQLData)this.typemap.get(string)) != null) {
            if (this.logger.logDebug()) {
                this.logger.debug("getObject(String,String) with custom typemap");
            }
            throw Driver.notImplemented(this.getClass(), "getObject(String,String)");
        }
        object = null;
        if (this.logger.logDebug()) {
            this.logger.debug("Constructing object from type=" + string + " value=<" + string2 + ">");
        }
        try {
            Class clazz = this._typeCache.getPGobject(string);
            if (clazz != null) {
                object = (PGobject)clazz.newInstance();
                ((PGobject)object).setType(string);
                ((PGobject)object).setValue(string2);
            } else {
                object = new PGobject();
                ((PGobject)object).setType(string);
                ((PGobject)object).setValue(string2);
            }
            return object;
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            throw new PSQLException(GT.tr("Failed to create object for: {0}.", string), PSQLState.CONNECTION_FAILURE, (Throwable)exception);
        }
    }

    public void addDataType(String string, String string2) {
        try {
            this.addDataType(string, Class.forName(string2));
        }
        catch (Exception exception) {
            throw new RuntimeException("Cannot register new type: " + exception);
        }
    }

    public void addDataType(String string, Class clazz) throws SQLException {
        this._typeCache.addDataType(string, clazz);
    }

    private void initObjectTypes(Properties properties) throws SQLException {
        this.addDataType("box", PGbox.class);
        this.addDataType("circle", PGcircle.class);
        this.addDataType("line", PGline.class);
        this.addDataType("lseg", PGlseg.class);
        this.addDataType("path", PGpath.class);
        this.addDataType("point", PGpoint.class);
        this.addDataType("polygon", PGpolygon.class);
        this.addDataType("money", PGmoney.class);
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            Class<?> clazz;
            String string = (String)enumeration.nextElement();
            if (!string.startsWith("datatype.")) continue;
            String string2 = string.substring(9);
            String string3 = properties.getProperty(string);
            try {
                clazz = Class.forName(string3);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new PSQLException(GT.tr("Unable to load the class {0} responsible for the datatype {1}", new Object[]{string3, string2}), PSQLState.SYSTEM_ERROR, (Throwable)classNotFoundException);
            }
            this.addDataType(string2, clazz);
        }
    }

    public void close() {
        this.protoConnection.close();
        this.openStackTrace = null;
    }

    public String nativeSQL(String string) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        AbstractJdbc2Statement.parseSql(string, 0, stringBuffer, false);
        return stringBuffer.toString();
    }

    public synchronized SQLWarning getWarnings() throws SQLException {
        SQLWarning sQLWarning = this.protoConnection.getWarnings();
        if (this.firstWarning == null) {
            this.firstWarning = sQLWarning;
        } else {
            this.firstWarning.setNextWarning(sQLWarning);
        }
        return this.firstWarning;
    }

    public synchronized void clearWarnings() throws SQLException {
        this.protoConnection.getWarnings();
        this.firstWarning = null;
    }

    public void setReadOnly(boolean bl) throws SQLException {
        if (this.protoConnection.getTransactionState() != 0) {
            throw new PSQLException(GT.tr("Cannot change transaction read-only property in the middle of a transaction."), PSQLState.ACTIVE_SQL_TRANSACTION);
        }
        if (this.haveMinimumServerVersion("7.4") && bl != this.readOnly) {
            String string = "SET SESSION CHARACTERISTICS AS TRANSACTION " + (bl ? "READ ONLY" : "READ WRITE");
            this.execSQLUpdate(string);
        }
        this.readOnly = bl;
    }

    public boolean isReadOnly() throws SQLException {
        return this.readOnly;
    }

    public void setAutoCommit(boolean bl) throws SQLException {
        if (this.autoCommit == bl) {
            return;
        }
        if (!this.autoCommit) {
            this.commit();
        }
        this.autoCommit = bl;
    }

    public boolean getAutoCommit() {
        return this.autoCommit;
    }

    private void executeTransactionCommand(Query query) throws SQLException {
        if (this.getQueryExecutor().getCurrentStatement() != null) {
            this.getQueryExecutor().getCurrentStatement().finishLoad(true);
        }
        this.getQueryExecutor().setCurrentStatement(null);
        this.getQueryExecutor().execute(query, null, (ResultHandler)new TransactionCommandHandler(), 0, 0, 2070);
    }

    public void commit() throws SQLException {
        if (this.autoCommit) {
            throw new SQLException("Connection is in auto-commit mode");
        }
        if (this.getQueryExecutor().getCurrentStatement() != null) {
            this.getQueryExecutor().getCurrentStatement().finishLoad(false);
        }
        if (this.protoConnection.getTransactionState() != 0) {
            this.executeTransactionCommand(this.commitQuery);
        }
    }

    public void rollback() throws SQLException {
        if (this.autoCommit) {
            throw new SQLException("Connection is in auto-commit mode");
        }
        if (this.protoConnection.getTransactionState() != 0) {
            this.executeTransactionCommand(this.rollbackQuery);
        }
    }

    public void autoCommit() throws SQLException {
        if (this.autoCommit && this.protoConnection.getTransactionState() != 0) {
            this.executeTransactionCommand(this.commitQuery);
        }
    }

    public int getTransactionIsolation() throws SQLException {
        String string = null;
        ResultSet resultSet = this.execSQLQuery("SHOW TRANSACTION ISOLATION LEVEL");
        if (resultSet.next()) {
            string = resultSet.getString(2);
        }
        resultSet.close();
        this.txnIsolationLevel = string == null ? 2 : ((string = string.toUpperCase()).indexOf("READ COMMITTED") != -1 ? 2 : (string.indexOf("READ UNCOMMITTED") != -1 ? 1 : (string.indexOf("REPEATABLE READ") != -1 ? 4 : (string.indexOf("SERIALIZABLE") != -1 ? 8 : 2))));
        return this.txnIsolationLevel;
    }

    public void setTransactionIsolation(int n) throws SQLException {
        if (this.protoConnection.getTransactionState() != 0) {
            throw new PSQLException(GT.tr("Cannot change transaction isolation level in the middle of a transaction."), PSQLState.ACTIVE_SQL_TRANSACTION);
        }
        String string = this.getIsolationLevelName(n);
        if (string == null) {
            throw new PSQLException(GT.tr("Transaction isolation level {0} not supported.", new Integer(n)), PSQLState.NOT_IMPLEMENTED);
        }
        String string2 = "SET SESSION CHARACTERISTICS AS TRANSACTION ISOLATION LEVEL " + string;
        this.execSQLUpdate(string2);
        this.txnIsolationLevel = n;
    }

    protected String getIsolationLevelName(int n) {
        boolean bl = this.haveMinimumServerVersion("8.0");
        if (n == 2) {
            return "READ COMMITTED";
        }
        if (n == 8) {
            return "SERIALIZABLE";
        }
        if (bl && n == 1) {
            return "READ UNCOMMITTED";
        }
        if (bl && n == 4) {
            return "REPEATABLE READ";
        }
        return null;
    }

    public void setCatalog(String string) throws SQLException {
    }

    public String getCatalog() throws SQLException {
        return this.protoConnection.getDatabase();
    }

    public void finalize() throws Throwable {
        if (this.openStackTrace != null) {
            this.logger.log(GT.tr("Finalizing a Connection that was never closed:"), this.openStackTrace);
        }
        this.close();
    }

    public String getDBVersionNumber() {
        return this.dbVersionNumber;
    }

    public String getVTVersionNumber() {
        return this.vtVersionNumber;
    }

    private static int integerPart(String string) {
        int n;
        int n2;
        for (n2 = 0; n2 < string.length() && !Character.isDigit(string.charAt(n2)); ++n2) {
        }
        for (n = n2; n < string.length() && Character.isDigit(string.charAt(n)); ++n) {
        }
        if (n2 == n) {
            return 0;
        }
        return Integer.parseInt(string.substring(n2, n));
    }

    public int getServerMajorVersion() {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(this.vtVersionNumber, ".");
            return AbstractJdbc2Connection.integerPart(stringTokenizer.nextToken());
        }
        catch (NoSuchElementException noSuchElementException) {
            return 0;
        }
    }

    public int getServerMinorVersion() {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(this.vtVersionNumber, ".");
            stringTokenizer.nextToken();
            return AbstractJdbc2Connection.integerPart(stringTokenizer.nextToken());
        }
        catch (NoSuchElementException noSuchElementException) {
            return 0;
        }
    }

    public boolean haveMinimumServerVersion(String string) {
        return this.dbVersionNumber.compareTo(string) >= 0;
    }

    public boolean haveMinimumCompatibleVersion(String string) {
        return this.compatible.compareTo(string) >= 0;
    }

    public Encoding getEncoding() {
        return this.protoConnection.getEncoding();
    }

    public byte[] encodeString(String string) throws SQLException {
        try {
            return this.getEncoding().encode(string);
        }
        catch (IOException iOException) {
            throw new PSQLException(GT.tr("Unable to translate data into the desired encoding."), PSQLState.DATA_ERROR, (Throwable)iOException);
        }
    }

    public int getSQLType(int n) throws SQLException {
        return this._typeCache.getSQLType(n);
    }

    public Iterator getPGTypeNamesWithSQLTypes() {
        AbstractJdbc2Connection abstractJdbc2Connection = this;
        return abstractJdbc2Connection._typeCache.getPGTypeNamesWithSQLTypes();
    }

    public int getPGType(String string) throws SQLException {
        return this._typeCache.getPGType(string);
    }

    public String getJavaClass(int n) throws SQLException {
        return this._typeCache.getJavaClass(n);
    }

    public String getPGType(int n) throws SQLException {
        return this._typeCache.getPGType(n);
    }

    public boolean isClosed() throws SQLException {
        return this.protoConnection.isClosed();
    }

    public void cancelQuery() throws SQLException {
        this.protoConnection.sendQueryCancel();
    }

    public PGNotification[] getNotifications() throws SQLException {
        PGNotification[] pGNotificationArray = this.protoConnection.getNotifications();
        return pGNotificationArray.length == 0 ? null : pGNotificationArray;
    }

    public int getPrepareThreshold() {
        return this.prepareThreshold;
    }

    public void setPrepareThreshold(int n) {
        this.prepareThreshold = n <= 0 ? 0 : n;
    }

    public void setStreamingLRS(boolean bl) {
        this.streamingLRS = bl;
    }

    public boolean getStreamingLRS() {
        return this.streamingLRS;
    }

    public void setMaxLRSMemory(int n) {
        this.maxLRSMemory = n < 16384 ? 16384 : n;
    }

    public int getMaxLRSMemory() {
        return this.maxLRSMemory;
    }

    public void setDirectBatchInsert(boolean bl) {
        this.directBatchInsert = bl;
    }

    public boolean getDirectBatchInsert() {
        return this.directBatchInsert;
    }

    public void setBatchInsertEnforceLength(boolean bl) {
        this.batchInsertEnforceLength = bl;
    }

    public boolean getBatchInsertEnforceLength() {
        return this.batchInsertEnforceLength;
    }

    public String getBatchInsertRecordTerminator() {
        return this.batchInsertRecordTerminator;
    }

    public void setBatchInsertRecordTerminator(String string) {
        this.batchInsertRecordTerminator = string;
    }

    public void setAbortBatchInsertOnError(boolean bl) {
        this.abortBatchInsertOnError = bl;
    }

    public boolean getAbortBatchInsertOnError() {
        return this.abortBatchInsertOnError;
    }

    public void setBinaryBatchInsert(boolean bl) {
        this.binaryBatchInsert = bl;
    }

    public boolean getBinaryBatchInsert() {
        return this.binaryBatchInsert;
    }

    public void setUse35CopyFormat(boolean bl) {
        this.use35CopyFormat = bl;
    }

    public boolean getUse35CopyFormat() {
        return this.use35CopyFormat;
    }

    public String getLocale() throws SQLException {
        String string = null;
        ResultSet resultSet = this.execSQLQuery("SHOW LOCALE");
        if (resultSet.next()) {
            string = resultSet.getString(2);
        }
        resultSet.close();
        if (string == null) {
            string = "en_US";
        }
        return string;
    }

    public void setLocale(String string) throws SQLException {
        this.execSQLUpdate("SET LOCALE=" + Utils.escapeSingleQuotes(string));
    }

    public void setTypeMapImpl(Map map) throws SQLException {
        this.typemap = map;
    }

    public Logger getLogger() {
        return this.logger;
    }

    protected void enableDriverManagerLogging() {
        if (DriverManager.getLogWriter() == null) {
            DriverManager.setLogWriter(new PrintWriter(System.out, true));
        }
    }

    public int getSQLType(String string) {
        return TypeInfoCache.getSQLType(string);
    }

    public int getProtocolVersion() {
        return this.protoConnection.getProtocolVersion();
    }

    public boolean getStringVarcharFlag() {
        return this.bindStringAsVarchar;
    }

    public boolean isInLRS() {
        return this.protoConnection.isInLRS();
    }

    public void setInLRS(boolean bl) {
        this.protoConnection.setInLRS(bl);
    }

    public boolean isInLoad() {
        return this.protoConnection.isVerticaCopyStarted();
    }

    public boolean isInCopyIn() {
        return this.protoConnection.isInCopyIn();
    }

    public void setInCopyIn(boolean bl) {
        this.protoConnection.setInCopyIn(bl);
    }

    public boolean loadingBatches() {
        return this.protoConnection.loadingBatches();
    }

    public void setLoadingBatches(boolean bl) {
        this.protoConnection.setLoadingBatch(bl);
    }

    public void setManagedBatchInsert(boolean bl) {
    }

    public boolean getManagedBatchInsert() {
        return false;
    }

    public void setUse35CopyParameters(boolean bl) {
    }

    public boolean getUse35CopyParameters() {
        return false;
    }

    private class TransactionCommandHandler
    implements ResultHandler {
        private SQLException error;

        private TransactionCommandHandler() {
        }

        public void handleResultRows(Query query, Field[] fieldArray, VectorTuple vectorTuple, ResultCursor resultCursor) {
        }

        public void handleCommandStatus(String string, int n, long l) {
        }

        public void handleWarning(SQLWarning sQLWarning) {
            AbstractJdbc2Connection.this.addWarning(sQLWarning);
        }

        public void handleError(SQLException sQLException) {
            if (this.error == null) {
                this.error = sQLException;
            } else {
                this.error.setNextException(sQLException);
            }
        }

        public void handleCompletion() throws SQLException {
            if (this.error != null) {
                throw this.error;
            }
        }
    }
}

