/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.geometric;

import com.vertica.geometric.PGpoint;
import com.vertica.util.PGobject;
import com.vertica.util.PGtokenizer;
import java.io.Serializable;
import java.sql.SQLException;

public class PGpolygon
extends PGobject
implements Serializable,
Cloneable {
    public PGpoint[] points;

    public PGpolygon(PGpoint[] pGpointArray) {
        this();
        this.points = pGpointArray;
    }

    public PGpolygon(String string) throws SQLException {
        this();
        this.setValue(string);
    }

    public PGpolygon() {
        this.setType("polygon");
    }

    public void setValue(String string) throws SQLException {
        PGtokenizer pGtokenizer = new PGtokenizer(PGtokenizer.removePara(string), ',');
        int n = pGtokenizer.getSize();
        this.points = new PGpoint[n];
        for (int i = 0; i < n; ++i) {
            this.points[i] = new PGpoint(pGtokenizer.getToken(i));
        }
    }

    public boolean equals(Object object) {
        if (object instanceof PGpolygon) {
            PGpolygon pGpolygon = (PGpolygon)object;
            if (pGpolygon.points.length != this.points.length) {
                return false;
            }
            for (int i = 0; i < this.points.length; ++i) {
                if (this.points[i].equals(pGpolygon.points[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int n = 0;
        for (int i = 0; i < this.points.length && i < 5; ++i) {
            n ^= this.points[i].hashCode();
        }
        return n;
    }

    public Object clone() {
        PGpoint[] pGpointArray = new PGpoint[this.points.length];
        for (int i = 0; i < this.points.length; ++i) {
            pGpointArray[i] = (PGpoint)this.points[i].clone();
        }
        return new PGpolygon(pGpointArray);
    }

    public String getValue() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        for (int i = 0; i < this.points.length; ++i) {
            if (i > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(this.points[i].toString());
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }
}

