/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.geometric;

import com.vertica.geometric.PGpoint;
import com.vertica.util.GT;
import com.vertica.util.PGobject;
import com.vertica.util.PGtokenizer;
import com.vertica.util.PSQLException;
import com.vertica.util.PSQLState;
import java.io.Serializable;
import java.sql.SQLException;

public class PGbox
extends PGobject
implements Serializable,
Cloneable {
    public PGpoint[] point = new PGpoint[2];

    public PGbox(double d, double d2, double d3, double d4) {
        this();
        this.point[0] = new PGpoint(d, d2);
        this.point[1] = new PGpoint(d3, d4);
    }

    public PGbox(PGpoint pGpoint, PGpoint pGpoint2) {
        this();
        this.point[0] = pGpoint;
        this.point[1] = pGpoint2;
    }

    public PGbox(String string) throws SQLException {
        this();
        this.setValue(string);
    }

    public PGbox() {
        this.setType("box");
    }

    public void setValue(String string) throws SQLException {
        PGtokenizer pGtokenizer = new PGtokenizer(string, ',');
        if (pGtokenizer.getSize() != 2) {
            throw new PSQLException(GT.tr("Conversion to type {0} failed: {1}.", new Object[]{this.type, string}), PSQLState.DATA_TYPE_MISMATCH);
        }
        this.point[0] = new PGpoint(pGtokenizer.getToken(0));
        this.point[1] = new PGpoint(pGtokenizer.getToken(1));
    }

    public boolean equals(Object object) {
        if (object instanceof PGbox) {
            PGbox pGbox = (PGbox)object;
            if (pGbox.point[0].equals(this.point[0]) && pGbox.point[1].equals(this.point[1])) {
                return true;
            }
            if (pGbox.point[0].equals(this.point[1]) && pGbox.point[1].equals(this.point[0])) {
                return true;
            }
            if (pGbox.point[0].x == this.point[0].x && pGbox.point[0].y == this.point[1].y && pGbox.point[1].x == this.point[1].x && pGbox.point[1].y == this.point[0].y) {
                return true;
            }
            if (pGbox.point[0].x == this.point[1].x && pGbox.point[0].y == this.point[0].y && pGbox.point[1].x == this.point[0].x && pGbox.point[1].y == this.point[1].y) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.point[0].hashCode() ^ this.point[1].hashCode();
    }

    public Object clone() {
        return new PGbox((PGpoint)this.point[0].clone(), (PGpoint)this.point[1].clone());
    }

    public String getValue() {
        return this.point[0].toString() + "," + this.point[1].toString();
    }
}

