/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.fastpath;

import com.vertica.core.ParameterList;
import java.sql.SQLException;

public class FastpathArg {
    private final byte[] bytes;
    private final int bytesStart;
    private final int bytesLength;

    public FastpathArg(int n) {
        this.bytes = new byte[4];
        this.bytes[3] = (byte)n;
        this.bytes[2] = (byte)(n >> 8);
        this.bytes[1] = (byte)(n >> 16);
        this.bytes[0] = (byte)(n >> 24);
        this.bytesStart = 0;
        this.bytesLength = 4;
    }

    public FastpathArg(byte[] byArray) {
        this(byArray, 0, byArray.length);
    }

    public FastpathArg(byte[] byArray, int n, int n2) {
        this.bytes = byArray;
        this.bytesStart = n;
        this.bytesLength = n2;
    }

    public FastpathArg(String string) {
        this(string.getBytes());
    }

    void populateParameter(ParameterList parameterList, int n) throws SQLException {
        if (this.bytes == null) {
            parameterList.setNull(n, 0);
        } else {
            parameterList.setBytea(n, this.bytes, this.bytesStart, this.bytesLength);
        }
    }
}

