/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.fastpath;

import com.vertica.core.BaseConnection;
import com.vertica.core.ParameterList;
import com.vertica.core.QueryExecutor;
import com.vertica.fastpath.FastpathArg;
import com.vertica.util.GT;
import com.vertica.util.PSQLException;
import com.vertica.util.PSQLState;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Hashtable;

public class Fastpath {
    private final Hashtable func = new Hashtable();
    private final QueryExecutor executor;
    private final BaseConnection connection;

    public Fastpath(BaseConnection baseConnection) {
        this.connection = baseConnection;
        this.executor = baseConnection.getQueryExecutor();
    }

    public Object fastpath(int n, boolean bl, FastpathArg[] fastpathArgArray) throws SQLException {
        ParameterList parameterList = this.executor.createFastpathParameters(fastpathArgArray.length);
        for (int i = 0; i < fastpathArgArray.length; ++i) {
            fastpathArgArray[i].populateParameter(parameterList, i + 1);
        }
        byte[] byArray = this.executor.fastpathCall(n, parameterList, this.connection.getAutoCommit());
        if (!bl || byArray == null) {
            return byArray;
        }
        if (byArray.length != 4) {
            throw new PSQLException(GT.tr("Fastpath call {0} - No result was returned and we expected an integer.", new Integer(n)), PSQLState.NO_DATA);
        }
        return new Integer(byArray[3] & 0xFF | (byArray[2] & 0xFF) << 8 | (byArray[1] & 0xFF) << 16 | (byArray[0] & 0xFF) << 24);
    }

    public Object fastpath(String string, boolean bl, FastpathArg[] fastpathArgArray) throws SQLException {
        if (this.connection.getLogger().logDebug()) {
            this.connection.getLogger().debug("Fastpath: calling " + string);
        }
        return this.fastpath(this.getID(string), bl, fastpathArgArray);
    }

    public int getInteger(String string, FastpathArg[] fastpathArgArray) throws SQLException {
        Integer n = (Integer)this.fastpath(string, true, fastpathArgArray);
        if (n == null) {
            throw new PSQLException(GT.tr("Fastpath call {0} - No result was returned and we expected an integer.", string), PSQLState.NO_DATA);
        }
        return n;
    }

    public byte[] getData(String string, FastpathArg[] fastpathArgArray) throws SQLException {
        return (byte[])this.fastpath(string, false, fastpathArgArray);
    }

    public void addFunction(String string, int n) {
        this.func.put(string, new Integer(n));
    }

    public void addFunctions(ResultSet resultSet) throws SQLException {
        while (resultSet.next()) {
            this.func.put(resultSet.getString(1), new Integer(resultSet.getInt(2)));
        }
    }

    public int getID(String string) throws SQLException {
        Integer n = (Integer)this.func.get(string);
        if (n == null) {
            throw new PSQLException(GT.tr("The fastpath function {0} is unknown.", string), PSQLState.UNEXPECTED_ERROR);
        }
        return n;
    }
}

