/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.ds.common;

import com.vertica.PGConnection;
import com.vertica.PGStatement;
import com.vertica.util.GT;
import com.vertica.util.PSQLException;
import com.vertica.util.PSQLState;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.List;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;

public class PooledConnectionImpl
implements PooledConnection {
    private List listeners = new LinkedList();
    private Connection con;
    private ConnectionHandler last;
    private final boolean autoCommit;
    private final boolean isXA;
    private static String[] fatalClasses = new String[]{"08", "53", "57P01", "57P02", "57P03", "58", "60", "99", "F0", "XX"};

    public PooledConnectionImpl(Connection connection, boolean bl, boolean bl2) {
        this.con = connection;
        this.autoCommit = true;
        this.isXA = bl2;
    }

    public PooledConnectionImpl(Connection connection, boolean bl) {
        this(connection, true, false);
    }

    public void addConnectionEventListener(ConnectionEventListener connectionEventListener) {
        this.listeners.add(connectionEventListener);
    }

    public void removeConnectionEventListener(ConnectionEventListener connectionEventListener) {
        this.listeners.remove(connectionEventListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        if (this.last != null) {
            this.last.close();
            if (!this.con.getAutoCommit()) {
                try {
                    this.con.rollback();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        }
        try {
            this.con.close();
        }
        finally {
            this.con = null;
        }
    }

    public Connection getConnection() throws SQLException {
        ConnectionHandler connectionHandler;
        block6: {
            if (this.con == null) {
                PSQLException pSQLException = new PSQLException(GT.tr("This PooledConnection has already been closed."), PSQLState.CONNECTION_DOES_NOT_EXIST);
                this.fireConnectionFatalError(pSQLException);
                throw pSQLException;
            }
            try {
                if (this.last == null) break block6;
                this.last.close();
                if (!this.con.getAutoCommit()) {
                    try {
                        this.con.rollback();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                this.con.clearWarnings();
            }
            catch (SQLException sQLException) {
                this.fireConnectionFatalError(sQLException);
                throw (SQLException)sQLException.fillInStackTrace();
            }
        }
        this.last = connectionHandler = new ConnectionHandler(this.con);
        Connection connection = (Connection)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{Connection.class, PGConnection.class}, (InvocationHandler)connectionHandler);
        this.last.setProxy(connection);
        return connection;
    }

    void fireConnectionClosed() {
        ConnectionEvent connectionEvent = null;
        ConnectionEventListener[] connectionEventListenerArray = this.listeners.toArray(new ConnectionEventListener[this.listeners.size()]);
        for (int i = 0; i < connectionEventListenerArray.length; ++i) {
            ConnectionEventListener connectionEventListener = connectionEventListenerArray[i];
            if (connectionEvent == null) {
                connectionEvent = new ConnectionEvent(this);
            }
            connectionEventListener.connectionClosed(connectionEvent);
        }
    }

    void fireConnectionFatalError(SQLException sQLException) {
        ConnectionEvent connectionEvent = null;
        ConnectionEventListener[] connectionEventListenerArray = this.listeners.toArray(new ConnectionEventListener[this.listeners.size()]);
        for (int i = 0; i < connectionEventListenerArray.length; ++i) {
            ConnectionEventListener connectionEventListener = connectionEventListenerArray[i];
            if (connectionEvent == null) {
                connectionEvent = new ConnectionEvent(this, sQLException);
            }
            connectionEventListener.connectionErrorOccurred(connectionEvent);
        }
    }

    private static boolean isFatalState(String string) {
        if (string == null) {
            return true;
        }
        if (string.length() < 2) {
            return true;
        }
        for (int i = 0; i < fatalClasses.length; ++i) {
            if (!string.startsWith(fatalClasses[i])) continue;
            return true;
        }
        return false;
    }

    private void fireConnectionError(SQLException sQLException) {
        if (!PooledConnectionImpl.isFatalState(sQLException.getSQLState())) {
            return;
        }
        this.fireConnectionFatalError(sQLException);
    }

    private class StatementHandler
    implements InvocationHandler {
        private ConnectionHandler con;
        private Statement st;

        public StatementHandler(ConnectionHandler connectionHandler, Statement statement) {
            this.con = connectionHandler;
            this.st = statement;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            if (method.getDeclaringClass().getName().equals("java.lang.Object")) {
                if (method.getName().equals("toString")) {
                    return "Pooled statement wrapping physical statement " + this.st;
                }
                if (method.getName().equals("hashCode")) {
                    return new Integer(this.st.hashCode());
                }
                if (method.getName().equals("equals")) {
                    if (objectArray[0] == null) {
                        return Boolean.FALSE;
                    }
                    try {
                        return Proxy.isProxyClass(objectArray[0].getClass()) && ((StatementHandler)Proxy.getInvocationHandler((Object)objectArray[0])).st == this.st ? Boolean.TRUE : Boolean.FALSE;
                    }
                    catch (ClassCastException classCastException) {
                        return Boolean.FALSE;
                    }
                }
                return method.invoke((Object)this.st, objectArray);
            }
            if (method.getName().equals("close")) {
                if (this.st == null || this.con.isClosed()) {
                    return null;
                }
                try {
                    this.st.close();
                }
                finally {
                    this.con = null;
                    this.st = null;
                }
                return null;
            }
            if (this.st == null || this.con.isClosed()) {
                throw new PSQLException(GT.tr("Statement has been closed."), PSQLState.OBJECT_NOT_IN_STATE);
            }
            if (method.getName().equals("getConnection")) {
                return this.con.getProxy();
            }
            try {
                return method.invoke((Object)this.st, objectArray);
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                if (throwable instanceof SQLException) {
                    PooledConnectionImpl.this.fireConnectionError((SQLException)throwable);
                }
                throw throwable;
            }
        }
    }

    private class ConnectionHandler
    implements InvocationHandler {
        private Connection con;
        private Connection proxy;
        private boolean automatic = false;

        public ConnectionHandler(Connection connection) {
            this.con = connection;
        }

        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            if (method.getDeclaringClass().getName().equals("java.lang.Object")) {
                if (method.getName().equals("toString")) {
                    return "Pooled connection wrapping physical connection " + this.con;
                }
                if (method.getName().equals("hashCode")) {
                    return new Integer(this.con.hashCode());
                }
                if (method.getName().equals("equals")) {
                    if (objectArray[0] == null) {
                        return Boolean.FALSE;
                    }
                    try {
                        return Proxy.isProxyClass(objectArray[0].getClass()) && ((ConnectionHandler)Proxy.getInvocationHandler((Object)objectArray[0])).con == this.con ? Boolean.TRUE : Boolean.FALSE;
                    }
                    catch (ClassCastException classCastException) {
                        return Boolean.FALSE;
                    }
                }
                try {
                    return method.invoke((Object)this.con, objectArray);
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw invocationTargetException.getTargetException();
                }
            }
            if (method.getName().equals("isClosed")) {
                return this.con == null ? Boolean.TRUE : Boolean.FALSE;
            }
            if (this.con == null && !method.getName().equals("close")) {
                throw new PSQLException(this.automatic ? GT.tr("Connection has been closed automatically because a new connection was opened for the same PooledConnection or the PooledConnection has been closed.") : GT.tr("Connection has been closed."), PSQLState.CONNECTION_DOES_NOT_EXIST);
            }
            if (method.getName().equals("close")) {
                if (this.con == null) {
                    return null;
                }
                SQLException sQLException = null;
                if (!PooledConnectionImpl.this.isXA && !this.con.getAutoCommit()) {
                    try {
                        this.con.rollback();
                    }
                    catch (SQLException sQLException2) {
                        sQLException = sQLException2;
                    }
                }
                this.con.clearWarnings();
                this.con = null;
                object = null;
                PooledConnectionImpl.this.last = null;
                PooledConnectionImpl.this.fireConnectionClosed();
                if (sQLException != null) {
                    throw sQLException;
                }
                return null;
            }
            try {
                if (method.getName().equals("createStatement")) {
                    Statement statement = (Statement)method.invoke((Object)this.con, objectArray);
                    return Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{Statement.class, PGStatement.class}, (InvocationHandler)new StatementHandler(this, statement));
                }
                if (method.getName().equals("prepareCall")) {
                    Statement statement = (Statement)method.invoke((Object)this.con, objectArray);
                    return Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{CallableStatement.class, PGStatement.class}, (InvocationHandler)new StatementHandler(this, statement));
                }
                if (method.getName().equals("prepareStatement")) {
                    Statement statement = (Statement)method.invoke((Object)this.con, objectArray);
                    return Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{PreparedStatement.class, PGStatement.class}, (InvocationHandler)new StatementHandler(this, statement));
                }
                return method.invoke((Object)this.con, objectArray);
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                if (throwable instanceof SQLException) {
                    PooledConnectionImpl.this.fireConnectionError((SQLException)throwable);
                }
                throw throwable;
            }
        }

        Connection getProxy() {
            return this.proxy;
        }

        void setProxy(Connection connection) {
            this.proxy = connection;
        }

        public void close() {
            if (this.con != null) {
                this.automatic = true;
            }
            this.con = null;
            this.proxy = null;
        }

        public boolean isClosed() {
            return this.con == null;
        }
    }
}

