/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.ds;

import com.vertica.Driver;
import com.vertica.ds.PGConnectionPoolDataSource;
import com.vertica.ds.common.BaseDataSource;
import com.vertica.ds.common.PooledConnectionImpl;
import com.vertica.util.GT;
import com.vertica.util.PSQLException;
import com.vertica.util.PSQLState;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.DataSource;
import javax.sql.PooledConnection;

public class PGPoolingDataSource
extends BaseDataSource
implements DataSource {
    private static Map dataSources = new HashMap();
    protected String dataSourceName;
    private int initialConnections = 0;
    private int maxConnections = 0;
    private boolean initialized = false;
    private Stack available = new Stack();
    private Stack used = new Stack();
    private Object lock = new Object();
    private PGConnectionPoolDataSource source;
    private ConnectionEventListener connectionEventListener = new ConnectionEventListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void connectionClosed(ConnectionEvent connectionEvent) {
            ((PooledConnection)connectionEvent.getSource()).removeConnectionEventListener(this);
            Object object = PGPoolingDataSource.this.lock;
            synchronized (object) {
                if (PGPoolingDataSource.this.available == null) {
                    return;
                }
                boolean bl = PGPoolingDataSource.this.used.remove(connectionEvent.getSource());
                if (bl) {
                    PGPoolingDataSource.this.available.push(connectionEvent.getSource());
                    PGPoolingDataSource.this.lock.notify();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void connectionErrorOccurred(ConnectionEvent connectionEvent) {
            ((PooledConnection)connectionEvent.getSource()).removeConnectionEventListener(this);
            Object object = PGPoolingDataSource.this.lock;
            synchronized (object) {
                if (PGPoolingDataSource.this.available == null) {
                    return;
                }
                PGPoolingDataSource.this.used.remove(connectionEvent.getSource());
                PGPoolingDataSource.this.lock.notify();
            }
        }
    };

    public static PGPoolingDataSource getDataSource(String string) {
        return (PGPoolingDataSource)dataSources.get(string);
    }

    public String getDescription() {
        return "Pooling DataSource '" + this.dataSourceName + " from " + Driver.getVersion();
    }

    public void setServerName(String string) {
        if (this.initialized) {
            throw new IllegalStateException("Cannot set Data Source properties after DataSource has been used");
        }
        super.setServerName(string);
    }

    public void setDatabaseName(String string) {
        if (this.initialized) {
            throw new IllegalStateException("Cannot set Data Source properties after DataSource has been used");
        }
        super.setDatabaseName(string);
    }

    public void setUser(String string) {
        if (this.initialized) {
            throw new IllegalStateException("Cannot set Data Source properties after DataSource has been used");
        }
        super.setUser(string);
    }

    public void setPassword(String string) {
        if (this.initialized) {
            throw new IllegalStateException("Cannot set Data Source properties after DataSource has been used");
        }
        super.setPassword(string);
    }

    public void setPortNumber(int n) {
        if (this.initialized) {
            throw new IllegalStateException("Cannot set Data Source properties after DataSource has been used");
        }
        super.setPortNumber(n);
    }

    public int getInitialConnections() {
        return this.initialConnections;
    }

    public void setInitialConnections(int n) {
        if (this.initialized) {
            throw new IllegalStateException("Cannot set Data Source properties after DataSource has been used");
        }
        this.initialConnections = n;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public void setMaxConnections(int n) {
        if (this.initialized) {
            throw new IllegalStateException("Cannot set Data Source properties after DataSource has been used");
        }
        this.maxConnections = n;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDataSourceName(String string) {
        if (this.initialized) {
            throw new IllegalStateException("Cannot set Data Source properties after DataSource has been used");
        }
        if (this.dataSourceName != null && string != null && string.equals(this.dataSourceName)) {
            return;
        }
        Map map = dataSources;
        synchronized (map) {
            if (PGPoolingDataSource.getDataSource(string) != null) {
                throw new IllegalArgumentException("DataSource with name '" + string + "' already exists!");
            }
            if (this.dataSourceName != null) {
                dataSources.remove(this.dataSourceName);
            }
            this.dataSourceName = string;
            dataSources.put(string, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() throws SQLException {
        Object object = this.lock;
        synchronized (object) {
            this.source = this.createConnectionPool();
            this.source.setDatabaseName(this.getDatabaseName());
            this.source.setPassword(this.getPassword());
            this.source.setPortNumber(this.getPortNumber());
            this.source.setServerName(this.getServerName());
            this.source.setUser(this.getUser());
            while (this.available.size() < this.initialConnections) {
                this.available.push(this.source.getPooledConnection());
            }
            this.initialized = true;
        }
    }

    protected boolean isInitialized() {
        return this.initialized;
    }

    protected PGConnectionPoolDataSource createConnectionPool() {
        return new PGConnectionPoolDataSource();
    }

    public Connection getConnection(String string, String string2) throws SQLException {
        if (string == null || string.equals(this.getUser()) && (string2 == null && this.getPassword() == null || string2 != null && string2.equals(this.getPassword()))) {
            return this.getConnection();
        }
        if (!this.initialized) {
            this.initialize();
        }
        return super.getConnection(string, string2);
    }

    public Connection getConnection() throws SQLException {
        if (!this.initialized) {
            this.initialize();
        }
        return this.getPooledConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            PooledConnectionImpl pooledConnectionImpl;
            while (this.available.size() > 0) {
                pooledConnectionImpl = (PooledConnectionImpl)this.available.pop();
                try {
                    pooledConnectionImpl.close();
                }
                catch (SQLException sQLException) {}
            }
            this.available = null;
            while (true) {
                if (this.used.size() <= 0) {
                    this.used = null;
                    // MONITOREXIT @DISABLED, blocks:[3, 7, 8] lbl14 : MonitorExitStatement: MONITOREXIT : var1_1
                    this.removeStoredDataSource();
                    return;
                }
                pooledConnectionImpl = (PooledConnectionImpl)this.used.pop();
                pooledConnectionImpl.removeConnectionEventListener(this.connectionEventListener);
                try {
                    pooledConnectionImpl.close();
                }
                catch (SQLException sQLException) {
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeStoredDataSource() {
        Map map = dataSources;
        synchronized (map) {
            dataSources.remove(this.dataSourceName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection getPooledConnection() throws SQLException {
        PooledConnection pooledConnection = null;
        Object object = this.lock;
        synchronized (object) {
            if (this.available == null) {
                throw new PSQLException(GT.tr("DataSource has been closed."), PSQLState.CONNECTION_DOES_NOT_EXIST);
            }
            while (true) {
                if (this.available.size() > 0) {
                    pooledConnection = (PooledConnection)this.available.pop();
                    this.used.push(pooledConnection);
                    break;
                }
                if (this.maxConnections == 0 || this.used.size() < this.maxConnections) {
                    pooledConnection = this.source.getPooledConnection();
                    this.used.push(pooledConnection);
                    break;
                }
                try {
                    this.lock.wait(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        pooledConnection.addConnectionEventListener(this.connectionEventListener);
        return pooledConnection.getConnection();
    }

    public Reference getReference() throws NamingException {
        Reference reference = super.getReference();
        reference.add(new StringRefAddr("dataSourceName", this.dataSourceName));
        if (this.initialConnections > 0) {
            reference.add(new StringRefAddr("initialConnections", Integer.toString(this.initialConnections)));
        }
        if (this.maxConnections > 0) {
            reference.add(new StringRefAddr("maxConnections", Integer.toString(this.maxConnections)));
        }
        return reference;
    }
}

