/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.core.v3;

import com.vertica.core.ParameterList;
import com.vertica.core.v3.SimpleParameterList;
import com.vertica.core.v3.V3ParameterList;
import com.vertica.util.GT;
import com.vertica.util.PSQLException;
import com.vertica.util.PSQLState;
import java.io.InputStream;
import java.sql.SQLException;

class CompositeParameterList
implements V3ParameterList {
    private final int total;
    private final SimpleParameterList[] subparams;
    private final int[] offsets;

    CompositeParameterList(SimpleParameterList[] simpleParameterListArray, int[] nArray) {
        this.subparams = simpleParameterListArray;
        this.offsets = nArray;
        this.total = nArray[nArray.length - 1] + simpleParameterListArray[nArray.length - 1].getInParameterCount();
    }

    private final int findSubParam(int n) throws SQLException {
        if (n < 1 || n > this.total) {
            throw new PSQLException(GT.tr("The column index is out of range: {0}, number of columns: {1}.", new Object[]{new Integer(n), new Integer(this.total)}), PSQLState.INVALID_PARAMETER_VALUE);
        }
        for (int i = this.offsets.length - 1; i >= 0; --i) {
            if (this.offsets[i] >= n) continue;
            return i;
        }
        throw new IllegalArgumentException("I am confused; can't find a subparam for index " + n);
    }

    public void registerOutParameter(int n, int n2) {
    }

    public int getDirection(int n) {
        return 0;
    }

    public int getParameterCount() {
        return this.total;
    }

    public int getInParameterCount() {
        return this.total;
    }

    public int getOutParameterCount() {
        return 0;
    }

    public int[] getTypeOIDs() {
        int[] nArray = new int[this.total];
        for (int i = 0; i < this.offsets.length; ++i) {
            int[] nArray2 = this.subparams[i].getTypeOIDs();
            System.arraycopy(nArray2, 0, nArray, this.offsets[i], nArray2.length);
        }
        return nArray;
    }

    public void setIntParameter(int n, int n2) throws SQLException {
        int n3 = this.findSubParam(n);
        this.subparams[n3].setIntParameter(n - this.offsets[n3], n2);
    }

    public void setLiteralParameter(int n, String string, int n2) throws SQLException {
        int n3 = this.findSubParam(n);
        this.subparams[n3].setStringParameter(n - this.offsets[n3], string, n2);
    }

    public void setStringParameter(int n, String string, int n2) throws SQLException {
        int n3 = this.findSubParam(n);
        this.subparams[n3].setStringParameter(n - this.offsets[n3], string, n2);
    }

    public void setBytea(int n, byte[] byArray, int n2, int n3) throws SQLException {
        int n4 = this.findSubParam(n);
        this.subparams[n4].setBytea(n - this.offsets[n4], byArray, n2, n3);
    }

    public void setBytea(int n, InputStream inputStream, int n2) throws SQLException {
        int n3 = this.findSubParam(n);
        this.subparams[n3].setBytea(n - this.offsets[n3], inputStream, n2);
    }

    public void setNull(int n, int n2) throws SQLException {
        int n3 = this.findSubParam(n);
        this.subparams[n3].setNull(n - this.offsets[n3], n2);
    }

    public String toString(int n) {
        try {
            int n2 = this.findSubParam(n);
            return this.subparams[n2].toString(n - this.offsets[n2]);
        }
        catch (SQLException sQLException) {
            throw new IllegalStateException(sQLException.getMessage());
        }
    }

    public ParameterList copy() {
        SimpleParameterList[] simpleParameterListArray = new SimpleParameterList[this.subparams.length];
        for (int i = 0; i < this.subparams.length; ++i) {
            simpleParameterListArray[i] = (SimpleParameterList)this.subparams[i].copy();
        }
        return new CompositeParameterList(simpleParameterListArray, this.offsets);
    }

    public void clear() {
        for (int i = 0; i < this.subparams.length; ++i) {
            this.subparams[i].clear();
        }
    }

    public SimpleParameterList[] getSubparams() {
        return this.subparams;
    }

    public void checkAllParametersSet() throws SQLException {
        for (int i = 0; i < this.subparams.length; ++i) {
            this.subparams[i].checkAllParametersSet();
        }
    }

    public String toBatchString(String string) {
        return null;
    }

    public byte[] toNativeBatchString(boolean bl) {
        return null;
    }

    public int getNativeBufferSize() {
        return 0;
    }
}

