/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.core.v2;

import com.vertica.Driver;
import com.vertica.core.BaseStatement;
import com.vertica.core.Field;
import com.vertica.core.Logger;
import com.vertica.core.Notification;
import com.vertica.core.PGStream;
import com.vertica.core.ParameterList;
import com.vertica.core.Query;
import com.vertica.core.QueryExecutor;
import com.vertica.core.ResultCursor;
import com.vertica.core.ResultHandler;
import com.vertica.core.VectorTuple;
import com.vertica.core.v2.FastpathParameterList;
import com.vertica.core.v2.ProtocolConnectionImpl;
import com.vertica.core.v2.SimpleParameterList;
import com.vertica.core.v2.V2Query;
import com.vertica.util.GT;
import com.vertica.util.IOStream;
import com.vertica.util.PSQLException;
import com.vertica.util.PSQLState;
import java.io.IOException;
import java.io.Writer;
import java.sql.SQLException;
import java.sql.SQLWarning;

public class QueryExecutorImpl
implements QueryExecutor {
    private final ProtocolConnectionImpl protoConnection;
    private final PGStream pgStream;
    private final Logger logger;
    private BaseStatement stmt;

    public QueryExecutorImpl(ProtocolConnectionImpl protocolConnectionImpl, PGStream pGStream, Logger logger) {
        this.protoConnection = protocolConnectionImpl;
        this.pgStream = pGStream;
        this.logger = logger;
    }

    public Query createSimpleQuery(String string) {
        return new V2Query(string, false);
    }

    public Query createParameterizedQuery(String string) {
        return new V2Query(string, true);
    }

    public ParameterList createFastpathParameters(int n) {
        return new FastpathParameterList(n);
    }

    public synchronized byte[] fastpathCall(int n, ParameterList parameterList, boolean bl) throws SQLException {
        if (this.protoConnection.getTransactionState() == 0 && !bl) {
            if (this.logger.logDebug()) {
                this.logger.debug("Issuing BEGIN before fastpath call.");
            }
            ResultHandler resultHandler = new ResultHandler(){
                private boolean sawBegin = false;
                private SQLException sqle = null;

                public void handleResultRows(Query query, Field[] fieldArray, VectorTuple vectorTuple, ResultCursor resultCursor) {
                }

                public void handleCommandStatus(String string, int n, long l) {
                    if (!this.sawBegin) {
                        if (!string.equals("BEGIN")) {
                            this.handleError(new PSQLException(GT.tr("Expected command status BEGIN, got {0}.", string), PSQLState.PROTOCOL_VIOLATION));
                        }
                        this.sawBegin = true;
                    } else {
                        this.handleError(new PSQLException(GT.tr("Unexpected command status: {0}.", string), PSQLState.PROTOCOL_VIOLATION));
                    }
                }

                public void handleWarning(SQLWarning sQLWarning) {
                    this.handleError(sQLWarning);
                }

                public void handleError(SQLException sQLException) {
                    if (this.sqle == null) {
                        this.sqle = sQLException;
                    } else {
                        this.sqle.setNextException(sQLException);
                    }
                }

                public void handleCompletion() throws SQLException {
                    if (this.sqle != null) {
                        throw this.sqle;
                    }
                }
            };
            try {
                V2Query v2Query = (V2Query)this.createSimpleQuery("");
                SimpleParameterList simpleParameterList = (SimpleParameterList)v2Query.createParameterList();
                this.sendQuery(v2Query, simpleParameterList, "BEGIN");
                this.processResults(v2Query, resultHandler, 0);
            }
            catch (IOException iOException) {
                throw new PSQLException(GT.tr("An I/O error occured while sending to the backend."), PSQLState.CONNECTION_FAILURE, (Throwable)iOException);
            }
        }
        try {
            this.sendFastpathCall(n, (FastpathParameterList)parameterList);
            return this.receiveFastpathResult();
        }
        catch (IOException iOException) {
            throw new PSQLException(GT.tr("An I/O error occured while sending to the backend."), PSQLState.CONNECTION_FAILURE, (Throwable)iOException);
        }
    }

    private void sendFastpathCall(int n, FastpathParameterList fastpathParameterList) throws IOException {
        int n2 = fastpathParameterList.getParameterCount();
        if (this.logger.logDebug()) {
            this.logger.debug(" FE=> FastpathCall(fnid=" + n + ",paramCount=" + n2 + ")");
        }
        this.pgStream.SendChar(70);
        this.pgStream.SendChar(0);
        this.pgStream.SendInteger4(n);
        this.pgStream.SendInteger4(n2);
        for (int i = 1; i <= n2; ++i) {
            fastpathParameterList.writeV2FastpathValue(i, this.pgStream);
        }
        this.pgStream.flush();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void processNotifies() throws SQLException {
        if (this.protoConnection.getTransactionState() != 0) {
            return;
        }
        try {
            int n;
            block7: while (this.pgStream.hasMessagePending()) {
                n = this.pgStream.ReceiveChar();
                switch (n) {
                    case 65: {
                        this.receiveAsyncNotify();
                        continue block7;
                    }
                    case 69: {
                        throw this.receiveErrorMessage();
                    }
                    case 78: {
                        this.protoConnection.addWarning(this.receiveNotification());
                        continue block7;
                    }
                }
            }
            return;
            throw new PSQLException(GT.tr("Unknown Response Type {0}.", new Character((char)n)), PSQLState.CONNECTION_FAILURE);
        }
        catch (IOException iOException) {
            throw new PSQLException(GT.tr("An I/O error occured while sending to the backend."), PSQLState.CONNECTION_FAILURE, (Throwable)iOException);
        }
    }

    private byte[] receiveFastpathResult() throws IOException, SQLException {
        SQLException sQLException = null;
        boolean bl = false;
        byte[] byArray = null;
        block7: while (!bl) {
            int n = this.pgStream.ReceiveChar();
            switch (n) {
                case 65: {
                    this.receiveAsyncNotify();
                    continue block7;
                }
                case 69: {
                    SQLException sQLException2 = this.receiveErrorMessage();
                    if (sQLException == null) {
                        sQLException = sQLException2;
                        continue block7;
                    }
                    sQLException.setNextException(sQLException2);
                    continue block7;
                }
                case 78: {
                    this.protoConnection.addWarning(this.receiveNotification());
                    continue block7;
                }
                case 86: {
                    n = this.pgStream.ReceiveChar();
                    if (n == 71) {
                        if (this.logger.logDebug()) {
                            this.logger.debug(" <=BE FastpathResult");
                        }
                        int n2 = this.pgStream.ReceiveIntegerR(4);
                        byArray = this.pgStream.Receive(n2);
                        n = this.pgStream.ReceiveChar();
                    } else if (this.logger.logDebug()) {
                        this.logger.debug(" <=BE FastpathVoidResult");
                    }
                    if (n == 48) continue block7;
                    throw new PSQLException(GT.tr("Unknown Response Type {0}.", new Character((char)n)), PSQLState.CONNECTION_FAILURE);
                }
                case 90: {
                    if (this.logger.logDebug()) {
                        this.logger.debug(" <=BE ReadyForQuery");
                    }
                    bl = true;
                    continue block7;
                }
            }
            throw new PSQLException(GT.tr("Unknown Response Type {0}.", new Character((char)n)), PSQLState.CONNECTION_FAILURE);
        }
        if (sQLException != null) {
            throw sQLException;
        }
        return byArray;
    }

    public synchronized void execute(Query query, ParameterList parameterList, ResultHandler resultHandler, int n, int n2, int n3) throws SQLException {
        this.execute((V2Query)query, (SimpleParameterList)parameterList, resultHandler, n, n3);
    }

    public synchronized void execute(Query[] queryArray, ParameterList[] parameterListArray, ResultHandler resultHandler, int n, int n2, int n3) throws SQLException {
        final ResultHandler resultHandler2 = resultHandler;
        resultHandler = new ResultHandler(){

            public void handleResultRows(Query query, Field[] fieldArray, VectorTuple vectorTuple, ResultCursor resultCursor) {
                resultHandler2.handleResultRows(query, fieldArray, vectorTuple, resultCursor);
            }

            public void handleCommandStatus(String string, int n, long l) {
                resultHandler2.handleCommandStatus(string, n, l);
            }

            public void handleWarning(SQLWarning sQLWarning) {
                resultHandler2.handleWarning(sQLWarning);
            }

            public void handleError(SQLException sQLException) {
                resultHandler2.handleError(sQLException);
            }

            public void handleCompletion() throws SQLException {
            }
        };
        for (int i = 0; i < queryArray.length; ++i) {
            this.execute((V2Query)queryArray[i], (SimpleParameterList)parameterListArray[i], resultHandler, n, n3);
        }
        resultHandler2.handleCompletion();
    }

    public void executeWithStream(Query query, IOStream iOStream, ResultHandler resultHandler, int n) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "executeWithStream(...)");
    }

    public void fetch(ResultCursor resultCursor, ResultHandler resultHandler, int n) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "fetch(ResultCursor,ResultHandler,int)");
    }

    public void fetchLRS(ResultCursor resultCursor, ResultHandler resultHandler) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "fetch(ResultCursor,ResultHandler)");
    }

    public void setMaxLRSMemory(int n) {
    }

    public void resetCopyIn(boolean bl) throws SQLException {
    }

    private void execute(V2Query v2Query, SimpleParameterList simpleParameterList, ResultHandler resultHandler, int n, int n2) throws SQLException {
        if ((n2 & 0x20) != 0) {
            return;
        }
        if (simpleParameterList == null) {
            simpleParameterList = (SimpleParameterList)v2Query.createParameterList();
        }
        simpleParameterList.checkAllParametersSet();
        String string = null;
        if (this.protoConnection.getTransactionState() == 0 && (n2 & 0x10) == 0) {
            string = "BEGIN;";
            final ResultHandler resultHandler2 = resultHandler;
            resultHandler = new ResultHandler(){
                private boolean sawBegin = false;

                public void handleResultRows(Query query, Field[] fieldArray, VectorTuple vectorTuple, ResultCursor resultCursor) {
                    if (this.sawBegin) {
                        resultHandler2.handleResultRows(query, fieldArray, vectorTuple, resultCursor);
                    }
                }

                public void handleCommandStatus(String string, int n, long l) {
                    if (!this.sawBegin) {
                        if (!string.equals("BEGIN")) {
                            this.handleError(new PSQLException(GT.tr("Expected command status BEGIN, got {0}.", string), PSQLState.PROTOCOL_VIOLATION));
                        }
                        this.sawBegin = true;
                    } else {
                        resultHandler2.handleCommandStatus(string, n, l);
                    }
                }

                public void handleWarning(SQLWarning sQLWarning) {
                    resultHandler2.handleWarning(sQLWarning);
                }

                public void handleError(SQLException sQLException) {
                    resultHandler2.handleError(sQLException);
                }

                public void handleCompletion() throws SQLException {
                    resultHandler2.handleCompletion();
                }
            };
        }
        try {
            this.sendQuery(v2Query, simpleParameterList, string);
            this.processResults(v2Query, resultHandler, n);
        }
        catch (IOException iOException) {
            this.protoConnection.close();
            resultHandler.handleError(new PSQLException(GT.tr("An I/O error occured while sending to the backend."), PSQLState.CONNECTION_FAILURE, (Throwable)iOException));
        }
        resultHandler.handleCompletion();
    }

    protected void sendQuery(V2Query v2Query, SimpleParameterList simpleParameterList, String string) throws IOException {
        if (this.logger.logDebug()) {
            this.logger.debug(" FE=> Query(\"" + (string == null ? "" : string) + v2Query.toString(simpleParameterList) + "\")");
        }
        this.pgStream.SendChar(81);
        Writer writer = this.pgStream.getEncodingWriter();
        if (string != null) {
            writer.write(string);
        }
        String[] stringArray = v2Query.getFragments();
        for (int i = 0; i < stringArray.length; ++i) {
            writer.write(stringArray[i]);
            if (i >= simpleParameterList.getParameterCount()) continue;
            simpleParameterList.writeV2Value(i + 1, writer);
        }
        writer.write(0);
        this.pgStream.flush();
    }

    /*
     * Unable to fully structure code
     */
    protected void processResults(Query var1_1, ResultHandler var2_2, int var3_3) throws IOException {
        var4_4 = null;
        var5_5 = null;
        var6_6 = false;
        block20: while (!var6_6) {
            var7_7 = this.pgStream.ReceiveChar();
            switch (var7_7) {
                case 65: {
                    this.receiveAsyncNotify();
                    break;
                }
                case 66: {
                    if (var4_4 == null) {
                        throw new IOException("Data transfer before field metadata");
                    }
                    if (this.logger.logDebug()) {
                        this.logger.debug(" <=BE BinaryRow");
                    }
                    var8_8 = null;
                    try {
                        var8_8 = this.pgStream.ReceiveTupleV2(var4_4.length, true);
                    }
                    catch (OutOfMemoryError var9_9) {
                        if (var3_3 != 0 && var5_5.size() >= var3_3) ** GOTO lbl22
                        var2_2.handleError(new PSQLException(GT.tr("Ran out of memory retrieving query results."), PSQLState.OUT_OF_MEMORY, (Throwable)var9_9));
                    }
lbl22:
                    // 4 sources

                    for (var9_10 = 0; var9_10 < var4_4.length; ++var9_10) {
                        var4_4[var9_10].setFormat(1);
                    }
                    if (var3_3 != 0 && var5_5.size() >= var3_3) continue block20;
                    try {
                        var5_5.addElement(var8_8);
                    }
                    catch (PSQLException var9_11) {
                        var2_2.handleError(var9_11);
                    }
                    break;
                }
                case 67: {
                    var8_8 = this.pgStream.ReceiveString();
                    if (this.logger.logDebug()) {
                        this.logger.debug(" <=BE CommandStatus(" + (String)var8_8 + ")");
                    }
                    if (var4_4 != null) {
                        var2_2.handleResultRows(var1_1, var4_4, var5_5, null);
                        var4_4 = null;
                        break;
                    }
                    this.interpretCommandStatus((String)var8_8, var2_2);
                    break;
                }
                case 68: {
                    if (var4_4 == null) {
                        throw new IOException("Data transfer before field metadata");
                    }
                    var9_12 = null;
                    try {
                        var9_12 = this.pgStream.ReceiveTupleV2(var4_4.length, false);
                    }
                    catch (OutOfMemoryError var10_15) {
                        if (var3_3 != 0 && var5_5.size() >= var3_3) ** GOTO lbl52
                        var2_2.handleError(new PSQLException(GT.tr("Ran out of memory retrieving query results."), PSQLState.OUT_OF_MEMORY, (Throwable)var10_15));
                    }
lbl52:
                    // 3 sources

                    if (var3_3 != 0 && var5_5.size() >= var3_3) continue block20;
                    try {
                        var5_5.addElement((Object)var9_12);
                    }
                    catch (PSQLException var10_16) {
                        var2_2.handleError(var10_16);
                        var6_6 = true;
                    }
                    break;
                }
                case 69: {
                    var2_2.handleError(this.receiveErrorMessage());
                    break;
                }
                case 73: {
                    if (this.logger.logDebug()) {
                        this.logger.debug(" <=BE EmptyQuery");
                    }
                    if ((var7_7 = this.pgStream.ReceiveChar()) == 0) continue block20;
                    throw new IOException("Expected \\0 after EmptyQuery, got: " + var7_7);
                }
                case 78: {
                    var2_2.handleWarning(this.receiveNotification());
                    break;
                }
                case 80: {
                    var9_13 = this.pgStream.ReceiveString();
                    if (!this.logger.logDebug()) continue block20;
                    this.logger.debug(" <=BE PortalName(" + var9_13 + ")");
                    break;
                }
                case 84: {
                    var4_4 = this.receiveFields();
                    var5_5 = new VectorTuple(this.logger);
                    break;
                }
                case 90: {
                    if (this.logger.logDebug()) {
                        this.logger.debug(" <=BE ReadyForQuery");
                    }
                    var6_6 = true;
                    break;
                }
                default: {
                    throw new IOException("Unexpected packet type: " + var7_7);
                }
            }
        }
    }

    private Field[] receiveFields() throws IOException {
        int n = this.pgStream.ReceiveIntegerR(2);
        Field[] fieldArray = new Field[n];
        if (this.logger.logDebug()) {
            this.logger.debug(" <=BE RowDescription(" + fieldArray.length + ")");
        }
        for (int i = 0; i < fieldArray.length; ++i) {
            String string = this.pgStream.ReceiveString();
            int n2 = this.pgStream.ReceiveIntegerR(4);
            int n3 = this.pgStream.ReceiveIntegerR(2);
            int n4 = this.pgStream.ReceiveIntegerR(4);
            fieldArray[i] = new Field(string, string, n2, n3, n4, 0L, "", "", 0, 2);
        }
        return fieldArray;
    }

    private void receiveAsyncNotify() throws IOException {
        int n = this.pgStream.ReceiveIntegerR(4);
        String string = this.pgStream.ReceiveString();
        if (this.logger.logDebug()) {
            this.logger.debug(" <=BE AsyncNotify(pid=" + n + ",msg=" + string + ")");
        }
        this.protoConnection.addNotification(new Notification(string, n));
    }

    private SQLException receiveErrorMessage() throws IOException {
        String string = this.pgStream.ReceiveString().trim();
        if (this.logger.logDebug()) {
            this.logger.debug(" <=BE ErrorResponse(" + string + ")");
        }
        return new PSQLException(string, PSQLState.UNKNOWN_STATE);
    }

    private SQLWarning receiveNotification() throws IOException {
        String string = this.pgStream.ReceiveString();
        int n = string.indexOf(":");
        string = string.substring(n + 1).trim();
        if (this.logger.logDebug()) {
            this.logger.debug(" <=BE NoticeResponse(" + string + ")");
        }
        return new SQLWarning(string);
    }

    private void interpretCommandStatus(String string, ResultHandler resultHandler) throws IOException {
        int n = 0;
        long l = 0L;
        if (string.equals("BEGIN")) {
            this.protoConnection.setTransactionState(1);
        } else if (string.equals("COMMIT") || string.equals("ROLLBACK")) {
            this.protoConnection.setTransactionState(0);
        } else if (string.startsWith("INSERT") || string.startsWith("UPDATE") || string.startsWith("DELETE") || string.startsWith("MOVE")) {
            try {
                n = Integer.parseInt(string.substring(1 + string.lastIndexOf(32)));
                if (string.startsWith("INSERT")) {
                    l = Long.parseLong(string.substring(1 + string.indexOf(32), string.lastIndexOf(32)));
                }
            }
            catch (NumberFormatException numberFormatException) {
                resultHandler.handleError(new PSQLException(GT.tr("Unable to interpret the update count in command completion tag: {0}.", string), PSQLState.CONNECTION_FAILURE));
                return;
            }
        }
        resultHandler.handleCommandStatus(string, n, l);
    }

    public void setCurrentStatement(BaseStatement baseStatement) {
        this.stmt = baseStatement;
    }

    public BaseStatement getCurrentStatement() {
        return this.stmt;
    }
}

