/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.core.types;

import com.vertica.core.types.PGBigDecimal;
import com.vertica.core.types.PGBoolean;
import com.vertica.core.types.PGFloat;
import com.vertica.core.types.PGInteger;
import com.vertica.core.types.PGLong;
import com.vertica.core.types.PGShort;
import com.vertica.core.types.PGString;
import com.vertica.core.types.PGType;
import com.vertica.core.types.PGUnknown;
import com.vertica.util.GT;
import com.vertica.util.PSQLException;
import com.vertica.util.PSQLState;
import java.math.BigDecimal;

public class PGDouble
implements PGType {
    private Double val;

    protected PGDouble(Double d) {
        this.val = d;
    }

    public static PGType castToServerType(Double d, int n) throws PSQLException {
        try {
            switch (n) {
                case -7: {
                    return new PGBoolean(d == 0.0 ? Boolean.FALSE : Boolean.TRUE);
                }
                case -5: {
                    return new PGLong(new Long(d.longValue()));
                }
                case 4: {
                    return new PGInteger(new Integer(d.intValue()));
                }
                case -6: 
                case 5: {
                    return new PGShort(new Short(d.shortValue()));
                }
                case -1: 
                case 12: {
                    return new PGString(d.toString());
                }
                case 6: 
                case 8: {
                    return new PGDouble(d);
                }
                case 7: {
                    return new PGFloat(new Float(d.floatValue()));
                }
                case 2: 
                case 3: {
                    return new PGBigDecimal(new BigDecimal(d.toString()));
                }
            }
            return new PGUnknown(d);
        }
        catch (Exception exception) {
            throw new PSQLException(GT.tr("Cannot convert an instance of {0} to type {1}", new Object[]{d.getClass().getName(), "Types.OTHER"}), PSQLState.INVALID_PARAMETER_TYPE, (Throwable)exception);
        }
    }

    public String toString() {
        return this.val.toString();
    }
}

