/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.core.types;

import com.vertica.core.types.PGBoolean;
import com.vertica.core.types.PGInteger;
import com.vertica.core.types.PGLong;
import com.vertica.core.types.PGShort;
import com.vertica.core.types.PGString;
import com.vertica.core.types.PGType;
import com.vertica.core.types.PGUnknown;
import com.vertica.util.GT;
import com.vertica.util.PSQLException;
import com.vertica.util.PSQLState;
import java.math.BigDecimal;

public class PGBigDecimal
implements PGType {
    private BigDecimal val;

    protected PGBigDecimal(BigDecimal bigDecimal) {
        this.val = new BigDecimal(bigDecimal.toString());
    }

    public static PGType castToServerType(BigDecimal bigDecimal, int n) throws PSQLException {
        try {
            switch (n) {
                case -7: {
                    return new PGBoolean(bigDecimal.doubleValue() == 0.0 ? Boolean.FALSE : Boolean.TRUE);
                }
                case -5: {
                    return new PGLong(new Long(bigDecimal.longValue()));
                }
                case 4: {
                    return new PGInteger(new Integer(bigDecimal.intValue()));
                }
                case -6: 
                case 5: {
                    return new PGShort(new Short(bigDecimal.shortValue()));
                }
                case -1: 
                case 12: {
                    return new PGString(bigDecimal.toString());
                }
                case 2: 
                case 3: 
                case 6: 
                case 7: 
                case 8: {
                    return new PGBigDecimal(bigDecimal);
                }
            }
            return new PGUnknown(bigDecimal);
        }
        catch (Exception exception) {
            throw new PSQLException(GT.tr("Cannot convert an instance of {0} to type {1}", new Object[]{bigDecimal.getClass().getName(), "Types.OTHER"}), PSQLState.INVALID_PARAMETER_TYPE, (Throwable)exception);
        }
    }

    public String toString() {
        return this.val.toString();
    }
}

