/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.core;

import java.io.PrintWriter;
import java.sql.DriverManager;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Date;

public final class Logger {
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss.SSS ");
    private final FieldPosition dummyPosition = new FieldPosition(0);
    private final StringBuffer buffer = new StringBuffer();
    private final String connectionIDString;
    private int level = 0;

    public Logger() {
        this.connectionIDString = "(driver) ";
    }

    public Logger(int n) {
        this.connectionIDString = "(" + n + ") ";
    }

    public void setLogLevel(int n) {
        this.level = n;
    }

    public int getLogLevel() {
        return this.level;
    }

    public boolean logDebug() {
        return this.level >= 2;
    }

    public boolean logInfo() {
        return this.level >= 1;
    }

    public void debug(String string) {
        this.debug(string, null);
    }

    public void debug(String string, Throwable throwable) {
        if (this.logDebug()) {
            this.log(string, throwable);
        }
    }

    public void info(String string) {
        this.info(string, null);
    }

    public void info(String string, Throwable throwable) {
        if (this.logInfo()) {
            this.log(string, throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(String string, Throwable throwable) {
        PrintWriter printWriter = DriverManager.getLogWriter();
        if (printWriter == null) {
            return;
        }
        Logger logger = this;
        synchronized (logger) {
            this.buffer.setLength(0);
            this.dateFormat.format(new Date(), this.buffer, this.dummyPosition);
            this.buffer.append(this.connectionIDString);
            this.buffer.append(string);
            PrintWriter printWriter2 = printWriter;
            synchronized (printWriter2) {
                printWriter.println(this.buffer.toString());
                if (throwable != null) {
                    throwable.printStackTrace(printWriter);
                }
            }
        }
    }
}

