/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.core;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class Field {
    public static final int TEXT_FORMAT = 0;
    public static final int BINARY_FORMAT = 1;
    private final int length;
    private final int oid;
    private final int mod;
    private final String columnLabel;
    private String columnName;
    private Boolean autoIncrement;
    private int format = 0;
    private final long tableOid;
    private String schemaName;
    private String tableName;
    private final int positionInTable;
    private int nullable = 2;

    public Field(String string, int n, int n2, int n3) {
        this(string, string, n, n2, n3, 0L, "", "", 0, 2);
    }

    public Field(String string, int n) {
        this(string, n, 0, -1);
    }

    public Field(String string, String string2, int n, int n2, int n3, long l, String string3, String string4, int n4, int n5) {
        this.columnLabel = string;
        this.columnName = string2;
        this.oid = n;
        this.length = n2;
        this.mod = n3;
        this.tableOid = l;
        this.schemaName = string3;
        this.tableName = string4;
        this.positionInTable = n4;
        this.nullable = n5;
    }

    public int getOID() {
        return this.oid;
    }

    public int getMod() {
        return this.mod;
    }

    public String getColumnLabel() {
        return this.columnLabel;
    }

    public int getLength() {
        return this.length;
    }

    public int getFormat() {
        return this.format;
    }

    public void setFormat(int n) {
        this.format = n;
    }

    public long getTableOid() {
        return this.tableOid;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public int getPositionInTable() {
        return this.positionInTable;
    }

    public int getNullable(Connection connection) throws SQLException {
        return this.nullable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getAutoIncrement(Connection connection) throws SQLException {
        if (this.autoIncrement != null) {
            return this.autoIncrement;
        }
        if (this.tableOid == 0L || this.positionInTable == 0) {
            this.autoIncrement = Boolean.FALSE;
            return this.autoIncrement;
        }
        ResultSet resultSet = null;
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement("SELECT column_default FROM columns WHERE table_id = ? and ordinal_position = ? AND column_default ILIKE '%_nextval_%'");
            preparedStatement.setLong(1, this.tableOid);
            preparedStatement.setInt(2, this.positionInTable);
            resultSet = preparedStatement.executeQuery();
            this.autoIncrement = resultSet.next() ? Boolean.TRUE : Boolean.FALSE;
            boolean bl = this.autoIncrement;
            return bl;
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getColumnName(Connection connection) throws SQLException {
        if (this.columnName != null) {
            return this.columnName;
        }
        this.columnName = "";
        if (this.tableOid == 0L || this.positionInTable == 0) {
            return this.columnName;
        }
        ResultSet resultSet = null;
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement("SELECT column_name FROM columns WHERE table_id = ? AND ordinal_position = ?");
            preparedStatement.setLong(1, this.tableOid);
            preparedStatement.setInt(2, this.positionInTable);
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                this.columnName = resultSet.getString(1);
            }
            String string = this.columnName;
            return string;
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
    }
}

