/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.core;

import com.vertica.core.UTF8Encoding;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Hashtable;

public class Encoding {
    private static final Encoding DEFAULT_ENCODING = new Encoding(null);
    private static final Hashtable encodings = new Hashtable();
    private final String encoding;

    protected Encoding(String string) {
        this.encoding = string;
    }

    public static Encoding getJVMEncoding(String string) {
        if (Encoding.isAvailable(string)) {
            if (string.equals("UTF-8") || string.equals("UTF8")) {
                return new UTF8Encoding(string);
            }
            return new Encoding(string);
        }
        return Encoding.defaultEncoding();
    }

    public static Encoding getDatabaseEncoding(String string) {
        if (encodings.containsKey(string)) {
            String[] stringArray = (String[])encodings.get(string);
            for (int i = 0; i < stringArray.length; ++i) {
                if (!Encoding.isAvailable(stringArray[i])) continue;
                return new Encoding(stringArray[i]);
            }
        }
        if (Encoding.isAvailable(string)) {
            return new Encoding(string);
        }
        return Encoding.defaultEncoding();
    }

    public String name() {
        return this.encoding;
    }

    public byte[] encode(String string) throws IOException {
        if (string == null) {
            return null;
        }
        if (this.encoding == null) {
            return string.getBytes();
        }
        return string.getBytes(this.encoding);
    }

    public String decode(byte[] byArray, int n, int n2) throws IOException {
        if (this.encoding == null) {
            return new String(byArray, n, n2);
        }
        return new String(byArray, n, n2, this.encoding);
    }

    public String decode(byte[] byArray) throws IOException {
        return this.decode(byArray, 0, byArray.length);
    }

    public Reader getDecodingReader(InputStream inputStream) throws IOException {
        if (this.encoding == null) {
            return new InputStreamReader(inputStream);
        }
        return new InputStreamReader(inputStream, this.encoding);
    }

    public Writer getEncodingWriter(OutputStream outputStream) throws IOException {
        if (this.encoding == null) {
            return new OutputStreamWriter(outputStream);
        }
        return new OutputStreamWriter(outputStream, this.encoding);
    }

    public static Encoding defaultEncoding() {
        return DEFAULT_ENCODING;
    }

    private static boolean isAvailable(String string) {
        try {
            "DUMMY".getBytes(string);
            return true;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return false;
        }
    }

    public String toString() {
        return this.encoding == null ? "<default JVM encoding>" : this.encoding;
    }

    static {
        encodings.put("SQL_ASCII", new String[]{"ASCII", "us-ascii"});
        encodings.put("UNICODE", new String[]{"UTF-8", "UTF8"});
        encodings.put("UTF8", new String[]{"UTF-8", "UTF8"});
        encodings.put("LATIN1", new String[]{"ISO8859_1"});
        encodings.put("LATIN2", new String[]{"ISO8859_2"});
        encodings.put("LATIN3", new String[]{"ISO8859_3"});
        encodings.put("LATIN4", new String[]{"ISO8859_4"});
        encodings.put("ISO_8859_5", new String[]{"ISO8859_5"});
        encodings.put("ISO_8859_6", new String[]{"ISO8859_6"});
        encodings.put("ISO_8859_7", new String[]{"ISO8859_7"});
        encodings.put("ISO_8859_8", new String[]{"ISO8859_8"});
        encodings.put("LATIN5", new String[]{"ISO8859_9"});
        encodings.put("LATIN7", new String[]{"ISO8859_13"});
        encodings.put("LATIN9", new String[]{"ISO8859_15_FDIS"});
        encodings.put("EUC_JP", new String[]{"EUC_JP"});
        encodings.put("EUC_CN", new String[]{"EUC_CN"});
        encodings.put("EUC_KR", new String[]{"EUC_KR"});
        encodings.put("JOHAB", new String[]{"Johab"});
        encodings.put("EUC_TW", new String[]{"EUC_TW"});
        encodings.put("SJIS", new String[]{"MS932", "SJIS"});
        encodings.put("BIG5", new String[]{"Big5", "MS950", "Cp950"});
        encodings.put("GBK", new String[]{"GBK", "MS936"});
        encodings.put("UHC", new String[]{"MS949", "Cp949", "Cp949C"});
        encodings.put("TCVN", new String[]{"Cp1258"});
        encodings.put("WIN1256", new String[]{"Cp1256"});
        encodings.put("WIN1250", new String[]{"Cp1250"});
        encodings.put("WIN874", new String[]{"MS874", "Cp874"});
        encodings.put("WIN", new String[]{"Cp1251"});
        encodings.put("ALT", new String[]{"Cp866"});
        encodings.put("KOI8", new String[]{"KOI8_U", "KOI8_R"});
        encodings.put("UNKNOWN", new String[0]);
        encodings.put("MULE_INTERNAL", new String[0]);
        encodings.put("LATIN6", new String[0]);
        encodings.put("LATIN8", new String[0]);
        encodings.put("LATIN10", new String[0]);
    }
}

