/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.jdbc.teradata;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.teiid.language.ColumnReference;
import org.teiid.language.Command;
import org.teiid.language.DerivedColumn;
import org.teiid.language.Expression;
import org.teiid.language.Function;
import org.teiid.language.LanguageFactory;
import org.teiid.language.Literal;
import org.teiid.language.QueryExpression;
import org.teiid.language.Select;
import org.teiid.language.SortSpecification;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.ExecutionFactory;
import org.teiid.translator.Translator;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.TypeFacility;
import org.teiid.translator.jdbc.AliasModifier;
import org.teiid.translator.jdbc.ConvertModifier;
import org.teiid.translator.jdbc.FunctionModifier;
import org.teiid.translator.jdbc.JDBCExecutionFactory;
import org.teiid.translator.jdbc.SQLConversionVisitor;
import org.teiid.translator.jdbc.teradata.TeradataSQLConversionVisitor;

@Translator(name="teradata", description="A translator for Teradata Database")
public class TeradataExecutionFactory
extends JDBCExecutionFactory {
    public static String TERADATA = "teradata";
    protected ConvertModifier convert = new ConvertModifier();

    public TeradataExecutionFactory() {
        this.setSupportsOuterJoins(false);
    }

    @Override
    public void start() throws TranslatorException {
        super.start();
        this.convert.addTypeMapping("byteint", 3, 4, 2);
        this.convert.addTypeMapping("double precision", 9);
        this.convert.addTypeMapping("numeric(18,0)", 7);
        this.convert.addTypeMapping("char(1)", 1);
        this.convert.addConvert(13, 12, new CastModifier("TIME"));
        this.convert.addConvert(13, 11, new CastModifier("DATE"));
        this.convert.addConvert(12, 13, new CastModifier("TIMESTAMP"));
        this.convert.addConvert(11, 13, new CastModifier("TIMESTAMP"));
        this.convert.addConvert(0, 5, new CastModifier("integer"));
        this.convert.addConvert(0, 10, new CastModifier("decimal(37,5)"));
        this.convert.addConvert(0, 7, new CastModifier("numeric(18,0)"));
        this.convert.addConvert(0, 8, new CastModifier("float"));
        this.convert.addConvert(0, 2, new CastModifier("byteint"));
        this.convert.addConvert(0, 6, new CastModifier("numeric(18,0)"));
        this.convert.addConvert(0, 4, new CastModifier("smallint"));
        this.convert.addConvert(0, 9, new CastModifier("double precision"));
        this.convert.addConvert(0, 3, new CastModifier("byteint"));
        this.convert.addConvert(13, 0, new FunctionModifier(){

            @Override
            public List<?> translate(Function function) {
                return Arrays.asList("cast(cast(", function.getParameters().get(0), " AS FORMAT 'Y4-MM-DDBHH:MI:SSDS(6)') AS VARCHAR(26))");
            }
        });
        this.convert.addConvert(12, 0, new FunctionModifier(){

            @Override
            public List<?> translate(Function function) {
                return Arrays.asList("cast(cast(", function.getParameters().get(0), " AS FORMAT 'HH:MI:SS') AS VARCHAR(9))");
            }
        });
        this.convert.addConvert(11, 0, new FunctionModifier(){

            @Override
            public List<?> translate(Function function) {
                return Arrays.asList("cast(cast(", function.getParameters().get(0), " AS FORMAT 'YYYY-MM-DD') AS VARCHAR(11))");
            }
        });
        this.convert.addTypeMapping("varchar(4000)", 0);
        this.convert.addNumericBooleanConversions();
        this.registerFunctionModifier("convert", this.convert);
        this.registerFunctionModifier("substring", new AliasModifier("substr"));
        this.registerFunctionModifier("log", new AliasModifier("LN"));
        this.registerFunctionModifier("lcase", new AliasModifier("LOWER"));
        this.registerFunctionModifier("ucase", new AliasModifier("UPPER"));
        this.registerFunctionModifier("length", new AliasModifier("character_length"));
        this.registerFunctionModifier("curdate", new AliasModifier("CURRENT_DATE"));
        this.registerFunctionModifier("curtime", new AliasModifier("CURRENT_TIME"));
        this.registerFunctionModifier("year", new ExtractModifier("YEAR"));
        this.registerFunctionModifier("month", new ExtractModifier("MONTH"));
        this.registerFunctionModifier("dayofmonth", new ExtractModifier("DAY"));
        this.registerFunctionModifier("hour", new ExtractModifier("HOUR"));
        this.registerFunctionModifier("minute", new ExtractModifier("MINUTE"));
        this.registerFunctionModifier("second", new ExtractModifier("SECOND"));
        this.registerFunctionModifier("locate", new LocateModifier(this.convert));
        this.registerFunctionModifier("left", new LeftOrRightFunctionModifier(this.getLanguageFactory(), this.convert));
        this.registerFunctionModifier("right", new LeftOrRightFunctionModifier(this.getLanguageFactory(), this.convert));
        this.registerFunctionModifier("cot", new FunctionModifier(){

            @Override
            public List<?> translate(Function function) {
                function.setName("tan");
                return Arrays.asList(TeradataExecutionFactory.this.getLanguageFactory().createFunction("/", new Expression[]{new Literal((Object)1, TypeFacility.RUNTIME_TYPES.INTEGER), function}, TypeFacility.RUNTIME_TYPES.DOUBLE));
            }
        });
        this.registerFunctionModifier("ltrim", new FunctionModifier(){

            @Override
            public List<?> translate(Function function) {
                ArrayList<String> target = new ArrayList<String>();
                target.add("TRIM(LEADING FROM ");
                target.add((String)function.getParameters().get(0));
                target.add(")");
                return target;
            }
        });
        this.registerFunctionModifier("rtrim", new FunctionModifier(){

            @Override
            public List<?> translate(Function function) {
                ArrayList<String> target = new ArrayList<String>();
                target.add("TRIM(TRAILING FROM ");
                target.add((String)function.getParameters().get(0));
                target.add(")");
                return target;
            }
        });
        this.registerFunctionModifier("mod", new FunctionModifier(){

            @Override
            public List<?> translate(Function function) {
                return Arrays.asList(function.getParameters().get(0), " MOD ", function.getParameters().get(1));
            }
        });
        this.addPushDownFunction(TERADATA, "COSH", "float", new String[]{"float"});
        this.addPushDownFunction(TERADATA, "TANH", "float", new String[]{"float"});
        this.addPushDownFunction(TERADATA, "ACOSH", "float", new String[]{"float"});
        this.addPushDownFunction(TERADATA, "ASINH", "float", new String[]{"float"});
        this.addPushDownFunction(TERADATA, "ATANH", "float", new String[]{"float"});
        this.addPushDownFunction(TERADATA, "CHAR2HEXINT", "string", new String[]{"string"});
        this.addPushDownFunction(TERADATA, "INDEX", "integer", new String[]{"string", "string"});
        this.addPushDownFunction(TERADATA, "BYTES", "integer", new String[]{"string"});
        this.addPushDownFunction(TERADATA, "OCTET_LENGTH", "integer", new String[]{"string"});
        this.addPushDownFunction(TERADATA, "HASHAMP", "integer", new String[]{"string"});
        this.addPushDownFunction(TERADATA, "HASHBAKAMP", "integer", new String[]{"string"});
        this.addPushDownFunction(TERADATA, "HASHBUCKET", "integer", new String[]{"string"});
        this.addPushDownFunction(TERADATA, "HASHROW", "integer", new String[]{"string"});
        this.addPushDownFunction(TERADATA, "NULLIFZERO", "bigdecimal", new String[]{"bigdecimal"});
        this.addPushDownFunction(TERADATA, "ZEROIFNULL", "bigdecimal", new String[]{"bigdecimal"});
        this.registerFunctionModifier("cot", new FunctionModifier(){

            @Override
            public List<?> translate(Function function) {
                function.setName("tan");
                return Arrays.asList(TeradataExecutionFactory.this.getLanguageFactory().createFunction("/", new Expression[]{new Literal((Object)1, TypeFacility.RUNTIME_TYPES.INTEGER), function}, TypeFacility.RUNTIME_TYPES.DOUBLE));
            }
        });
        this.registerFunctionModifier("ltrim", new FunctionModifier(){

            @Override
            public List<?> translate(Function function) {
                return Arrays.asList("TRIM(LEADING FROM ", function.getParameters().get(0), ")");
            }
        });
        this.registerFunctionModifier("rtrim", new FunctionModifier(){

            @Override
            public List<?> translate(Function function) {
                return Arrays.asList("TRIM(TRAILING FROM ", function.getParameters().get(0), ")");
            }
        });
        this.registerFunctionModifier("mod", new FunctionModifier(){

            @Override
            public List<?> translate(Function function) {
                return Arrays.asList(function.getParameters().get(0), " MOD ", function.getParameters().get(1));
            }
        });
    }

    @Override
    public SQLConversionVisitor getSQLConversionVisitor() {
        return new TeradataSQLConversionVisitor(this);
    }

    @Override
    public List<String> getSupportedFunctions() {
        ArrayList<String> supportedFunctions = new ArrayList<String>();
        supportedFunctions.addAll(super.getSupportedFunctions());
        supportedFunctions.add("abs");
        supportedFunctions.add("acos");
        supportedFunctions.add("asin");
        supportedFunctions.add("atan");
        supportedFunctions.add("atan2");
        supportedFunctions.add("coalesce");
        supportedFunctions.add("cos");
        supportedFunctions.add("cot");
        supportedFunctions.add("convert");
        supportedFunctions.add("curdate");
        supportedFunctions.add("curtime");
        supportedFunctions.add("dayofmonth");
        supportedFunctions.add("exp");
        supportedFunctions.add("hour");
        supportedFunctions.add("left");
        supportedFunctions.add("locate");
        supportedFunctions.add("log");
        supportedFunctions.add("lcase");
        supportedFunctions.add("ltrim");
        supportedFunctions.add("length");
        supportedFunctions.add("minute");
        supportedFunctions.add("mod");
        supportedFunctions.add("month");
        supportedFunctions.add("nullif");
        supportedFunctions.add("right");
        supportedFunctions.add("rtrim");
        supportedFunctions.add("second");
        supportedFunctions.add("sin");
        supportedFunctions.add("sqrt");
        supportedFunctions.add("substring");
        supportedFunctions.add("tan");
        supportedFunctions.add("trim");
        supportedFunctions.add("ucase");
        supportedFunctions.add("year");
        return supportedFunctions;
    }

    @Override
    public String translateLiteralDate(Date dateValue) {
        return "cast('" + this.formatDateValue(dateValue) + "' AS DATE FORMAT 'yyyy-mm-dd')";
    }

    @Override
    public String translateLiteralTime(Time timeValue) {
        return "cast('" + this.formatDateValue(timeValue) + "' AS TIME(0) FORMAT 'hh:mi:ss')";
    }

    @Override
    public String translateLiteralTimestamp(Timestamp timestampValue) {
        return "cast('" + this.formatDateValue(timestampValue) + "' AS TIMESTAMP(6))";
    }

    @Override
    public boolean supportsScalarSubqueries() {
        return false;
    }

    @Override
    public boolean supportsUnions() {
        return true;
    }

    public boolean supportsIntersect() {
        return true;
    }

    public boolean supportsExcept() {
        return true;
    }

    @Override
    public boolean supportsInlineViews() {
        return true;
    }

    public boolean supportsAggregatesEnhancedNumeric() {
        return true;
    }

    public boolean supportsCommonTableExpressions() {
        return false;
    }

    @Override
    public ExecutionFactory.NullOrder getDefaultNullOrder() {
        return ExecutionFactory.NullOrder.FIRST;
    }

    @Override
    public List<?> translateCommand(Command command, ExecutionContext context) {
        QueryExpression qe;
        if (command instanceof QueryExpression && (qe = (QueryExpression)command).getOrderBy() != null) {
            ColumnReference cr;
            Select select = qe.getProjectedQuery();
            List derivedColumns = select.getDerivedColumns();
            HashMap<String, Integer> positions = new HashMap<String, Integer>();
            int i = 1;
            for (DerivedColumn derivedColumn : derivedColumns) {
                String name = derivedColumn.getAlias();
                if (name == null && derivedColumn.getExpression() instanceof ColumnReference) {
                    cr = (ColumnReference)derivedColumn.getExpression();
                    name = cr.toString();
                }
                positions.put(name, i++);
            }
            for (SortSpecification ss : qe.getOrderBy().getSortSpecifications()) {
                Integer position;
                Expression ex = ss.getExpression();
                if (!(ex instanceof ColumnReference) || (position = (Integer)positions.get((cr = (ColumnReference)ex).toString())) == null) continue;
                ss.setExpression((Expression)new Literal((Object)position, TypeFacility.RUNTIME_TYPES.INTEGER));
            }
        }
        return super.translateCommand(command, context);
    }

    public static class LeftOrRightFunctionModifier
    extends FunctionModifier {
        private LanguageFactory langFactory;
        ConvertModifier convertModifier;

        public LeftOrRightFunctionModifier(LanguageFactory langFactory, ConvertModifier converModifier) {
            this.langFactory = langFactory;
            this.convertModifier = converModifier;
        }

        @Override
        public List<?> translate(Function function) {
            List args = function.getParameters();
            ArrayList<String> target = new ArrayList<String>();
            if (function.getName().equalsIgnoreCase("left")) {
                target.add("substr(");
                target.add((String)args.get(0));
                target.add(",");
                target.add((String)this.langFactory.createLiteral((Object)1, TypeFacility.RUNTIME_TYPES.INTEGER));
                target.add(",");
                target.add((String)args.get(1));
                target.add(")");
            } else if (function.getName().equalsIgnoreCase("right")) {
                target.add("substr(");
                target.add((String)args.get(0));
                target.add(",(character_length(");
                target.add((String)args.get(0));
                target.add(")-");
                target.add((String)args.get(1));
                target.add("+1))");
            }
            return target;
        }
    }

    public static class CastModifier
    extends FunctionModifier {
        private String target;

        public CastModifier(String target) {
            this.target = target;
        }

        @Override
        public List<?> translate(Function function) {
            return Arrays.asList("cast(", function.getParameters().get(0), " AS " + this.target + ")");
        }
    }

    public static class ExtractModifier
    extends FunctionModifier {
        private String type;

        public ExtractModifier(String type) {
            this.type = type;
        }

        @Override
        public List<?> translate(Function function) {
            return Arrays.asList("extract(", this.type, " from ", function.getParameters().get(0), ")");
        }
    }

    public static class LocateModifier
    extends FunctionModifier {
        ConvertModifier convertModifier;

        public LocateModifier(ConvertModifier convertModifier) {
            this.convertModifier = convertModifier;
        }

        @Override
        public List<?> translate(Function function) {
            ArrayList<String> target = new ArrayList<String>();
            Expression expr1 = (Expression)function.getParameters().get(0);
            Expression expr2 = (Expression)function.getParameters().get(1);
            if (function.getParameters().size() > 2) {
                Expression expr3 = (Expression)function.getParameters().get(2);
                target.add("position(");
                target.add((String)expr1);
                target.add(" in ");
                target.add("substr(");
                target.add((String)expr2);
                target.add(",");
                target.add((String)expr3);
                target.add("))");
            } else {
                target.add("position(");
                target.add((String)expr1);
                target.add(" in ");
                target.add((String)expr2);
                target.add(")");
            }
            return target;
        }
    }
}

