/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.jdbc.derby;

import java.util.ArrayList;
import java.util.List;
import org.teiid.translator.Translator;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.jdbc.EscapeSyntaxModifier;
import org.teiid.translator.jdbc.db2.BaseDB2ExecutionFactory;
import org.teiid.translator.jdbc.oracle.LeftOrRightFunctionModifier;

@Translator(name="derby", description="A translator for Apache Derby Database")
public class DerbyExecutionFactory
extends BaseDB2ExecutionFactory {
    public static final String TEN_1 = "10.1";
    public static final String TEN_2 = "10.2";
    public static final String TEN_3 = "10.3";
    public static final String TEN_4 = "10.4";
    public static final String TEN_5 = "10.5";

    public DerbyExecutionFactory() {
        this.setSupportsFullOuterJoins(false);
        this.setDatabaseVersion(TEN_1);
    }

    @Override
    public void start() throws TranslatorException {
        super.start();
        this.registerFunctionModifier("timestampadd", new EscapeSyntaxModifier());
        this.registerFunctionModifier("timestampdiff", new EscapeSyntaxModifier());
        this.registerFunctionModifier("left", new LeftOrRightFunctionModifier(this.getLanguageFactory()));
        this.registerFunctionModifier("concat", new EscapeSyntaxModifier());
    }

    @Override
    public boolean addSourceComment() {
        return false;
    }

    public boolean supportsOrderByNullOrdering() {
        return this.getDatabaseVersion().compareTo(TEN_4) >= 0;
    }

    @Override
    public List<String> getSupportedFunctions() {
        ArrayList<String> supportedFunctions = new ArrayList<String>();
        supportedFunctions.addAll(super.getDefaultSupportedFunctions());
        supportedFunctions.add("ABS");
        if (this.getDatabaseVersion().compareTo(TEN_2) >= 0) {
            supportedFunctions.add("ACOS");
            supportedFunctions.add("ASIN");
            supportedFunctions.add("ATAN");
        }
        if (this.getDatabaseVersion().compareTo(TEN_4) >= 0) {
            supportedFunctions.add("ATAN2");
        }
        if (this.getDatabaseVersion().compareTo(TEN_2) >= 0) {
            supportedFunctions.add("CEILING");
            supportedFunctions.add("COS");
            supportedFunctions.add("COT");
            supportedFunctions.add("DEGREES");
            supportedFunctions.add("EXP");
            supportedFunctions.add("FLOOR");
            supportedFunctions.add("LOG");
            supportedFunctions.add("LOG10");
        }
        supportedFunctions.add("MOD");
        if (this.getDatabaseVersion().compareTo(TEN_2) >= 0) {
            supportedFunctions.add("PI");
            supportedFunctions.add("RADIANS");
            if (this.getDatabaseVersion().compareTo(TEN_4) >= 0) {
                supportedFunctions.add("SIGN");
            }
            supportedFunctions.add("SIN");
        }
        supportedFunctions.add("SQRT");
        supportedFunctions.add("CONCAT");
        supportedFunctions.add("LCASE");
        supportedFunctions.add("LEFT");
        supportedFunctions.add("LENGTH");
        supportedFunctions.add("LOCATE");
        supportedFunctions.add("LTRIM");
        supportedFunctions.add("RTRIM");
        supportedFunctions.add("SUBSTRING");
        if (this.getDatabaseVersion().compareTo(TEN_3) >= 0) {
            supportedFunctions.add("trim");
        }
        supportedFunctions.add("UCASE");
        supportedFunctions.add("DAYOFMONTH");
        supportedFunctions.add("HOUR");
        supportedFunctions.add("MINUTE");
        supportedFunctions.add("MONTH");
        supportedFunctions.add("SECOND");
        supportedFunctions.add("TIMESTAMPADD");
        supportedFunctions.add("TIMESTAMPDIFF");
        supportedFunctions.add("YEAR");
        supportedFunctions.add("CONVERT");
        supportedFunctions.add("IFNULL");
        supportedFunctions.add("COALESCE");
        return supportedFunctions;
    }

    public boolean supportsRowLimit() {
        return this.getDatabaseVersion().compareTo(TEN_5) >= 0;
    }
}

