/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.vote;

import java.util.Vector;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.springframework.security.AccessDeniedException;
import org.springframework.security.Authentication;
import org.springframework.security.ConfigAttribute;
import org.springframework.security.ConfigAttributeDefinition;
import org.springframework.security.SecurityConfig;
import org.springframework.security.vote.AbstractAccessDecisionManager;
import org.springframework.security.vote.AccessDecisionVoter;
import org.springframework.security.vote.DenyAgainVoter;
import org.springframework.security.vote.DenyVoter;
import org.springframework.security.vote.RoleVoter;

public class AbstractAccessDecisionManagerTests
extends TestCase {
    public AbstractAccessDecisionManagerTests() {
    }

    public AbstractAccessDecisionManagerTests(String arg0) {
        super(arg0);
    }

    public static void main(String[] args) {
        TestRunner.run(AbstractAccessDecisionManagerTests.class);
    }

    public final void setUp() throws Exception {
        super.setUp();
    }

    public void testAllowIfAccessDecisionManagerDefaults() throws Exception {
        MockDecisionManagerImpl mock = new MockDecisionManagerImpl();
        AbstractAccessDecisionManagerTests.assertTrue((!mock.isAllowIfAllAbstainDecisions() ? 1 : 0) != 0);
        mock.setAllowIfAllAbstainDecisions(true);
        AbstractAccessDecisionManagerTests.assertTrue((boolean)mock.isAllowIfAllAbstainDecisions());
    }

    public void testDelegatesSupportsClassRequests() throws Exception {
        MockDecisionManagerImpl mock = new MockDecisionManagerImpl();
        Vector<Object> list = new Vector<Object>();
        list.add(new DenyVoter());
        list.add(new MockStringOnlyVoter());
        mock.setDecisionVoters(list);
        AbstractAccessDecisionManagerTests.assertTrue((boolean)mock.supports(new String().getClass()));
        AbstractAccessDecisionManagerTests.assertTrue((!mock.supports(new Integer(7).getClass()) ? 1 : 0) != 0);
    }

    public void testDelegatesSupportsRequests() throws Exception {
        MockDecisionManagerImpl mock = new MockDecisionManagerImpl();
        Vector<Object> list = new Vector<Object>();
        DenyVoter voter = new DenyVoter();
        DenyAgainVoter denyVoter = new DenyAgainVoter();
        list.add(voter);
        list.add(denyVoter);
        mock.setDecisionVoters(list);
        SecurityConfig attr = new SecurityConfig("DENY_AGAIN_FOR_SURE");
        AbstractAccessDecisionManagerTests.assertTrue((boolean)mock.supports((ConfigAttribute)attr));
        SecurityConfig badAttr = new SecurityConfig("WE_DONT_SUPPORT_THIS");
        AbstractAccessDecisionManagerTests.assertTrue((!mock.supports((ConfigAttribute)badAttr) ? 1 : 0) != 0);
    }

    public void testProperlyStoresListOfVoters() throws Exception {
        MockDecisionManagerImpl mock = new MockDecisionManagerImpl();
        Vector<Object> list = new Vector<Object>();
        DenyVoter voter = new DenyVoter();
        DenyAgainVoter denyVoter = new DenyAgainVoter();
        list.add(voter);
        list.add(denyVoter);
        mock.setDecisionVoters(list);
        AbstractAccessDecisionManagerTests.assertEquals((int)list.size(), (int)mock.getDecisionVoters().size());
    }

    public void testRejectsEmptyList() throws Exception {
        MockDecisionManagerImpl mock = new MockDecisionManagerImpl();
        Vector list = new Vector();
        try {
            mock.setDecisionVoters(list);
            AbstractAccessDecisionManagerTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            AbstractAccessDecisionManagerTests.assertTrue((boolean)true);
        }
    }

    public void testRejectsListContainingInvalidObjectTypes() throws Exception {
        MockDecisionManagerImpl mock = new MockDecisionManagerImpl();
        Vector<Object> list = new Vector<Object>();
        DenyVoter voter = new DenyVoter();
        DenyAgainVoter denyVoter = new DenyAgainVoter();
        String notAVoter = "NOT_A_VOTER";
        list.add(voter);
        list.add(notAVoter);
        list.add(denyVoter);
        try {
            mock.setDecisionVoters(list);
            AbstractAccessDecisionManagerTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            AbstractAccessDecisionManagerTests.assertTrue((boolean)true);
        }
    }

    public void testRejectsNullVotersList() throws Exception {
        MockDecisionManagerImpl mock = new MockDecisionManagerImpl();
        try {
            mock.setDecisionVoters(null);
            AbstractAccessDecisionManagerTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            AbstractAccessDecisionManagerTests.assertTrue((boolean)true);
        }
    }

    public void testRoleVoterAlwaysReturnsTrueToSupports() {
        RoleVoter rv = new RoleVoter();
        AbstractAccessDecisionManagerTests.assertTrue((boolean)rv.supports(String.class));
    }

    public void testWillNotStartIfDecisionVotersNotSet() throws Exception {
        MockDecisionManagerImpl mock = new MockDecisionManagerImpl();
        try {
            mock.afterPropertiesSet();
            AbstractAccessDecisionManagerTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            AbstractAccessDecisionManagerTests.assertTrue((boolean)true);
        }
    }

    private class MockStringOnlyVoter
    implements AccessDecisionVoter {
        private MockStringOnlyVoter() {
        }

        public boolean supports(Class clazz) {
            return String.class.isAssignableFrom(clazz);
        }

        public boolean supports(ConfigAttribute attribute) {
            throw new UnsupportedOperationException("mock method not implemented");
        }

        public int vote(Authentication authentication, Object object, ConfigAttributeDefinition config) {
            throw new UnsupportedOperationException("mock method not implemented");
        }
    }

    private class MockDecisionManagerImpl
    extends AbstractAccessDecisionManager {
        private MockDecisionManagerImpl() {
        }

        public void decide(Authentication authentication, Object object, ConfigAttributeDefinition config) throws AccessDeniedException {
        }
    }
}

