/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.ui.x509;

import java.security.cert.X509Certificate;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import junit.framework.TestCase;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.security.Authentication;
import org.springframework.security.AuthenticationManager;
import org.springframework.security.BadCredentialsException;
import org.springframework.security.MockAuthenticationManager;
import org.springframework.security.context.SecurityContextHolder;
import org.springframework.security.providers.x509.X509AuthenticationToken;
import org.springframework.security.providers.x509.X509TestUtils;
import org.springframework.security.ui.x509.X509ProcessingFilter;
import org.springframework.security.util.MockFilterChain;

public class X509ProcessingFilterTests
extends TestCase {
    public X509ProcessingFilterTests() {
    }

    public X509ProcessingFilterTests(String arg0) {
        super(arg0);
    }

    public final void setUp() throws Exception {
        super.setUp();
    }

    public void tearDown() {
        SecurityContextHolder.clearContext();
    }

    public void testAuthenticationIsNullWithNoCertificate() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockFilterChain chain = new MockFilterChain(true);
        MockX509AuthenticationManager authMgr = new MockX509AuthenticationManager();
        X509ProcessingFilter filter = new X509ProcessingFilter();
        filter.setAuthenticationManager((AuthenticationManager)authMgr);
        SecurityContextHolder.getContext().setAuthentication(null);
        filter.doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        Object lastException = request.getSession().getAttribute("SPRING_SECURITY_LAST_EXCEPTION");
        X509ProcessingFilterTests.assertNull((String)"Authentication should be null", (Object)SecurityContextHolder.getContext().getAuthentication());
        X509ProcessingFilterTests.assertTrue((String)"BadCredentialsException should have been thrown", (boolean)(lastException instanceof BadCredentialsException));
    }

    public void testDoFilterWithNonHttpServletRequestDetected() throws Exception {
        X509ProcessingFilter filter = new X509ProcessingFilter();
        try {
            filter.doFilter(null, (ServletResponse)new MockHttpServletResponse(), (FilterChain)new MockFilterChain(false));
            X509ProcessingFilterTests.fail((String)"Should have thrown ServletException");
        }
        catch (ServletException expected) {
            X509ProcessingFilterTests.assertEquals((String)"Can only process HttpServletRequest", (String)expected.getMessage());
        }
    }

    public void testDoFilterWithNonHttpServletResponseDetected() throws Exception {
        X509ProcessingFilter filter = new X509ProcessingFilter();
        try {
            filter.doFilter((ServletRequest)new MockHttpServletRequest(null, null), null, (FilterChain)new MockFilterChain(false));
            X509ProcessingFilterTests.fail((String)"Should have thrown ServletException");
        }
        catch (ServletException expected) {
            X509ProcessingFilterTests.assertEquals((String)"Can only process HttpServletResponse", (String)expected.getMessage());
        }
    }

    public void testFailedAuthentication() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockFilterChain chain = new MockFilterChain(true);
        request.setAttribute("javax.servlet.request.X509Certificate", (Object)new X509Certificate[]{X509TestUtils.buildTestCertificate()});
        MockAuthenticationManager authMgr = new MockAuthenticationManager(false);
        SecurityContextHolder.getContext().setAuthentication(null);
        X509ProcessingFilter filter = new X509ProcessingFilter();
        filter.setAuthenticationManager((AuthenticationManager)authMgr);
        filter.afterPropertiesSet();
        filter.init(null);
        filter.doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        filter.destroy();
        Authentication result = SecurityContextHolder.getContext().getAuthentication();
        X509ProcessingFilterTests.assertNull((Object)result);
    }

    public void testNeedsAuthenticationManager() throws Exception {
        X509ProcessingFilter filter = new X509ProcessingFilter();
        try {
            filter.afterPropertiesSet();
            X509ProcessingFilterTests.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testNormalOperation() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockFilterChain chain = new MockFilterChain(true);
        request.setAttribute("javax.servlet.request.X509Certificate", (Object)new X509Certificate[]{X509TestUtils.buildTestCertificate()});
        MockX509AuthenticationManager authMgr = new MockX509AuthenticationManager();
        SecurityContextHolder.getContext().setAuthentication(null);
        X509ProcessingFilter filter = new X509ProcessingFilter();
        filter.setAuthenticationManager((AuthenticationManager)authMgr);
        filter.afterPropertiesSet();
        filter.init(null);
        filter.doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        filter.destroy();
        Authentication result = SecurityContextHolder.getContext().getAuthentication();
        X509ProcessingFilterTests.assertNotNull((Object)result);
    }

    private static class MockX509AuthenticationManager
    implements AuthenticationManager {
        private MockX509AuthenticationManager() {
        }

        public Authentication authenticate(Authentication a) {
            if (!(a instanceof X509AuthenticationToken)) {
                TestCase.fail((String)("Needed an X509Authentication token but found " + a));
            }
            if (a.getCredentials() == null) {
                throw new BadCredentialsException("Mock authentication manager rejecting null certificate");
            }
            return a;
        }
    }
}

