/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.ui.basicauth;

import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.security.AuthenticationException;
import org.springframework.security.DisabledException;
import org.springframework.security.ui.basicauth.BasicProcessingFilterEntryPoint;

public class BasicProcessingFilterEntryPointTests
extends TestCase {
    public BasicProcessingFilterEntryPointTests() {
    }

    public BasicProcessingFilterEntryPointTests(String arg0) {
        super(arg0);
    }

    public static void main(String[] args) {
        TestRunner.run(BasicProcessingFilterEntryPointTests.class);
    }

    public final void setUp() throws Exception {
        super.setUp();
    }

    public void testDetectsMissingRealmName() throws Exception {
        BasicProcessingFilterEntryPoint ep = new BasicProcessingFilterEntryPoint();
        try {
            ep.afterPropertiesSet();
            BasicProcessingFilterEntryPointTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            BasicProcessingFilterEntryPointTests.assertEquals((String)"realmName must be specified", (String)expected.getMessage());
        }
    }

    public void testGettersSetters() {
        BasicProcessingFilterEntryPoint ep = new BasicProcessingFilterEntryPoint();
        ep.setRealmName("realm");
        BasicProcessingFilterEntryPointTests.assertEquals((String)"realm", (String)ep.getRealmName());
    }

    public void testNormalOperation() throws Exception {
        BasicProcessingFilterEntryPoint ep = new BasicProcessingFilterEntryPoint();
        ep.setRealmName("hello");
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRequestURI("/some_path");
        MockHttpServletResponse response = new MockHttpServletResponse();
        String msg = "These are the jokes kid";
        ep.commence((ServletRequest)request, (ServletResponse)response, (AuthenticationException)((Object)new DisabledException(msg)));
        BasicProcessingFilterEntryPointTests.assertEquals((int)401, (int)response.getStatus());
        BasicProcessingFilterEntryPointTests.assertEquals((String)msg, (String)response.getErrorMessage());
        BasicProcessingFilterEntryPointTests.assertEquals((Object)"Basic realm=\"hello\"", (Object)response.getHeader("WWW-Authenticate"));
    }
}

