/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.providers.preauth;

import junit.framework.TestCase;
import org.springframework.dao.DataAccessException;
import org.springframework.security.Authentication;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.GrantedAuthorityImpl;
import org.springframework.security.providers.preauth.PreAuthenticatedAuthenticationToken;
import org.springframework.security.userdetails.User;
import org.springframework.security.userdetails.UserDetails;
import org.springframework.security.userdetails.UserDetailsByNameServiceWrapper;
import org.springframework.security.userdetails.UserDetailsService;
import org.springframework.security.userdetails.UsernameNotFoundException;

public class UserDetailsByNameServiceWrapperTests
extends TestCase {
    public final void testAfterPropertiesSet() {
        UserDetailsByNameServiceWrapper svc = new UserDetailsByNameServiceWrapper();
        try {
            svc.afterPropertiesSet();
            UserDetailsByNameServiceWrapperTests.fail((String)"AfterPropertiesSet didn't throw expected exception");
        }
        catch (IllegalArgumentException expected) {
        }
        catch (Exception unexpected) {
            UserDetailsByNameServiceWrapperTests.fail((String)"AfterPropertiesSet throws unexpected exception");
        }
    }

    public final void testGetUserDetails() throws Exception {
        UserDetailsByNameServiceWrapper svc = new UserDetailsByNameServiceWrapper();
        final User user = new User("dummy", "dummy", true, true, true, true, new GrantedAuthority[]{new GrantedAuthorityImpl("dummy")});
        svc.setUserDetailsService(new UserDetailsService(){

            public UserDetails loadUserByUsername(String name) throws UsernameNotFoundException, DataAccessException {
                if (user != null && user.getUsername().equals(name)) {
                    return user;
                }
                return null;
            }
        });
        svc.afterPropertiesSet();
        UserDetails result1 = svc.loadUserDetails((Authentication)new PreAuthenticatedAuthenticationToken((Object)"dummy", (Object)"dummy"));
        UserDetailsByNameServiceWrapperTests.assertEquals((String)"Result doesn't match original user", (Object)user, (Object)result1);
        UserDetails result2 = svc.loadUserDetails((Authentication)new PreAuthenticatedAuthenticationToken((Object)"dummy2", (Object)"dummy"));
        UserDetailsByNameServiceWrapperTests.assertNull((String)"Result should have been null", (Object)result2);
    }
}

