/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.providers.ldap.authenticator;

import javax.naming.Name;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.ldap.core.DirContextAdapter;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.ldap.core.DistinguishedName;
import org.springframework.ldap.core.support.BaseLdapPathContextSource;
import org.springframework.security.Authentication;
import org.springframework.security.BadCredentialsException;
import org.springframework.security.ldap.AbstractLdapIntegrationTests;
import org.springframework.security.ldap.LdapUserSearch;
import org.springframework.security.providers.UsernamePasswordAuthenticationToken;
import org.springframework.security.providers.encoding.PasswordEncoder;
import org.springframework.security.providers.encoding.PlaintextPasswordEncoder;
import org.springframework.security.providers.ldap.authenticator.LdapShaPasswordEncoder;
import org.springframework.security.providers.ldap.authenticator.MockUserSearch;
import org.springframework.security.providers.ldap.authenticator.PasswordComparisonAuthenticator;
import org.springframework.security.userdetails.UsernameNotFoundException;

public class PasswordComparisonAuthenticatorTests
extends AbstractLdapIntegrationTests {
    private PasswordComparisonAuthenticator authenticator;
    private Authentication bob;
    private Authentication ben;

    public void onSetUp() throws Exception {
        super.onSetUp();
        this.authenticator = new PasswordComparisonAuthenticator((BaseLdapPathContextSource)this.getContextSource());
        this.authenticator.setPasswordEncoder((PasswordEncoder)new PlaintextPasswordEncoder());
        this.authenticator.setUserDnPatterns(new String[]{"uid={0},ou=people"});
        this.bob = new UsernamePasswordAuthenticationToken((Object)"bob", (Object)"bobspassword");
        this.ben = new UsernamePasswordAuthenticationToken((Object)"ben", (Object)"benspassword");
    }

    @Test
    public void testAllAttributesAreRetrievedByDefault() {
        DirContextAdapter user = (DirContextAdapter)this.authenticator.authenticate(this.bob);
        Assert.assertEquals((String)"User should have 5 attributes", (long)5L, (long)user.getAttributes().size());
    }

    @Test
    public void testFailedSearchGivesUserNotFoundException() throws Exception {
        this.authenticator = new PasswordComparisonAuthenticator((BaseLdapPathContextSource)this.getContextSource());
        Assert.assertTrue((String)"User DN matches shouldn't be available", (boolean)this.authenticator.getUserDns("Bob").isEmpty());
        this.authenticator.setUserSearch((LdapUserSearch)new MockUserSearch(null));
        this.authenticator.afterPropertiesSet();
        try {
            this.authenticator.authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)"Joe", (Object)"pass"));
            Assert.fail((String)"Expected exception on failed user search");
        }
        catch (UsernameNotFoundException usernameNotFoundException) {
            // empty catch block
        }
    }

    @Test(expected=BadCredentialsException.class)
    public void testLdapPasswordCompareFailsWithWrongPassword() {
        this.authenticator.setUserAttributes(new String[]{"uid", "cn", "sn"});
        this.authenticator.authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)"bob", (Object)"wrongpass"));
    }

    @Test
    public void testMultipleDnPatternsWorkOk() {
        this.authenticator.setUserDnPatterns(new String[]{"uid={0},ou=nonexistent", "uid={0},ou=people"});
        this.authenticator.authenticate(this.bob);
    }

    @Test
    public void testOnlySpecifiedAttributesAreRetrieved() throws Exception {
        this.authenticator.setUserAttributes(new String[]{"uid", "userPassword"});
        DirContextAdapter user = (DirContextAdapter)this.authenticator.authenticate(this.bob);
        Assert.assertEquals((String)"Should have retrieved 2 attribute (uid, userPassword)", (long)2L, (long)user.getAttributes().size());
    }

    @Test
    public void testLdapCompareSucceedsWithCorrectPassword() {
        this.authenticator.setUserAttributes(new String[]{"uid"});
        this.authenticator.authenticate(this.bob);
    }

    @Test
    public void testLdapCompareSucceedsWithShaEncodedPassword() {
        this.authenticator.setUserAttributes(new String[]{"uid"});
        this.authenticator.setPasswordEncoder((PasswordEncoder)new LdapShaPasswordEncoder());
        this.authenticator.authenticate(this.ben);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testPasswordEncoderCantBeNull() {
        this.authenticator.setPasswordEncoder(null);
    }

    @Test
    public void testUseOfDifferentPasswordAttributeSucceeds() {
        this.authenticator.setPasswordAttributeName("uid");
        this.authenticator.authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)"bob", (Object)"bob"));
    }

    @Test
    public void testLdapCompareWithDifferentPasswordAttributeSucceeds() {
        this.authenticator.setUserAttributes(new String[]{"uid"});
        this.authenticator.setPasswordAttributeName("cn");
        this.authenticator.authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)"ben", (Object)"Ben Alex"));
    }

    @Test
    public void testWithUserSearch() {
        this.authenticator = new PasswordComparisonAuthenticator((BaseLdapPathContextSource)this.getContextSource());
        this.authenticator.setPasswordEncoder((PasswordEncoder)new PlaintextPasswordEncoder());
        Assert.assertTrue((String)"User DN matches shouldn't be available", (boolean)this.authenticator.getUserDns("Bob").isEmpty());
        DirContextAdapter ctx = new DirContextAdapter((Name)new DistinguishedName("uid=Bob,ou=people"));
        ctx.setAttributeValue("userPassword", (Object)"bobspassword");
        this.authenticator.setUserSearch((LdapUserSearch)new MockUserSearch((DirContextOperations)ctx));
        this.authenticator.authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)"shouldntbeused", (Object)"bobspassword"));
    }
}

