/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.providers.encoding;

import junit.framework.TestCase;
import org.springframework.dao.DataAccessException;
import org.springframework.security.providers.encoding.BasePasswordEncoder;

public class BasePasswordEncoderTests
extends TestCase {
    public void testDemergeHandlesEmptyAndNullSalts() {
        MockPasswordEncoder pwd = new MockPasswordEncoder();
        String merged = pwd.nowMergePasswordAndSalt("password", null, true);
        String[] demerged = pwd.nowDemergePasswordAndSalt(merged);
        BasePasswordEncoderTests.assertEquals((String)"password", (String)demerged[0]);
        BasePasswordEncoderTests.assertEquals((String)"", (String)demerged[1]);
        merged = pwd.nowMergePasswordAndSalt("password", "", true);
        demerged = pwd.nowDemergePasswordAndSalt(merged);
        BasePasswordEncoderTests.assertEquals((String)"password", (String)demerged[0]);
        BasePasswordEncoderTests.assertEquals((String)"", (String)demerged[1]);
    }

    public void testDemergeWithEmptyStringIsRejected() {
        MockPasswordEncoder pwd = new MockPasswordEncoder();
        try {
            pwd.nowDemergePasswordAndSalt("");
            BasePasswordEncoderTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            BasePasswordEncoderTests.assertEquals((String)"Cannot pass a null or empty String", (String)expected.getMessage());
        }
    }

    public void testDemergeWithNullIsRejected() {
        MockPasswordEncoder pwd = new MockPasswordEncoder();
        try {
            pwd.nowDemergePasswordAndSalt(null);
            BasePasswordEncoderTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            BasePasswordEncoderTests.assertEquals((String)"Cannot pass a null or empty String", (String)expected.getMessage());
        }
    }

    public void testMergeDemerge() {
        MockPasswordEncoder pwd = new MockPasswordEncoder();
        String merged = pwd.nowMergePasswordAndSalt("password", "foo", true);
        BasePasswordEncoderTests.assertEquals((String)"password{foo}", (String)merged);
        String[] demerged = pwd.nowDemergePasswordAndSalt(merged);
        BasePasswordEncoderTests.assertEquals((String)"password", (String)demerged[0]);
        BasePasswordEncoderTests.assertEquals((String)"foo", (String)demerged[1]);
    }

    public void testMergeDemergeWithDelimitersInPassword() {
        MockPasswordEncoder pwd = new MockPasswordEncoder();
        String merged = pwd.nowMergePasswordAndSalt("p{ass{w{o}rd", "foo", true);
        BasePasswordEncoderTests.assertEquals((String)"p{ass{w{o}rd{foo}", (String)merged);
        String[] demerged = pwd.nowDemergePasswordAndSalt(merged);
        BasePasswordEncoderTests.assertEquals((String)"p{ass{w{o}rd", (String)demerged[0]);
        BasePasswordEncoderTests.assertEquals((String)"foo", (String)demerged[1]);
    }

    public void testMergeDemergeWithNullAsPassword() {
        MockPasswordEncoder pwd = new MockPasswordEncoder();
        String merged = pwd.nowMergePasswordAndSalt(null, "foo", true);
        BasePasswordEncoderTests.assertEquals((String)"{foo}", (String)merged);
        String[] demerged = pwd.nowDemergePasswordAndSalt(merged);
        BasePasswordEncoderTests.assertEquals((String)"", (String)demerged[0]);
        BasePasswordEncoderTests.assertEquals((String)"foo", (String)demerged[1]);
    }

    public void testStrictMergeRejectsDelimitersInSalt1() {
        MockPasswordEncoder pwd = new MockPasswordEncoder();
        try {
            pwd.nowMergePasswordAndSalt("password", "f{oo", true);
            BasePasswordEncoderTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            BasePasswordEncoderTests.assertEquals((String)"Cannot use { or } in salt.toString()", (String)expected.getMessage());
        }
    }

    public void testStrictMergeRejectsDelimitersInSalt2() {
        MockPasswordEncoder pwd = new MockPasswordEncoder();
        try {
            pwd.nowMergePasswordAndSalt("password", "f}oo", true);
            BasePasswordEncoderTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            BasePasswordEncoderTests.assertEquals((String)"Cannot use { or } in salt.toString()", (String)expected.getMessage());
        }
    }

    private class MockPasswordEncoder
    extends BasePasswordEncoder {
        private MockPasswordEncoder() {
        }

        public String encodePassword(String rawPass, Object salt) throws DataAccessException {
            throw new UnsupportedOperationException("mock method not implemented");
        }

        public boolean isPasswordValid(String encPass, String rawPass, Object salt) throws DataAccessException {
            throw new UnsupportedOperationException("mock method not implemented");
        }

        public String[] nowDemergePasswordAndSalt(String password) {
            return this.demergePasswordAndSalt(password);
        }

        public String nowMergePasswordAndSalt(String password, Object salt, boolean strict) {
            return this.mergePasswordAndSalt(password, salt, strict);
        }
    }
}

