/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.providers.dao.cache;

import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.GrantedAuthorityImpl;
import org.springframework.security.providers.dao.cache.EhCacheBasedUserCache;
import org.springframework.security.userdetails.User;
import org.springframework.security.userdetails.UserDetails;

public class EhCacheBasedUserCacheTests {
    private static CacheManager cacheManager;

    @BeforeClass
    public static void initCacheManaer() {
        cacheManager = new CacheManager();
        cacheManager.addCache(new Cache("ehcacheusercachetests", 500, false, false, 30L, 30L));
    }

    @AfterClass
    public static void shutdownCacheManager() {
        cacheManager.removalAll();
        cacheManager.shutdown();
    }

    private Ehcache getCache() {
        Cache cache = cacheManager.getCache("ehcacheusercachetests");
        cache.removeAll();
        return cache;
    }

    private User getUser() {
        return new User("john", "password", true, true, true, true, new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")});
    }

    @Test
    public void cacheOperationsAreSuccessful() throws Exception {
        EhCacheBasedUserCache cache = new EhCacheBasedUserCache();
        cache.setCache(this.getCache());
        cache.afterPropertiesSet();
        cache.putUserInCache((UserDetails)this.getUser());
        Assert.assertEquals((Object)this.getUser().getPassword(), (Object)cache.getUserFromCache(this.getUser().getUsername()).getPassword());
        cache.removeUserFromCache((UserDetails)this.getUser());
        Assert.assertNull((Object)cache.getUserFromCache(this.getUser().getUsername()));
        Assert.assertNull((Object)cache.getUserFromCache(null));
        Assert.assertNull((Object)cache.getUserFromCache("UNKNOWN_USER"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void startupDetectsMissingCache() throws Exception {
        EhCacheBasedUserCache cache = new EhCacheBasedUserCache();
        cache.afterPropertiesSet();
        Assert.fail((String)"Should have thrown IllegalArgumentException");
        Ehcache myCache = this.getCache();
        cache.setCache(myCache);
        Assert.assertEquals((Object)myCache, (Object)cache.getCache());
    }
}

