/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.providers.dao;

import junit.framework.TestCase;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.security.AccountExpiredException;
import org.springframework.security.Authentication;
import org.springframework.security.AuthenticationServiceException;
import org.springframework.security.BadCredentialsException;
import org.springframework.security.CredentialsExpiredException;
import org.springframework.security.DisabledException;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.GrantedAuthorityImpl;
import org.springframework.security.LockedException;
import org.springframework.security.providers.TestingAuthenticationToken;
import org.springframework.security.providers.UsernamePasswordAuthenticationToken;
import org.springframework.security.providers.dao.DaoAuthenticationProvider;
import org.springframework.security.providers.dao.MockUserCache;
import org.springframework.security.providers.dao.SaltSource;
import org.springframework.security.providers.dao.UserCache;
import org.springframework.security.providers.dao.cache.EhCacheBasedUserCache;
import org.springframework.security.providers.dao.cache.NullUserCache;
import org.springframework.security.providers.dao.salt.SystemWideSaltSource;
import org.springframework.security.providers.encoding.PasswordEncoder;
import org.springframework.security.providers.encoding.ShaPasswordEncoder;
import org.springframework.security.userdetails.User;
import org.springframework.security.userdetails.UserDetails;
import org.springframework.security.userdetails.UserDetailsService;
import org.springframework.security.userdetails.UsernameNotFoundException;

public class DaoAuthenticationProviderTests
extends TestCase {
    public void testAuthenticateFailsForIncorrectPasswordCase() {
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)"rod", (Object)"KOala");
        DaoAuthenticationProvider provider = new DaoAuthenticationProvider();
        provider.setUserDetailsService((UserDetailsService)new MockAuthenticationDaoUserrod());
        provider.setUserCache((UserCache)new MockUserCache());
        try {
            provider.authenticate((Authentication)token);
            DaoAuthenticationProviderTests.fail((String)"Should have thrown BadCredentialsException");
        }
        catch (BadCredentialsException expected) {
            DaoAuthenticationProviderTests.assertTrue((boolean)true);
        }
    }

    public void testReceivedBadCredentialsWhenCredentialsNotProvided() {
        DaoAuthenticationProvider provider = new DaoAuthenticationProvider();
        provider.setUserDetailsService((UserDetailsService)new MockAuthenticationDaoUserrod());
        provider.setUserCache((UserCache)new MockUserCache());
        UsernamePasswordAuthenticationToken authenticationToken = new UsernamePasswordAuthenticationToken((Object)"rod", null);
        try {
            provider.authenticate((Authentication)authenticationToken);
            DaoAuthenticationProviderTests.fail((String)"Expected BadCredenialsException");
        }
        catch (BadCredentialsException expected) {
            DaoAuthenticationProviderTests.assertTrue((boolean)true);
        }
    }

    public void testAuthenticateFailsIfAccountExpired() {
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)"peter", (Object)"opal");
        DaoAuthenticationProvider provider = new DaoAuthenticationProvider();
        provider.setUserDetailsService((UserDetailsService)new MockAuthenticationDaoUserPeterAccountExpired());
        provider.setUserCache((UserCache)new MockUserCache());
        try {
            provider.authenticate((Authentication)token);
            DaoAuthenticationProviderTests.fail((String)"Should have thrown AccountExpiredException");
        }
        catch (AccountExpiredException expected) {
            DaoAuthenticationProviderTests.assertTrue((boolean)true);
        }
    }

    public void testAuthenticateFailsIfAccountLocked() {
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)"peter", (Object)"opal");
        DaoAuthenticationProvider provider = new DaoAuthenticationProvider();
        provider.setUserDetailsService((UserDetailsService)new MockAuthenticationDaoUserPeterAccountLocked());
        provider.setUserCache((UserCache)new MockUserCache());
        try {
            provider.authenticate((Authentication)token);
            DaoAuthenticationProviderTests.fail((String)"Should have thrown LockedException");
        }
        catch (LockedException expected) {
            DaoAuthenticationProviderTests.assertTrue((boolean)true);
        }
    }

    public void testAuthenticateFailsIfCredentialsExpired() {
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)"peter", (Object)"opal");
        DaoAuthenticationProvider provider = new DaoAuthenticationProvider();
        provider.setUserDetailsService((UserDetailsService)new MockAuthenticationDaoUserPeterCredentialsExpired());
        provider.setUserCache((UserCache)new MockUserCache());
        try {
            provider.authenticate((Authentication)token);
            DaoAuthenticationProviderTests.fail((String)"Should have thrown CredentialsExpiredException");
        }
        catch (CredentialsExpiredException expected) {
            DaoAuthenticationProviderTests.assertTrue((boolean)true);
        }
        token = new UsernamePasswordAuthenticationToken((Object)"peter", (Object)"wrong_password");
        try {
            provider.authenticate((Authentication)token);
            DaoAuthenticationProviderTests.fail((String)"Should have thrown BadCredentialsException");
        }
        catch (BadCredentialsException expected) {
            DaoAuthenticationProviderTests.assertTrue((boolean)true);
        }
    }

    public void testAuthenticateFailsIfUserDisabled() {
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)"peter", (Object)"opal");
        DaoAuthenticationProvider provider = new DaoAuthenticationProvider();
        provider.setUserDetailsService((UserDetailsService)new MockAuthenticationDaoUserPeter());
        provider.setUserCache((UserCache)new MockUserCache());
        try {
            provider.authenticate((Authentication)token);
            DaoAuthenticationProviderTests.fail((String)"Should have thrown DisabledException");
        }
        catch (DisabledException expected) {
            DaoAuthenticationProviderTests.assertTrue((boolean)true);
        }
    }

    public void testAuthenticateFailsWhenAuthenticationDaoHasBackendFailure() {
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)"rod", (Object)"koala");
        DaoAuthenticationProvider provider = new DaoAuthenticationProvider();
        provider.setUserDetailsService((UserDetailsService)new MockAuthenticationDaoSimulateBackendError());
        provider.setUserCache((UserCache)new MockUserCache());
        try {
            provider.authenticate((Authentication)token);
            DaoAuthenticationProviderTests.fail((String)"Should have thrown AuthenticationServiceException");
        }
        catch (AuthenticationServiceException expected) {
            DaoAuthenticationProviderTests.assertTrue((boolean)true);
        }
    }

    public void testAuthenticateFailsWithEmptyUsername() {
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken(null, (Object)"koala");
        DaoAuthenticationProvider provider = new DaoAuthenticationProvider();
        provider.setUserDetailsService((UserDetailsService)new MockAuthenticationDaoUserrod());
        provider.setUserCache((UserCache)new MockUserCache());
        try {
            provider.authenticate((Authentication)token);
            DaoAuthenticationProviderTests.fail((String)"Should have thrown BadCredentialsException");
        }
        catch (BadCredentialsException expected) {
            DaoAuthenticationProviderTests.assertTrue((boolean)true);
        }
    }

    public void testAuthenticateFailsWithInvalidPassword() {
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)"rod", (Object)"INVALID_PASSWORD");
        DaoAuthenticationProvider provider = new DaoAuthenticationProvider();
        provider.setUserDetailsService((UserDetailsService)new MockAuthenticationDaoUserrod());
        provider.setUserCache((UserCache)new MockUserCache());
        try {
            provider.authenticate((Authentication)token);
            DaoAuthenticationProviderTests.fail((String)"Should have thrown BadCredentialsException");
        }
        catch (BadCredentialsException expected) {
            DaoAuthenticationProviderTests.assertTrue((boolean)true);
        }
    }

    public void testAuthenticateFailsWithInvalidUsernameAndHideUserNotFoundExceptionFalse() {
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)"INVALID_USER", (Object)"koala");
        DaoAuthenticationProvider provider = new DaoAuthenticationProvider();
        provider.setHideUserNotFoundExceptions(false);
        provider.setUserDetailsService((UserDetailsService)new MockAuthenticationDaoUserrod());
        provider.setUserCache((UserCache)new MockUserCache());
        try {
            provider.authenticate((Authentication)token);
            DaoAuthenticationProviderTests.fail((String)"Should have thrown UsernameNotFoundException");
        }
        catch (UsernameNotFoundException expected) {
            DaoAuthenticationProviderTests.assertTrue((boolean)true);
        }
    }

    public void testAuthenticateFailsWithInvalidUsernameAndHideUserNotFoundExceptionsWithDefaultOfTrue() {
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)"INVALID_USER", (Object)"koala");
        DaoAuthenticationProvider provider = new DaoAuthenticationProvider();
        DaoAuthenticationProviderTests.assertTrue((boolean)provider.isHideUserNotFoundExceptions());
        provider.setUserDetailsService((UserDetailsService)new MockAuthenticationDaoUserrod());
        provider.setUserCache((UserCache)new MockUserCache());
        try {
            provider.authenticate((Authentication)token);
            DaoAuthenticationProviderTests.fail((String)"Should have thrown BadCredentialsException");
        }
        catch (BadCredentialsException expected) {
            DaoAuthenticationProviderTests.assertTrue((boolean)true);
        }
    }

    public void testAuthenticateFailsWithMixedCaseUsernameIfDefaultChanged() {
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)"RoD", (Object)"koala");
        DaoAuthenticationProvider provider = new DaoAuthenticationProvider();
        provider.setUserDetailsService((UserDetailsService)new MockAuthenticationDaoUserrod());
        provider.setUserCache((UserCache)new MockUserCache());
        try {
            provider.authenticate((Authentication)token);
            DaoAuthenticationProviderTests.fail((String)"Should have thrown BadCredentialsException");
        }
        catch (BadCredentialsException expected) {
            DaoAuthenticationProviderTests.assertTrue((boolean)true);
        }
    }

    public void testAuthenticates() {
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)"rod", (Object)"koala");
        token.setDetails((Object)"192.168.0.1");
        DaoAuthenticationProvider provider = new DaoAuthenticationProvider();
        provider.setUserDetailsService((UserDetailsService)new MockAuthenticationDaoUserrod());
        provider.setUserCache((UserCache)new MockUserCache());
        Authentication result = provider.authenticate((Authentication)token);
        if (!(result instanceof UsernamePasswordAuthenticationToken)) {
            DaoAuthenticationProviderTests.fail((String)"Should have returned instance of UsernamePasswordAuthenticationToken");
        }
        UsernamePasswordAuthenticationToken castResult = (UsernamePasswordAuthenticationToken)result;
        DaoAuthenticationProviderTests.assertEquals(User.class, castResult.getPrincipal().getClass());
        DaoAuthenticationProviderTests.assertEquals((Object)"koala", (Object)castResult.getCredentials());
        DaoAuthenticationProviderTests.assertEquals((String)"ROLE_ONE", (String)castResult.getAuthorities()[0].getAuthority());
        DaoAuthenticationProviderTests.assertEquals((String)"ROLE_TWO", (String)castResult.getAuthorities()[1].getAuthority());
        DaoAuthenticationProviderTests.assertEquals((Object)"192.168.0.1", (Object)castResult.getDetails());
    }

    public void testAuthenticatesASecondTime() {
        Authentication result2;
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)"rod", (Object)"koala");
        DaoAuthenticationProvider provider = new DaoAuthenticationProvider();
        provider.setUserDetailsService((UserDetailsService)new MockAuthenticationDaoUserrod());
        provider.setUserCache((UserCache)new MockUserCache());
        Authentication result = provider.authenticate((Authentication)token);
        if (!(result instanceof UsernamePasswordAuthenticationToken)) {
            DaoAuthenticationProviderTests.fail((String)"Should have returned instance of UsernamePasswordAuthenticationToken");
        }
        if (!((result2 = provider.authenticate(result)) instanceof UsernamePasswordAuthenticationToken)) {
            DaoAuthenticationProviderTests.fail((String)"Should have returned instance of UsernamePasswordAuthenticationToken");
        }
        DaoAuthenticationProviderTests.assertEquals((Object)result.getCredentials(), (Object)result2.getCredentials());
    }

    public void testAuthenticatesWhenASaltIsUsed() {
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)"rod", (Object)"koala");
        SystemWideSaltSource salt = new SystemWideSaltSource();
        salt.setSystemWideSalt("SYSTEM_SALT_VALUE");
        DaoAuthenticationProvider provider = new DaoAuthenticationProvider();
        provider.setUserDetailsService((UserDetailsService)new MockAuthenticationDaoUserrodWithSalt());
        provider.setSaltSource((SaltSource)salt);
        provider.setUserCache((UserCache)new MockUserCache());
        Authentication result = provider.authenticate((Authentication)token);
        if (!(result instanceof UsernamePasswordAuthenticationToken)) {
            DaoAuthenticationProviderTests.fail((String)"Should have returned instance of UsernamePasswordAuthenticationToken");
        }
        UsernamePasswordAuthenticationToken castResult = (UsernamePasswordAuthenticationToken)result;
        DaoAuthenticationProviderTests.assertEquals(User.class, castResult.getPrincipal().getClass());
        DaoAuthenticationProviderTests.assertEquals((Object)"koala", (Object)castResult.getCredentials());
        DaoAuthenticationProviderTests.assertEquals((String)"ROLE_ONE", (String)castResult.getAuthorities()[0].getAuthority());
        DaoAuthenticationProviderTests.assertEquals((String)"ROLE_TWO", (String)castResult.getAuthorities()[1].getAuthority());
    }

    public void testAuthenticatesWithForcePrincipalAsString() {
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)"rod", (Object)"koala");
        DaoAuthenticationProvider provider = new DaoAuthenticationProvider();
        provider.setUserDetailsService((UserDetailsService)new MockAuthenticationDaoUserrod());
        provider.setUserCache((UserCache)new MockUserCache());
        provider.setForcePrincipalAsString(true);
        Authentication result = provider.authenticate((Authentication)token);
        if (!(result instanceof UsernamePasswordAuthenticationToken)) {
            DaoAuthenticationProviderTests.fail((String)"Should have returned instance of UsernamePasswordAuthenticationToken");
        }
        UsernamePasswordAuthenticationToken castResult = (UsernamePasswordAuthenticationToken)result;
        DaoAuthenticationProviderTests.assertEquals(String.class, castResult.getPrincipal().getClass());
        DaoAuthenticationProviderTests.assertEquals((Object)"rod", (Object)castResult.getPrincipal());
    }

    public void testDetectsNullBeingReturnedFromAuthenticationDao() {
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)"rod", (Object)"koala");
        DaoAuthenticationProvider provider = new DaoAuthenticationProvider();
        provider.setUserDetailsService((UserDetailsService)new MockAuthenticationDaoReturnsNull());
        try {
            provider.authenticate((Authentication)token);
            DaoAuthenticationProviderTests.fail((String)"Should have thrown AuthenticationServiceException");
        }
        catch (AuthenticationServiceException expected) {
            DaoAuthenticationProviderTests.assertEquals((String)"UserDetailsService returned null, which is an interface contract violation", (String)expected.getMessage());
        }
    }

    public void testGettersSetters() {
        DaoAuthenticationProvider provider = new DaoAuthenticationProvider();
        provider.setPasswordEncoder((PasswordEncoder)new ShaPasswordEncoder());
        DaoAuthenticationProviderTests.assertEquals(ShaPasswordEncoder.class, provider.getPasswordEncoder().getClass());
        provider.setSaltSource((SaltSource)new SystemWideSaltSource());
        DaoAuthenticationProviderTests.assertEquals(SystemWideSaltSource.class, provider.getSaltSource().getClass());
        provider.setUserCache((UserCache)new EhCacheBasedUserCache());
        DaoAuthenticationProviderTests.assertEquals(EhCacheBasedUserCache.class, provider.getUserCache().getClass());
        DaoAuthenticationProviderTests.assertFalse((boolean)provider.isForcePrincipalAsString());
        provider.setForcePrincipalAsString(true);
        DaoAuthenticationProviderTests.assertTrue((boolean)provider.isForcePrincipalAsString());
    }

    public void testGoesBackToAuthenticationDaoToObtainLatestPasswordIfCachedPasswordSeemsIncorrect() {
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)"rod", (Object)"koala");
        MockAuthenticationDaoUserrod authenticationDao = new MockAuthenticationDaoUserrod();
        MockUserCache cache = new MockUserCache();
        DaoAuthenticationProvider provider = new DaoAuthenticationProvider();
        provider.setUserDetailsService((UserDetailsService)authenticationDao);
        provider.setUserCache((UserCache)cache);
        provider.authenticate((Authentication)token);
        DaoAuthenticationProviderTests.assertEquals((String)"koala", (String)cache.getUserFromCache("rod").getPassword());
        authenticationDao.setPassword("easternLongNeckTurtle");
        token = new UsernamePasswordAuthenticationToken((Object)"rod", (Object)"easternLongNeckTurtle");
        provider.authenticate((Authentication)token);
        DaoAuthenticationProviderTests.assertEquals((String)"easternLongNeckTurtle", (String)cache.getUserFromCache("rod").getPassword());
    }

    public void testStartupFailsIfNoAuthenticationDao() throws Exception {
        DaoAuthenticationProvider provider = new DaoAuthenticationProvider();
        try {
            provider.afterPropertiesSet();
            DaoAuthenticationProviderTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            DaoAuthenticationProviderTests.assertTrue((boolean)true);
        }
    }

    public void testStartupFailsIfNoUserCacheSet() throws Exception {
        DaoAuthenticationProvider provider = new DaoAuthenticationProvider();
        provider.setUserDetailsService((UserDetailsService)new MockAuthenticationDaoUserrod());
        DaoAuthenticationProviderTests.assertEquals(NullUserCache.class, provider.getUserCache().getClass());
        provider.setUserCache(null);
        try {
            provider.afterPropertiesSet();
            DaoAuthenticationProviderTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            DaoAuthenticationProviderTests.assertTrue((boolean)true);
        }
    }

    public void testStartupSuccess() throws Exception {
        DaoAuthenticationProvider provider = new DaoAuthenticationProvider();
        MockAuthenticationDaoUserrod userDetailsService = new MockAuthenticationDaoUserrod();
        provider.setUserDetailsService((UserDetailsService)userDetailsService);
        provider.setUserCache((UserCache)new MockUserCache());
        DaoAuthenticationProviderTests.assertEquals((Object)userDetailsService, (Object)provider.getUserDetailsService());
        provider.afterPropertiesSet();
        DaoAuthenticationProviderTests.assertTrue((boolean)true);
    }

    public void testSupports() {
        DaoAuthenticationProvider provider = new DaoAuthenticationProvider();
        DaoAuthenticationProviderTests.assertTrue((boolean)provider.supports(UsernamePasswordAuthenticationToken.class));
        DaoAuthenticationProviderTests.assertTrue((!provider.supports(TestingAuthenticationToken.class) ? 1 : 0) != 0);
    }

    private class MockAuthenticationDaoUserPeterCredentialsExpired
    implements UserDetailsService {
        private MockAuthenticationDaoUserPeterCredentialsExpired() {
        }

        public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
            if ("peter".equals(username)) {
                return new User("peter", "opal", true, true, false, true, new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")});
            }
            throw new UsernameNotFoundException("Could not find: " + username);
        }
    }

    private class MockAuthenticationDaoUserPeterAccountLocked
    implements UserDetailsService {
        private MockAuthenticationDaoUserPeterAccountLocked() {
        }

        public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
            if ("peter".equals(username)) {
                return new User("peter", "opal", true, true, true, false, new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")});
            }
            throw new UsernameNotFoundException("Could not find: " + username);
        }
    }

    private class MockAuthenticationDaoUserPeterAccountExpired
    implements UserDetailsService {
        private MockAuthenticationDaoUserPeterAccountExpired() {
        }

        public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
            if ("peter".equals(username)) {
                return new User("peter", "opal", true, false, true, true, new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")});
            }
            throw new UsernameNotFoundException("Could not find: " + username);
        }
    }

    private class MockAuthenticationDaoUserPeter
    implements UserDetailsService {
        private MockAuthenticationDaoUserPeter() {
        }

        public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
            if ("peter".equals(username)) {
                return new User("peter", "opal", false, true, true, true, new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")});
            }
            throw new UsernameNotFoundException("Could not find: " + username);
        }
    }

    private class MockAuthenticationDaoUserrodWithSalt
    implements UserDetailsService {
        private MockAuthenticationDaoUserrodWithSalt() {
        }

        public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
            if ("rod".equals(username)) {
                return new User("rod", "koala{SYSTEM_SALT_VALUE}", true, true, true, true, new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")});
            }
            throw new UsernameNotFoundException("Could not find: " + username);
        }
    }

    private class MockAuthenticationDaoUserrod
    implements UserDetailsService {
        private String password = "koala";

        private MockAuthenticationDaoUserrod() {
        }

        public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
            if ("rod".equals(username)) {
                return new User("rod", this.password, true, true, true, true, new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")});
            }
            throw new UsernameNotFoundException("Could not find: " + username);
        }

        public void setPassword(String password) {
            this.password = password;
        }
    }

    private class MockAuthenticationDaoSimulateBackendError
    implements UserDetailsService {
        private MockAuthenticationDaoSimulateBackendError() {
        }

        public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
            throw new DataRetrievalFailureException("This mock simulator is designed to fail");
        }
    }

    private class MockAuthenticationDaoReturnsNull
    implements UserDetailsService {
        private MockAuthenticationDaoReturnsNull() {
        }

        public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
            return null;
        }
    }
}

