/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.context.rmi;

import java.lang.reflect.Method;
import junit.framework.TestCase;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.security.Authentication;
import org.springframework.security.TargetObject;
import org.springframework.security.context.SecurityContextHolder;
import org.springframework.security.context.rmi.ContextPropagatingRemoteInvocation;
import org.springframework.security.context.rmi.ContextPropagatingRemoteInvocationFactory;
import org.springframework.security.providers.UsernamePasswordAuthenticationToken;
import org.springframework.security.util.SimpleMethodInvocation;

public class ContextPropagatingRemoteInvocationTests
extends TestCase {
    public ContextPropagatingRemoteInvocationTests() {
    }

    public ContextPropagatingRemoteInvocationTests(String arg0) {
        super(arg0);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        SecurityContextHolder.clearContext();
    }

    private ContextPropagatingRemoteInvocation getRemoteInvocation() throws Exception {
        Class<TargetObject> clazz = TargetObject.class;
        Method method = clazz.getMethod("makeLowerCase", String.class);
        SimpleMethodInvocation mi = new SimpleMethodInvocation((Object)new TargetObject(), method, new Object[]{"SOME_STRING"});
        ContextPropagatingRemoteInvocationFactory factory = new ContextPropagatingRemoteInvocationFactory();
        return (ContextPropagatingRemoteInvocation)factory.createRemoteInvocation((MethodInvocation)mi);
    }

    public void testContextIsResetEvenIfExceptionOccurs() throws Exception {
        UsernamePasswordAuthenticationToken clientSideAuthentication = new UsernamePasswordAuthenticationToken((Object)"rod", (Object)"koala");
        SecurityContextHolder.getContext().setAuthentication((Authentication)clientSideAuthentication);
        ContextPropagatingRemoteInvocation remoteInvocation = this.getRemoteInvocation();
        try {
            remoteInvocation.setArguments(new Object[0]);
            remoteInvocation.invoke(TargetObject.class.newInstance());
            ContextPropagatingRemoteInvocationTests.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        ContextPropagatingRemoteInvocationTests.assertNull((String)"Authentication must be null ", (Object)SecurityContextHolder.getContext().getAuthentication());
    }

    public void testNormalOperation() throws Exception {
        UsernamePasswordAuthenticationToken clientSideAuthentication = new UsernamePasswordAuthenticationToken((Object)"rod", (Object)"koala");
        SecurityContextHolder.getContext().setAuthentication((Authentication)clientSideAuthentication);
        ContextPropagatingRemoteInvocation remoteInvocation = this.getRemoteInvocation();
        SecurityContextHolder.clearContext();
        ContextPropagatingRemoteInvocationTests.assertEquals((Object)"some_string org.springframework.security.providers.UsernamePasswordAuthenticationToken false", (Object)remoteInvocation.invoke((Object)new TargetObject()));
    }

    public void testNullContextHolderDoesNotCauseInvocationProblems() throws Exception {
        SecurityContextHolder.getContext().setAuthentication(null);
        ContextPropagatingRemoteInvocation remoteInvocation = this.getRemoteInvocation();
        SecurityContextHolder.getContext().setAuthentication(null);
        ContextPropagatingRemoteInvocationTests.assertEquals((Object)"some_string Authentication empty", (Object)remoteInvocation.invoke((Object)new TargetObject()));
    }
}

