/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config;

import org.junit.After;
import org.junit.Test;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.security.ldap.SpringSecurityContextSource;
import org.springframework.security.util.InMemoryXmlApplicationContext;

public class LdapServerBeanDefinitionParserTests {
    InMemoryXmlApplicationContext appCtx;

    @After
    public void closeAppContext() {
        if (this.appCtx != null) {
            this.appCtx.close();
            this.appCtx = null;
        }
    }

    @Test
    public void embeddedServerCreationContainsExpectedContextSourceAndData() {
        this.appCtx = new InMemoryXmlApplicationContext("<ldap-server />");
        SpringSecurityContextSource contextSource = (SpringSecurityContextSource)this.appCtx.getBean("_securityContextSource");
        LdapTemplate template = new LdapTemplate((ContextSource)contextSource);
        template.lookup("uid=ben,ou=people");
    }

    @Test
    public void useOfUrlAttributeCreatesCorrectContextSource() {
        this.appCtx = new InMemoryXmlApplicationContext("<ldap-server port='33388'/><ldap-server id='blah' url='ldap://127.0.0.1:33388/dc=springframework,dc=org' />");
        this.appCtx.getBean("_securityContextSource");
        SpringSecurityContextSource contextSource = (SpringSecurityContextSource)this.appCtx.getBean("blah");
        LdapTemplate template = new LdapTemplate((ContextSource)contextSource);
        template.lookup("uid=ben,ou=people");
    }

    @Test
    public void loadingSpecificLdifFileIsSuccessful() {
        this.appCtx = new InMemoryXmlApplicationContext("<ldap-server ldif='classpath*:test-server2.xldif' root='dc=monkeymachine,dc=co,dc=uk' />");
        SpringSecurityContextSource contextSource = (SpringSecurityContextSource)this.appCtx.getBean("_securityContextSource");
        LdapTemplate template = new LdapTemplate((ContextSource)contextSource);
        template.lookup("uid=pg,ou=gorillas");
    }
}

