/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.authoritymapping;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.GrantedAuthorityImpl;
import org.springframework.security.authoritymapping.Attributes2GrantedAuthoritiesMapper;
import org.springframework.security.authoritymapping.MapBasedAttributes2GrantedAuthoritiesMapper;

public class MapBasedAttributes2GrantedAuthoritiesMapperTest
extends TestCase {
    protected void setUp() throws Exception {
        Logger.getRootLogger().setLevel(Level.DEBUG);
    }

    public final void testAfterPropertiesSetNoMap() {
        MapBasedAttributes2GrantedAuthoritiesMapper mapper = new MapBasedAttributes2GrantedAuthoritiesMapper();
        try {
            mapper.afterPropertiesSet();
            MapBasedAttributes2GrantedAuthoritiesMapperTest.fail((String)"Expected exception not thrown");
        }
        catch (IllegalArgumentException expected) {
        }
        catch (Exception unexpected) {
            MapBasedAttributes2GrantedAuthoritiesMapperTest.fail((String)("Unexpected exception: " + unexpected));
        }
    }

    public final void testAfterPropertiesSetEmptyMap() {
        MapBasedAttributes2GrantedAuthoritiesMapper mapper = new MapBasedAttributes2GrantedAuthoritiesMapper();
        mapper.setAttributes2grantedAuthoritiesMap(new HashMap());
        try {
            mapper.afterPropertiesSet();
            MapBasedAttributes2GrantedAuthoritiesMapperTest.fail((String)"Expected exception not thrown");
        }
        catch (IllegalArgumentException expected) {
        }
        catch (Exception unexpected) {
            MapBasedAttributes2GrantedAuthoritiesMapperTest.fail((String)("Unexpected exception: " + unexpected));
        }
    }

    public final void testAfterPropertiesSetInvalidKeyTypeMap() {
        MapBasedAttributes2GrantedAuthoritiesMapper mapper = new MapBasedAttributes2GrantedAuthoritiesMapper();
        HashMap<Object, String> m = new HashMap<Object, String>();
        m.put(new Object(), "ga1");
        mapper.setAttributes2grantedAuthoritiesMap(m);
        try {
            mapper.afterPropertiesSet();
            MapBasedAttributes2GrantedAuthoritiesMapperTest.fail((String)"Expected exception not thrown");
        }
        catch (IllegalArgumentException expected) {
        }
        catch (Exception unexpected) {
            MapBasedAttributes2GrantedAuthoritiesMapperTest.fail((String)("Unexpected exception: " + unexpected));
        }
    }

    public final void testAfterPropertiesSetInvalidValueTypeMap1() {
        MapBasedAttributes2GrantedAuthoritiesMapper mapper = new MapBasedAttributes2GrantedAuthoritiesMapper();
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("role1", new Object());
        mapper.setAttributes2grantedAuthoritiesMap(m);
        try {
            mapper.afterPropertiesSet();
            MapBasedAttributes2GrantedAuthoritiesMapperTest.fail((String)"Expected exception not thrown");
        }
        catch (IllegalArgumentException expected) {
        }
        catch (Exception unexpected) {
            MapBasedAttributes2GrantedAuthoritiesMapperTest.fail((String)("Unexpected exception: " + unexpected));
        }
    }

    public final void testAfterPropertiesSetInvalidValueTypeMap2() {
        MapBasedAttributes2GrantedAuthoritiesMapper mapper = new MapBasedAttributes2GrantedAuthoritiesMapper();
        HashMap<String, Object[]> m = new HashMap<String, Object[]>();
        m.put("role1", new Object[]{new String[]{"ga1", "ga2"}, new Object()});
        mapper.setAttributes2grantedAuthoritiesMap(m);
        try {
            mapper.afterPropertiesSet();
            MapBasedAttributes2GrantedAuthoritiesMapperTest.fail((String)"Expected exception not thrown");
        }
        catch (IllegalArgumentException expected) {
        }
        catch (Exception unexpected) {
            MapBasedAttributes2GrantedAuthoritiesMapperTest.fail((String)("Unexpected exception: " + unexpected));
        }
    }

    public final void testAfterPropertiesSetValidMap() {
        MapBasedAttributes2GrantedAuthoritiesMapper mapper = new MapBasedAttributes2GrantedAuthoritiesMapper();
        HashMap m = this.getValidAttributes2GrantedAuthoritiesMap();
        mapper.setAttributes2grantedAuthoritiesMap((Map)m);
        try {
            mapper.afterPropertiesSet();
        }
        catch (Exception unexpected) {
            MapBasedAttributes2GrantedAuthoritiesMapperTest.fail((String)("Unexpected exception: " + unexpected));
        }
    }

    public final void testMapping1() {
        String[] roles = new String[]{"role1"};
        String[] expectedGas = new String[]{"ga1"};
        MapBasedAttributes2GrantedAuthoritiesMapper mapper = this.getDefaultMapper();
        this.testGetGrantedAuthorities((Attributes2GrantedAuthoritiesMapper)mapper, roles, expectedGas);
    }

    public final void testMapping2() {
        String[] roles = new String[]{"role2"};
        String[] expectedGas = new String[]{"ga2"};
        MapBasedAttributes2GrantedAuthoritiesMapper mapper = this.getDefaultMapper();
        this.testGetGrantedAuthorities((Attributes2GrantedAuthoritiesMapper)mapper, roles, expectedGas);
    }

    public final void testMapping3() {
        String[] roles = new String[]{"role3"};
        String[] expectedGas = new String[]{"ga3", "ga4"};
        MapBasedAttributes2GrantedAuthoritiesMapper mapper = this.getDefaultMapper();
        this.testGetGrantedAuthorities((Attributes2GrantedAuthoritiesMapper)mapper, roles, expectedGas);
    }

    public final void testMapping4() {
        String[] roles = new String[]{"role4"};
        String[] expectedGas = new String[]{"ga5", "ga6"};
        MapBasedAttributes2GrantedAuthoritiesMapper mapper = this.getDefaultMapper();
        this.testGetGrantedAuthorities((Attributes2GrantedAuthoritiesMapper)mapper, roles, expectedGas);
    }

    public final void testMapping5() {
        String[] roles = new String[]{"role5"};
        String[] expectedGas = new String[]{"ga7", "ga8", "ga9"};
        MapBasedAttributes2GrantedAuthoritiesMapper mapper = this.getDefaultMapper();
        this.testGetGrantedAuthorities((Attributes2GrantedAuthoritiesMapper)mapper, roles, expectedGas);
    }

    public final void testMapping6() {
        String[] roles = new String[]{"role6"};
        String[] expectedGas = new String[]{"ga10", "ga11", "ga12"};
        MapBasedAttributes2GrantedAuthoritiesMapper mapper = this.getDefaultMapper();
        this.testGetGrantedAuthorities((Attributes2GrantedAuthoritiesMapper)mapper, roles, expectedGas);
    }

    public final void testMapping7() {
        String[] roles = new String[]{"role7"};
        String[] expectedGas = new String[]{"ga13", "ga14"};
        MapBasedAttributes2GrantedAuthoritiesMapper mapper = this.getDefaultMapper();
        this.testGetGrantedAuthorities((Attributes2GrantedAuthoritiesMapper)mapper, roles, expectedGas);
    }

    public final void testMapping8() {
        String[] roles = new String[]{"role8"};
        String[] expectedGas = new String[]{"ga13", "ga14"};
        MapBasedAttributes2GrantedAuthoritiesMapper mapper = this.getDefaultMapper();
        this.testGetGrantedAuthorities((Attributes2GrantedAuthoritiesMapper)mapper, roles, expectedGas);
    }

    public final void testMapping9() {
        String[] roles = new String[]{"role9"};
        String[] expectedGas = new String[]{};
        MapBasedAttributes2GrantedAuthoritiesMapper mapper = this.getDefaultMapper();
        this.testGetGrantedAuthorities((Attributes2GrantedAuthoritiesMapper)mapper, roles, expectedGas);
    }

    public final void testMapping10() {
        String[] roles = new String[]{"role10"};
        String[] expectedGas = new String[]{};
        MapBasedAttributes2GrantedAuthoritiesMapper mapper = this.getDefaultMapper();
        this.testGetGrantedAuthorities((Attributes2GrantedAuthoritiesMapper)mapper, roles, expectedGas);
    }

    public final void testMapping11() {
        String[] roles = new String[]{"role11"};
        String[] expectedGas = new String[]{};
        MapBasedAttributes2GrantedAuthoritiesMapper mapper = this.getDefaultMapper();
        this.testGetGrantedAuthorities((Attributes2GrantedAuthoritiesMapper)mapper, roles, expectedGas);
    }

    public final void testNonExistingMapping() {
        String[] roles = new String[]{"nonExisting"};
        String[] expectedGas = new String[]{};
        MapBasedAttributes2GrantedAuthoritiesMapper mapper = this.getDefaultMapper();
        this.testGetGrantedAuthorities((Attributes2GrantedAuthoritiesMapper)mapper, roles, expectedGas);
    }

    public final void testMappingCombination() {
        String[] roles = new String[]{"role1", "role2", "role3", "role4", "role5", "role6", "role7", "role8", "role9", "role10", "role11"};
        String[] expectedGas = new String[]{"ga1", "ga2", "ga3", "ga4", "ga5", "ga6", "ga7", "ga8", "ga9", "ga10", "ga11", "ga12", "ga13", "ga14"};
        MapBasedAttributes2GrantedAuthoritiesMapper mapper = this.getDefaultMapper();
        this.testGetGrantedAuthorities((Attributes2GrantedAuthoritiesMapper)mapper, roles, expectedGas);
    }

    private HashMap getValidAttributes2GrantedAuthoritiesMap() {
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("role1", "ga1");
        m.put("role2", new GrantedAuthorityImpl("ga2"));
        m.put("role3", Arrays.asList("ga3", new GrantedAuthorityImpl("ga4")));
        m.put("role4", "ga5,ga6");
        m.put("role5", Arrays.asList("ga7", "ga8", new Object[]{new GrantedAuthorityImpl("ga9")}));
        m.put("role6", new Object[]{"ga10", "ga11", new Object[]{new GrantedAuthorityImpl("ga12")}});
        m.put("role7", new String[]{"ga13", "ga14"});
        m.put("role8", new String[]{"ga13", "ga14", null});
        m.put("role9", null);
        m.put("role10", new Object[0]);
        m.put("role11", Arrays.asList(new Object[]{null}));
        return m;
    }

    private MapBasedAttributes2GrantedAuthoritiesMapper getDefaultMapper() {
        MapBasedAttributes2GrantedAuthoritiesMapper mapper = new MapBasedAttributes2GrantedAuthoritiesMapper();
        mapper.setAttributes2grantedAuthoritiesMap((Map)this.getValidAttributes2GrantedAuthoritiesMap());
        mapper.afterPropertiesSet();
        return mapper;
    }

    private void testGetGrantedAuthorities(Attributes2GrantedAuthoritiesMapper mapper, String[] roles, String[] expectedGas) {
        GrantedAuthority[] result = mapper.getGrantedAuthorities(roles);
        ArrayList<String> resultColl = new ArrayList<String>(result.length);
        for (int i = 0; i < result.length; ++i) {
            resultColl.add(result[i].getAuthority());
        }
        List<String> expectedColl = Arrays.asList(expectedGas);
        MapBasedAttributes2GrantedAuthoritiesMapperTest.assertTrue((String)("Role collections do not match; result: " + resultColl + ", expected: " + expectedColl), (expectedColl.containsAll(resultColl) && resultColl.containsAll(expectedColl) ? 1 : 0) != 0);
    }
}

