/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.adapters;

import java.util.Arrays;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.springframework.security.Authentication;
import org.springframework.security.BadCredentialsException;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.GrantedAuthorityImpl;
import org.springframework.security.adapters.AuthByAdapterProvider;
import org.springframework.security.adapters.PrincipalSpringSecurityUserToken;
import org.springframework.security.providers.UsernamePasswordAuthenticationToken;

public class AuthByAdapterTests
extends TestCase {
    public AuthByAdapterTests() {
    }

    public AuthByAdapterTests(String arg0) {
        super(arg0);
    }

    public static void main(String[] args) {
        TestRunner.run(AuthByAdapterTests.class);
    }

    public final void setUp() throws Exception {
        super.setUp();
    }

    public void testAuthByAdapterProviderCorrectAuthenticationOperation() throws Exception {
        AuthByAdapterProvider provider = new AuthByAdapterProvider();
        provider.setKey("my_password");
        PrincipalSpringSecurityUserToken token = new PrincipalSpringSecurityUserToken("my_password", "Test", "Password", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")}, null);
        AuthByAdapterTests.assertTrue((boolean)provider.supports(token.getClass()));
        Authentication response = provider.authenticate((Authentication)token);
        AuthByAdapterTests.assertTrue((boolean)true);
        AuthByAdapterTests.assertEquals((Object)token.getCredentials(), (Object)response.getCredentials());
        AuthByAdapterTests.assertEquals((Object)token.getPrincipal(), (Object)response.getPrincipal());
        AuthByAdapterTests.assertTrue((boolean)Arrays.equals(token.getAuthorities(), response.getAuthorities()));
        if (!response.getClass().equals(token.getClass())) {
            AuthByAdapterTests.fail((String)"Should have returned same type of object it was given");
        }
        PrincipalSpringSecurityUserToken castResponse = (PrincipalSpringSecurityUserToken)response;
        AuthByAdapterTests.assertEquals((String)token.getName(), (String)castResponse.getName());
    }

    public void testAuthByAdapterProviderNonAuthenticationMethods() throws Exception {
        AuthByAdapterProvider provider = new AuthByAdapterProvider();
        try {
            provider.afterPropertiesSet();
            AuthByAdapterTests.fail((String)"Should have thrown IllegalArgumentException as key not set");
        }
        catch (IllegalArgumentException expected) {
            AuthByAdapterTests.assertTrue((boolean)true);
        }
        provider.setKey("my_password");
        provider.afterPropertiesSet();
        AuthByAdapterTests.assertTrue((boolean)true);
        AuthByAdapterTests.assertEquals((String)"my_password", (String)provider.getKey());
    }

    public void testAuthByAdapterProviderOnlyAcceptsAuthByAdapterImplementations() throws Exception {
        AuthByAdapterProvider provider = new AuthByAdapterProvider();
        provider.setKey("my_password");
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)"Test", (Object)"Password");
        AuthByAdapterTests.assertTrue((!provider.supports(token.getClass()) ? 1 : 0) != 0);
        try {
            provider.authenticate((Authentication)token);
            AuthByAdapterTests.fail((String)"Should have thrown ClassCastException (supports() false response was ignored)");
        }
        catch (ClassCastException expected) {
            AuthByAdapterTests.assertTrue((boolean)true);
        }
    }

    public void testAuthByAdapterProviderRequiresCorrectKey() throws Exception {
        AuthByAdapterProvider provider = new AuthByAdapterProvider();
        provider.setKey("my_password");
        PrincipalSpringSecurityUserToken token = new PrincipalSpringSecurityUserToken("wrong_password", "Test", "Password", null, null);
        try {
            provider.authenticate((Authentication)token);
            AuthByAdapterTests.fail((String)"Should have thrown BadCredentialsException");
        }
        catch (BadCredentialsException expected) {
            AuthByAdapterTests.assertTrue((boolean)true);
        }
    }
}

