/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.mysql;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.EnumSet;
import java.util.Set;
import org.mariadb.jdbc.internal.common.ColumnInformation;
import org.mariadb.jdbc.internal.common.DataType;
import org.mariadb.jdbc.internal.common.packet.RawPacket;
import org.mariadb.jdbc.internal.common.packet.buffer.Reader;
import org.mariadb.jdbc.internal.common.queryresults.ColumnFlags;
import org.mariadb.jdbc.internal.mysql.MySQLType;

public class MySQLColumnInformation
implements ColumnInformation {
    RawPacket buffer;
    private short charsetNumber;
    private long length;
    private DataType type;
    private byte decimals;
    private Set<ColumnFlags> flags;

    public static MySQLColumnInformation create(String name, MySQLType.Type type) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            int i = 0;
            while (i < 4) {
                byte[] byArray = new byte[2];
                byArray[0] = 1;
                baos.write(byArray);
                ++i;
            }
            i = 0;
            while (i < 2) {
                baos.write(new byte[]{(byte)name.length()});
                baos.write(name.getBytes());
                ++i;
            }
            baos.write(12);
            byte[] byArray = new byte[2];
            byArray[0] = 33;
            baos.write(byArray);
            byte[] byArray2 = new byte[4];
            byArray2[0] = 1;
            baos.write(byArray2);
            baos.write(MySQLType.toServer(type.getSqlType()));
            baos.write(new byte[2]);
            baos.write(0);
            baos.write(new byte[2]);
            return new MySQLColumnInformation(new RawPacket(ByteBuffer.wrap(baos.toByteArray()).order(ByteOrder.LITTLE_ENDIAN), 0));
        }
        catch (IOException ioe) {
            throw new RuntimeException("unexpected condition", ioe);
        }
    }

    public MySQLColumnInformation(RawPacket buffer) throws IOException {
        this.buffer = buffer;
        buffer.getByteBuffer().mark();
        Reader reader = new Reader(buffer);
        reader.skipLengthEncodedBytes();
        reader.skipLengthEncodedBytes();
        reader.skipLengthEncodedBytes();
        reader.skipLengthEncodedBytes();
        reader.skipLengthEncodedBytes();
        reader.skipLengthEncodedBytes();
        reader.skipBytes(1);
        this.charsetNumber = reader.readShort();
        this.length = reader.readInt();
        this.type = MySQLType.fromServer(reader.readByte());
        this.flags = MySQLColumnInformation.parseFlags(reader.readShort());
        this.decimals = reader.readByte();
        int sqlType = this.type.getSqlType();
        if (!(sqlType != 2004 && sqlType != -3 && sqlType != -2 && sqlType != -4 || this.isBinary())) {
            this.type = new MySQLType(MySQLType.Type.VARCHAR);
        }
    }

    private static Set<ColumnFlags> parseFlags(short i) {
        EnumSet<ColumnFlags> retFlags = EnumSet.noneOf(ColumnFlags.class);
        ColumnFlags[] columnFlagsArray = ColumnFlags.values();
        int n = columnFlagsArray.length;
        int n2 = 0;
        while (n2 < n) {
            ColumnFlags fieldFlag = columnFlagsArray[n2];
            if ((i & fieldFlag.flag()) == fieldFlag.flag()) {
                retFlags.add(fieldFlag);
            }
            ++n2;
        }
        return retFlags;
    }

    private String getString(int idx) {
        try {
            this.buffer.getByteBuffer().reset();
            this.buffer.getByteBuffer().mark();
            Reader reader = new Reader(this.buffer);
            int i = 0;
            while (i < idx) {
                reader.skipLengthEncodedBytes();
                ++i;
            }
            return new String(reader.getLengthEncodedBytes(), "UTF-8");
        }
        catch (Exception e) {
            throw new RuntimeException("this does not happen", e);
        }
    }

    @Override
    public String getCatalog() {
        return null;
    }

    @Override
    public String getDb() {
        return this.getString(1);
    }

    @Override
    public String getTable() {
        return this.getString(2);
    }

    @Override
    public String getOriginalTable() {
        return this.getString(3);
    }

    @Override
    public String getName() {
        return this.getString(4);
    }

    @Override
    public String getOriginalName() {
        return this.getString(5);
    }

    @Override
    public short getCharsetNumber() {
        return this.charsetNumber;
    }

    @Override
    public long getLength() {
        return this.length;
    }

    @Override
    public DataType getType() {
        return this.type;
    }

    @Override
    public byte getDecimals() {
        return this.decimals;
    }

    @Override
    public Set<ColumnFlags> getFlags() {
        return this.flags;
    }

    @Override
    public boolean isSigned() {
        return !this.flags.contains((Object)ColumnFlags.UNSIGNED);
    }

    @Override
    public boolean isBinary() {
        return this.flags.contains((Object)ColumnFlags.BINARY) || this.getCharsetNumber() == 63;
    }
}

