/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.mondrian;

import com.tonbeller.jpivot.core.ExtensionSupport;
import com.tonbeller.jpivot.mondrian.MondrianMember;
import com.tonbeller.jpivot.mondrian.MondrianModel;
import com.tonbeller.jpivot.mondrian.MondrianQueryAdapter;
import com.tonbeller.jpivot.olap.model.Axis;
import com.tonbeller.jpivot.olap.model.Member;
import com.tonbeller.jpivot.olap.model.OlapException;
import com.tonbeller.jpivot.olap.model.Position;
import com.tonbeller.jpivot.olap.model.Result;
import com.tonbeller.jpivot.olap.navi.ChangeSlicer;
import com.tonbeller.tbutils.res.Resources;
import java.util.ArrayList;
import java.util.List;
import mondrian.mdx.MemberExpr;
import mondrian.mdx.UnresolvedFunCall;
import mondrian.olap.AxisOrdinal;
import mondrian.olap.Exp;
import mondrian.olap.Query;
import mondrian.olap.QueryAxis;
import mondrian.olap.Syntax;
import org.apache.log4j.Logger;

public class MondrianChangeSlicer
extends ExtensionSupport
implements ChangeSlicer {
    static Logger logger = Logger.getLogger(MondrianChangeSlicer.class);

    public MondrianChangeSlicer() {
        super.setId("changeSlicer");
    }

    public Member[] getSlicer() {
        MondrianModel model = (MondrianModel)this.getModel();
        Result res = null;
        try {
            res = model.getResult();
        }
        catch (OlapException ex) {
            return new Member[0];
        }
        Axis slicer = res.getSlicer();
        List positions = slicer.getPositions();
        ArrayList<Member> members = new ArrayList<Member>();
        for (Position pos : positions) {
            Member[] posMembers = pos.getMembers();
            for (int i = 0; i < posMembers.length; ++i) {
                if (members.contains(posMembers[i])) continue;
                members.add(posMembers[i]);
            }
        }
        return members.toArray(new Member[0]);
    }

    public void setSlicer(Member[] members) {
        MondrianModel model = (MondrianModel)this.getModel();
        MondrianQueryAdapter adapter = (MondrianQueryAdapter)model.getQueryAdapter();
        Query monQuery = adapter.getMonQuery();
        boolean logInfo = logger.isInfoEnabled();
        if (members.length == 0) {
            monQuery.setSlicerAxis(null);
            if (logInfo) {
                logger.info((Object)Resources.instance().getString("jpivot.MondrianChangeSlicer.message.slicerSetToNull"));
            }
        } else {
            Exp[] monExpr = new Exp[members.length];
            for (int i = 0; i < monExpr.length; ++i) {
                monExpr[i] = this.createExpressionFor(monQuery, (MondrianMember)members[i]);
            }
            UnresolvedFunCall f = new UnresolvedFunCall("()", Syntax.Parentheses, monExpr);
            monQuery.setSlicerAxis(new QueryAxis(false, (Exp)f, (AxisOrdinal)AxisOrdinal.StandardAxisOrdinal.SLICER, QueryAxis.SubtotalVisibility.Undefined));
            if (logInfo) {
                StringBuffer sb = new StringBuffer(Resources.instance().getString("jpivot.MondrianChangeSlicer.message.slicerMonExpr"));
                for (int i = 0; i < monExpr.length; ++i) {
                    if (i > 0) {
                        sb.append(",");
                    }
                    sb.append(monExpr[i].toString());
                }
                sb.append(")");
                logger.info((Object)sb.toString());
            }
        }
        model.fireModelChanged();
    }

    protected Exp createExpressionFor(Query monQuery, MondrianMember member) {
        return new MemberExpr(member.getMonMember());
    }
}

