/*
 * Decompiled with CFR 0.152.
 */
package com.ingres.gcf.util;

import com.ingres.gcf.util.SqlData;
import com.ingres.gcf.util.SqlEx;
import java.math.BigDecimal;

public class SqlInt
extends SqlData {
    private int value = 0;

    public SqlInt() {
        super(true);
    }

    public SqlInt(int n) {
        super(false);
        this.value = n;
    }

    public void set(int n) {
        this.setNotNull();
        this.value = n;
    }

    public void set(SqlInt sqlInt) {
        if (sqlInt == null || sqlInt.isNull()) {
            this.setNull();
        } else {
            this.setNotNull();
            this.value = sqlInt.value;
        }
    }

    public int get() {
        return this.value;
    }

    public void setBoolean(boolean bl) throws SqlEx {
        this.setNotNull();
        this.value = bl ? 1 : 0;
    }

    public void setByte(byte by) throws SqlEx {
        this.setNotNull();
        this.value = by;
    }

    public void setShort(short s) throws SqlEx {
        this.setNotNull();
        this.value = s;
    }

    public void setInt(int n) throws SqlEx {
        this.setNotNull();
        this.value = n;
    }

    public void setLong(long l) throws SqlEx {
        this.setNotNull();
        this.value = (int)l;
    }

    public void setFloat(float f) throws SqlEx {
        this.setNotNull();
        this.value = (int)f;
    }

    public void setDouble(double d) throws SqlEx {
        this.setNotNull();
        this.value = (int)d;
    }

    public void setBigDecimal(BigDecimal bigDecimal) throws SqlEx {
        if (bigDecimal == null) {
            this.setNull();
        } else {
            this.setNotNull();
            this.value = bigDecimal.intValue();
        }
    }

    public void setString(String string) throws SqlEx {
        if (string == null) {
            this.setNull();
        } else {
            this.setNotNull();
            try {
                this.value = Integer.parseInt(string.trim());
            }
            catch (NumberFormatException numberFormatException) {
                throw SqlEx.get(ERR_GC401A_CONVERSION_ERR);
            }
        }
    }

    public boolean getBoolean() throws SqlEx {
        return this.value != 0;
    }

    public byte getByte() throws SqlEx {
        return (byte)this.value;
    }

    public short getShort() throws SqlEx {
        return (short)this.value;
    }

    public int getInt() throws SqlEx {
        return this.value;
    }

    public long getLong() throws SqlEx {
        return this.value;
    }

    public float getFloat() throws SqlEx {
        return this.value;
    }

    public double getDouble() throws SqlEx {
        return this.value;
    }

    public BigDecimal getBigDecimal() throws SqlEx {
        return BigDecimal.valueOf(this.value);
    }

    public String getString() throws SqlEx {
        return Integer.toString(this.value);
    }

    public Object getObject() throws SqlEx {
        return new Integer(this.value);
    }
}

