/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jboss;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.ResourceBundle;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceController;
import org.teiid.adminapi.Admin;
import org.teiid.adminapi.VDB;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.core.BundleUtil;
import org.teiid.deployers.VDBRepository;
import org.teiid.jboss.BaseOperationHandler;
import org.teiid.jboss.IntegrationPlugin;
import org.teiid.jboss.TeiidServiceNames;
import org.teiid.metadata.Schema;
import org.teiid.query.metadata.CompositeMetadataStore;
import org.teiid.query.metadata.DDLStringVisitor;
import org.teiid.query.metadata.TransformationMetadata;

class GetSchema
extends BaseOperationHandler<VDBRepository> {
    protected GetSchema() {
        super("get-schema");
    }

    @Override
    protected VDBRepository getService(OperationContext context, PathAddress pathAddress, ModelNode operation) throws OperationFailedException {
        ServiceController sc = context.getServiceRegistry(false).getRequiredService(TeiidServiceNames.VDB_REPO);
        return (VDBRepository)VDBRepository.class.cast(sc.getValue());
    }

    @Override
    protected void executeOperation(OperationContext context, VDBRepository repo, ModelNode operation) throws OperationFailedException {
        if (!operation.hasDefined("vdb-name")) {
            throw new OperationFailedException(new ModelNode().set(IntegrationPlugin.Util.getString("vdb-name.missing")));
        }
        if (!operation.hasDefined("vdb-version")) {
            throw new OperationFailedException(new ModelNode().set(IntegrationPlugin.Util.getString("vdb-version.missing")));
        }
        if (!operation.hasDefined("model-name")) {
            throw new OperationFailedException(new ModelNode().set(IntegrationPlugin.Util.getString("model-name.missing")));
        }
        ModelNode result = context.getResult();
        String vdbName = operation.get("vdb-name").asString();
        int vdbVersion = operation.get("vdb-version").asInt();
        String modelName = operation.get("model-name").asString();
        VDBMetaData vdb = repo.getLiveVDB(vdbName, vdbVersion);
        if (vdb == null || vdb.getStatus() != VDB.Status.ACTIVE) {
            throw new OperationFailedException(new ModelNode().set(IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50096, new Object[]{vdbName, vdbVersion})));
        }
        EnumSet<Admin.SchemaObjectType> schemaTypes = null;
        if (vdb.getModel(modelName) == null) {
            throw new OperationFailedException(new ModelNode().set(IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50097, new Object[]{vdbName, vdbVersion, modelName})));
        }
        if (operation.hasDefined("entity-type")) {
            String[] types = operation.get("entity-type").asString().toUpperCase().split(",");
            if (types.length > 0) {
                ArrayList<Admin.SchemaObjectType> sot = new ArrayList<Admin.SchemaObjectType>();
                for (int i = 1; i < types.length; ++i) {
                    sot.add(Admin.SchemaObjectType.valueOf((String)types[i]));
                }
                schemaTypes = EnumSet.of(Admin.SchemaObjectType.valueOf((String)types[0]), (Enum[])sot.toArray(new Admin.SchemaObjectType[sot.size()]));
            } else {
                schemaTypes = EnumSet.of(Admin.SchemaObjectType.valueOf((String)types[0]));
            }
        }
        String regEx = null;
        if (operation.hasDefined("entity-pattern")) {
            regEx = operation.get("entity-pattern").asString();
        }
        CompositeMetadataStore metadataStore = ((TransformationMetadata)vdb.getAttachment(TransformationMetadata.class)).getMetadataStore();
        Schema schema = metadataStore.getSchema(modelName);
        String ddl = DDLStringVisitor.getDDLString((Schema)schema, schemaTypes, (String)regEx);
        result.set(ddl);
    }

    @Override
    protected void describeParameters(ModelNode operationNode, ResourceBundle bundle) {
        operationNode.get(new String[]{"request-properties", "vdb-name", "type"}).set(ModelType.STRING);
        operationNode.get(new String[]{"request-properties", "vdb-name", "required"}).set(true);
        operationNode.get(new String[]{"request-properties", "vdb-name", "description"}).set(this.getParameterDescription(bundle, "vdb-name"));
        operationNode.get(new String[]{"request-properties", "vdb-version", "type"}).set(ModelType.STRING);
        operationNode.get(new String[]{"request-properties", "vdb-version", "required"}).set(true);
        operationNode.get(new String[]{"request-properties", "vdb-version", "description"}).set(this.getParameterDescription(bundle, "vdb-version"));
        operationNode.get(new String[]{"request-properties", "model-name", "type"}).set(ModelType.STRING);
        operationNode.get(new String[]{"request-properties", "model-name", "required"}).set(true);
        operationNode.get(new String[]{"request-properties", "model-name", "description"}).set(this.getParameterDescription(bundle, "model-name"));
        operationNode.get(new String[]{"request-properties", "entity-type", "type"}).set(ModelType.STRING);
        operationNode.get(new String[]{"request-properties", "entity-type", "required"}).set(false);
        operationNode.get(new String[]{"request-properties", "entity-type", "description"}).set(this.getParameterDescription(bundle, "entity-type"));
        operationNode.get(new String[]{"request-properties", "entity-pattern", "type"}).set(ModelType.STRING);
        operationNode.get(new String[]{"request-properties", "entity-pattern", "required"}).set(false);
        operationNode.get(new String[]{"request-properties", "entity-pattern", "description"}).set(this.getParameterDescription(bundle, "entity-pattern"));
        ModelNode reply = operationNode.get("reply-properties");
        reply.get("type").set(ModelType.STRING);
    }
}

