/*
 * Decompiled with CFR 0.152.
 */
package com.ingres.gcf.util;

import com.ingres.gcf.util.SqlData;
import com.ingres.gcf.util.SqlDates;
import com.ingres.gcf.util.SqlEx;
import java.sql.Timestamp;
import java.util.Date;
import java.util.TimeZone;

public class SqlDate
extends SqlData {
    private String value = null;

    public SqlDate() {
        super(true);
    }

    public void set(String string) {
        if (string == null) {
            this.setNull();
        } else {
            this.setNotNull();
            this.value = string;
        }
    }

    public void set(SqlDate sqlDate) {
        if (sqlDate == null || sqlDate.isNull()) {
            this.setNull();
        } else {
            this.setNotNull();
            this.value = sqlDate.value;
        }
    }

    public String get() {
        return this.value;
    }

    public void setString(String string) throws SqlEx {
        if (string == null) {
            this.setNull();
        } else {
            java.sql.Date date;
            try {
                date = java.sql.Date.valueOf(string);
            }
            catch (Exception exception) {
                throw SqlEx.get(ERR_GC401A_CONVERSION_ERR);
            }
            this.setDate(date, null);
        }
    }

    public void setDate(java.sql.Date date, TimeZone timeZone) throws SqlEx {
        this.set(date, timeZone);
    }

    public void setTimestamp(Timestamp timestamp, TimeZone timeZone) throws SqlEx {
        this.set(timestamp, timeZone);
    }

    private void set(Date date, TimeZone timeZone) throws SqlEx {
        if (date == null) {
            this.setNull();
            return;
        }
        this.setNotNull();
        String string = this.value = timeZone != null ? SqlDates.formatDate(date, timeZone) : SqlDates.formatDate(date, false);
        if (this.value == null || this.value.length() != 10 || this.value.charAt(4) != '-' || this.value.charAt(7) != '-') {
            throw SqlEx.get(ERR_GC401A_CONVERSION_ERR);
        }
    }

    public String getString() throws SqlEx {
        return SqlDates.formatDate((Date)this.get(null), false);
    }

    public java.sql.Date getDate(TimeZone timeZone) throws SqlEx {
        return this.get(timeZone);
    }

    public Timestamp getTimestamp(TimeZone timeZone) throws SqlEx {
        return new Timestamp(this.get(timeZone).getTime());
    }

    public Object getObject() throws SqlEx {
        return this.get(null);
    }

    private java.sql.Date get(TimeZone timeZone) throws SqlEx {
        return timeZone != null ? SqlDates.parseDate(this.value, timeZone) : SqlDates.parseDate(this.value, false);
    }
}

