/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.guice;

import com.google.inject.Injector;
import com.google.inject.Key;
import java.util.Collection;
import java.util.Map;
import org.directwebremoting.extend.Creator;
import org.directwebremoting.extend.CreatorManager;
import org.directwebremoting.guice.DwrGuiceUtil;
import org.directwebremoting.guice.InternalCreator;
import org.directwebremoting.guice.Remoted;
import org.directwebremoting.impl.DefaultCreatorManager;
import org.directwebremoting.util.Logger;

public class InternalCreatorManager
implements CreatorManager {
    private final CreatorManager creatorManager = InternalCreatorManager.getCreatorManager();
    private static final ThreadLocal<String> typeName = new ThreadLocal();
    private static final Logger log = Logger.getLogger(InternalCreatorManager.class);

    public InternalCreatorManager() {
        this.addCreators();
    }

    public void setDebug(boolean debug) {
        if (this.creatorManager instanceof DefaultCreatorManager) {
            DefaultCreatorManager dcm = (DefaultCreatorManager)this.creatorManager;
            dcm.setDebug(debug);
        }
    }

    public boolean isDebug() {
        return this.creatorManager.isDebug();
    }

    public void addCreatorType(String typeName, String className) {
        this.creatorManager.addCreatorType(typeName, className);
    }

    public void addCreator(String scriptName, String typeName, Map params) throws InstantiationException, IllegalAccessException, IllegalArgumentException {
        this.creatorManager.addCreator(scriptName, typeName, params);
    }

    public void addCreator(String scriptName, Creator creator) throws IllegalArgumentException {
        this.creatorManager.addCreator(scriptName, creator);
    }

    public Collection getCreatorNames() throws SecurityException {
        return this.creatorManager.getCreatorNames();
    }

    public Creator getCreator(String scriptName) throws SecurityException {
        return this.creatorManager.getCreator(scriptName);
    }

    public void setCreators(Map creators) {
        this.creatorManager.setCreators(creators);
    }

    public boolean isInitApplicationScopeCreatorsAtStartup() {
        if (this.creatorManager instanceof DefaultCreatorManager) {
            DefaultCreatorManager dcm = (DefaultCreatorManager)this.creatorManager;
            return dcm.isInitApplicationScopeCreatorsAtStartup();
        }
        return false;
    }

    public void setInitApplicationScopeCreatorsAtStartup(boolean initApplicationScopeCreatorsAtStartup) {
        if (this.creatorManager instanceof DefaultCreatorManager) {
            DefaultCreatorManager dcm = (DefaultCreatorManager)this.creatorManager;
            dcm.setInitApplicationScopeCreatorsAtStartup(initApplicationScopeCreatorsAtStartup);
        }
    }

    private void addCreators() {
        Injector injector = DwrGuiceUtil.getInjector();
        for (Key key : injector.getBindings().keySet()) {
            Class atype = key.getAnnotationType();
            if (atype == null || !Remoted.class.isAssignableFrom(atype)) continue;
            String scriptName = ((Remoted)Remoted.class.cast(key.getAnnotation())).value();
            if (scriptName.equals("")) {
                Class cls = (Class)key.getTypeLiteral().getType();
                scriptName = cls.getSimpleName();
            }
            this.addCreator(scriptName, new InternalCreator(injector, key, scriptName));
        }
    }

    static void setTypeName(String name) {
        typeName.set(name);
    }

    private static CreatorManager getCreatorManager() {
        String name = typeName.get();
        try {
            Class<?> cls = Class.forName(name);
            return (CreatorManager)cls.newInstance();
        }
        catch (Exception e) {
            if (name != null && !"".equals(name)) {
                log.warn("Couldn't make CreatorManager from type: " + name);
            }
            return new DefaultCreatorManager();
        }
    }
}

