/*
 * Decompiled with CFR 0.152.
 */
package jscover.server;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import jscover.server.MIME;

public class HttpRequest {
    private String path;
    private URL url;
    private Map<String, List<String>> headers;

    public HttpRequest(String path) {
        try {
            this.url = new URL(path);
            this.path = this.url.getPath();
        }
        catch (MalformedURLException e) {
            int index = path.indexOf("?");
            if (index > 0) {
                path = path.substring(0, index);
            }
            this.path = path.replaceAll("//", "/");
        }
    }

    public String getPath() {
        return this.path;
    }

    protected MIME getMime() {
        String extension = null;
        int dot = this.path.lastIndexOf(46);
        if (dot >= 0) {
            extension = this.path.substring(dot + 1).toLowerCase();
        }
        return MIME.getMime(extension);
    }

    public String getRelativePath() {
        return this.getPath().startsWith("/") ? this.getPath().substring(1) : this.getPath();
    }

    public URL getUrl() {
        return this.url;
    }

    public void setHeaders(Map<String, List<String>> headers) {
        this.headers = headers;
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }
}

