/*
 * Decompiled with CFR 0.152.
 */
package jscover.report;

import java.io.File;
import java.util.List;
import java.util.TreeMap;
import jscover.report.CoverageData;
import jscover.report.JSONDataMerger;
import jscover.report.ScriptLinesAndSource;
import jscover.util.IoUtils;

public class JSONDataSaver {
    private JSONDataMerger jsonDataMerger = new JSONDataMerger();
    private IoUtils ioUtils = IoUtils.getInstance();

    public void saveJSONData(File reportDir, String data, List<ScriptLinesAndSource> unloadJSData) {
        reportDir.mkdirs();
        File jsonFile = new File(reportDir, "jscoverage.json");
        TreeMap<String, CoverageData> extraData = new TreeMap<String, CoverageData>();
        if (jsonFile.exists()) {
            String existingJSON = this.ioUtils.toString(jsonFile);
            extraData.putAll(this.jsonDataMerger.mergeJSONCoverageData(existingJSON, data));
            this.ioUtils.copy(this.jsonDataMerger.toJSON(extraData), jsonFile);
        } else if (unloadJSData != null) {
            extraData.putAll(this.jsonDataMerger.createEmptyJSON(unloadJSData));
            extraData.putAll(this.jsonDataMerger.jsonToMap(data));
            this.ioUtils.copy(this.jsonDataMerger.toJSON(extraData), jsonFile);
        } else {
            this.ioUtils.copy(data, jsonFile);
        }
    }
}

