/*
 * Decompiled with CFR 0.152.
 */
package jscover.instrument;

import java.util.SortedSet;
import jscover.instrument.NodeProcessor;
import jscover.util.Logger;
import org.mozilla.javascript.ast.AstNode;
import org.mozilla.javascript.ast.NodeVisitor;

class ParseTreeInstrumenter
implements NodeVisitor {
    private String fileName;
    private NodeProcessor nodeProcessor;
    private Logger logger = Logger.getInstance();

    public ParseTreeInstrumenter(String uri) {
        this.fileName = uri;
        this.nodeProcessor = new NodeProcessor(uri);
    }

    public SortedSet<Integer> getValidLines() {
        return this.nodeProcessor.getValidLines();
    }

    @Override
    public boolean visit(AstNode node) {
        try {
            return this.nodeProcessor.processNode(node);
        }
        catch (RuntimeException t) {
            this.logger.log(String.format("Error on line %s of %s", node.getLineno(), this.fileName), t);
            return true;
        }
    }
}

