/*
 * Decompiled with CFR 0.152.
 */
package jscover.instrument;

import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import jscover.instrument.StatementBuilder;
import org.mozilla.javascript.ast.ArrayLiteral;
import org.mozilla.javascript.ast.AstNode;
import org.mozilla.javascript.ast.Block;
import org.mozilla.javascript.ast.BreakStatement;
import org.mozilla.javascript.ast.ConditionalExpression;
import org.mozilla.javascript.ast.ContinueStatement;
import org.mozilla.javascript.ast.EmptyExpression;
import org.mozilla.javascript.ast.EmptyStatement;
import org.mozilla.javascript.ast.ExpressionStatement;
import org.mozilla.javascript.ast.FunctionCall;
import org.mozilla.javascript.ast.FunctionNode;
import org.mozilla.javascript.ast.IfStatement;
import org.mozilla.javascript.ast.InfixExpression;
import org.mozilla.javascript.ast.KeywordLiteral;
import org.mozilla.javascript.ast.Label;
import org.mozilla.javascript.ast.LabeledStatement;
import org.mozilla.javascript.ast.LetNode;
import org.mozilla.javascript.ast.Loop;
import org.mozilla.javascript.ast.ObjectProperty;
import org.mozilla.javascript.ast.ParenthesizedExpression;
import org.mozilla.javascript.ast.ReturnStatement;
import org.mozilla.javascript.ast.Scope;
import org.mozilla.javascript.ast.SwitchCase;
import org.mozilla.javascript.ast.SwitchStatement;
import org.mozilla.javascript.ast.ThrowStatement;
import org.mozilla.javascript.ast.TryStatement;
import org.mozilla.javascript.ast.VariableDeclaration;
import org.mozilla.javascript.ast.VariableInitializer;
import org.mozilla.javascript.ast.WithStatement;

class NodeProcessor {
    private StatementBuilder statementBuilder = new StatementBuilder();
    private SortedSet<Integer> validLines = new TreeSet<Integer>();
    private String fileName;

    public NodeProcessor(String uri) {
        this.fileName = uri;
    }

    public ExpressionStatement buildInstrumentationStatement(int lineNumber) {
        return this.statementBuilder.buildInstrumentationStatement(lineNumber, this.fileName, this.validLines);
    }

    boolean processNode(AstNode node) {
        AstNode parent;
        if (this.validLines.contains(node.getLineno())) {
            return true;
        }
        if (node.getParent() == null || node.getLineno() == node.getParent().getLineno()) {
            // empty if block
        }
        if ((parent = node.getParent()) instanceof ObjectProperty || parent instanceof FunctionCall) {
            return true;
        }
        if (node instanceof SwitchStatement || node instanceof WithStatement) {
            parent.addChildBefore(this.buildInstrumentationStatement(node.getLineno()), node);
        } else if (node instanceof SwitchCase) {
            List<AstNode> statements = ((SwitchCase)node).getStatements();
            if (statements == null) {
                return true;
            }
            for (int i = statements.size() - 1; i >= 0; --i) {
                AstNode statement = statements.get(i);
                statements.add(i, this.buildInstrumentationStatement(statement.getLineno()));
            }
        } else if (node instanceof ExpressionStatement || node instanceof EmptyExpression || node instanceof ContinueStatement || node instanceof BreakStatement || node instanceof EmptyStatement || node instanceof ThrowStatement) {
            if (node.getLineno() < 1) {
                return true;
            }
            if (parent instanceof IfStatement) {
                IfStatement parentIf = (IfStatement)parent;
                Scope scope = new Scope();
                scope.addChild(this.buildInstrumentationStatement(node.getLineno()));
                scope.addChild(node);
                if (parentIf.getThenPart() == node) {
                    parentIf.setThenPart(scope);
                } else if (parentIf.getElsePart() == node) {
                    parentIf.setElsePart(scope);
                }
            } else if (parent instanceof Loop) {
                Loop parentLoop = (Loop)parent;
                Scope scope = new Scope();
                scope.addChild(this.buildInstrumentationStatement(node.getLineno()));
                scope.addChild(node);
                parentLoop.setBody(scope);
            } else if (parent instanceof WithStatement) {
                Scope scope = new Scope();
                scope.addChild(this.buildInstrumentationStatement(node.getLineno()));
                scope.addChild(node);
                ((WithStatement)parent).setStatement(scope);
            } else if (!(parent instanceof SwitchCase) && parent != null) {
                parent.addChildBefore(this.buildInstrumentationStatement(node.getLineno()), node);
            }
        } else if (node instanceof FunctionNode || node instanceof TryStatement || this.isDebugStatement(node)) {
            if (!(parent instanceof InfixExpression || parent instanceof VariableInitializer || parent instanceof ConditionalExpression || parent instanceof ArrayLiteral || parent instanceof ParenthesizedExpression)) {
                parent.addChildBefore(this.buildInstrumentationStatement(node.getLineno()), node);
            }
        } else if (node instanceof ReturnStatement) {
            ExpressionStatement newChild = this.buildInstrumentationStatement(node.getLineno());
            if (parent instanceof Block) {
                parent.addChildBefore(newChild, node);
            } else if (parent instanceof IfStatement) {
                IfStatement parentIf = (IfStatement)parent;
                Scope scope = new Scope();
                scope.addChild(newChild);
                scope.addChild(node);
                if (parentIf.getThenPart() == node) {
                    parentIf.setThenPart(scope);
                } else if (parentIf.getElsePart() == node) {
                    parentIf.setElsePart(scope);
                }
            } else {
                parent.addChildBefore(newChild, node);
            }
        } else if (node instanceof VariableDeclaration || node instanceof LetNode) {
            if (!(parent instanceof LetNode)) {
                parent.addChildBefore(this.buildInstrumentationStatement(node.getLineno()), node);
            }
        } else if (node instanceof Loop) {
            parent.addChildBefore(this.buildInstrumentationStatement(node.getLineno()), node);
        } else if (node instanceof Label) {
            ExpressionStatement newChild = this.buildInstrumentationStatement(node.getLineno());
            if (parent instanceof LabeledStatement) {
                LabeledStatement parentLabel = (LabeledStatement)parent;
                Scope scope = new Scope();
                scope.addChild(newChild);
                scope.addChild(parentLabel.getStatement());
                parentLabel.setStatement(scope);
            } else {
                parent.addChildAfter(newChild, node);
            }
        } else if (node instanceof IfStatement) {
            ExpressionStatement newChild = this.buildInstrumentationStatement(node.getLineno());
            if (parent instanceof IfStatement) {
                IfStatement parentIf = (IfStatement)parent;
                Scope scope = new Scope();
                scope.addChild(newChild);
                scope.addChild(node);
                if (parentIf.getElsePart() == node) {
                    parentIf.setElsePart(scope);
                }
            } else {
                parent.addChildBefore(newChild, node);
            }
        }
        return true;
    }

    private boolean isDebugStatement(AstNode node) {
        if (!(node instanceof KeywordLiteral)) {
            return false;
        }
        KeywordLiteral keywordLiteral = (KeywordLiteral)node;
        return keywordLiteral.getType() == 160;
    }

    public SortedSet<Integer> getValidLines() {
        return this.validLines;
    }
}

