/*
 * Decompiled with CFR 0.152.
 */
package jmxlogger.tools;

import java.io.File;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import jmxlogger.tools.JmxConfigStore;
import jmxlogger.tools.JmxEventWrapper;
import jmxlogger.tools.JmxLogEmitter;
import jmxlogger.tools.JmxLogEmitterMBean;
import jmxlogger.tools.JmxScriptedLogFilter;
import jmxlogger.tools.ToolBox;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JmxLogService {
    private JmxLogEmitterMBean logMBean;
    private JmxScriptedLogFilter logFilter;
    private JmxConfigStore configStore;
    private AtomicLong totalLogCounter = new AtomicLong(0L);
    private AtomicLong attemptedLogCounter = new AtomicLong(0L);
    private ConcurrentHashMap<String, Long> logStatistics;
    private final PriorityBlockingQueue<JmxEventWrapper> queue = new PriorityBlockingQueue(100);
    private ExecutorService noteConsumer;
    private ExecutorService noteProducers;
    private int producerSize = 5;
    private Date startTime;

    private JmxLogService() {
        this.configStore = new JmxConfigStore();
        this.initializeService();
    }

    private JmxLogService(JmxConfigStore store) {
        this.configStore = store;
        this.initializeService();
    }

    public static JmxLogService createInstance() {
        return new JmxLogService();
    }

    public static JmxLogService createInstance(JmxConfigStore store) {
        return new JmxLogService(store);
    }

    private void initializeService() {
        this.logMBean = new JmxLogEmitter(this.configStore);
        this.logFilter = new JmxScriptedLogFilter();
        this.logStatistics = new ConcurrentHashMap();
        this.configStore.addListener(new JmxConfigStore.ConfigEventListener(){

            public void onValueChanged(JmxConfigStore.ConfigEvent event) {
                if (!event.getSource().equals(JmxLogService.this) && event.getKey().equals("filterExpression")) {
                    JmxLogService.this.logFilter.setFilterExpression((String)event.getValue());
                }
                if (!event.getSource().equals(JmxLogService.this) && event.getKey().equals("filterScript")) {
                    JmxLogService.this.logFilter.setScriptFile((File)event.getValue());
                }
            }
        });
    }

    public JmxConfigStore getDefaultConfigurationStore() {
        return this.configStore;
    }

    public void start() {
        this.setupNoteProducers();
        this.setupNoteConsumerTask();
        MBeanServer svr = (MBeanServer)this.configStore.getValue("jmxServer");
        ObjectName objName = (ObjectName)this.configStore.getValue("jmxObjectName");
        if (svr == null || objName == null) {
            throw new IllegalArgumentException("Unable to start log service - instance of MBeanServer and ObjectName must be provided.");
        }
        ToolBox.registerMBean(svr, objName, this.logMBean);
        this.logMBean.start();
        this.startTime = new Date();
        this.logStatistics.put("startTime", new Long(this.startTime.getTime()));
    }

    public void stop() {
        this.noteConsumer.shutdownNow();
        this.noteProducers.shutdownNow();
        MBeanServer svr = (MBeanServer)this.configStore.getValue("jmxServer");
        ObjectName objName = (ObjectName)this.configStore.getValue("jmxObjectName");
        ToolBox.unregisterMBean(svr, objName);
        this.logMBean.stop();
    }

    public boolean isStarted() {
        return this.logMBean.isStarted();
    }

    public void log(final Map<String, Object> event) {
        if (!this.logMBean.isStarted()) {
            throw new IllegalStateException("JmxEventLogger has not been started.Call JmxEventLogger.start() before you log messages.");
        }
        this.logStatistics.put("totalLogAttempted", new Long(this.attemptedLogCounter.incrementAndGet()));
        event.put("logStats", Collections.unmodifiableMap(this.logStatistics));
        event.put("systemStats", Collections.unmodifiableMap(ToolBox.getSystemInfo()));
        this.noteProducers.execute(new Runnable(){

            public void run() {
                if (JmxLogService.this.logFilter.isLogAllowed(Collections.unmodifiableMap(event))) {
                    String logger;
                    String level = (String)event.get("logLevel");
                    if (level != null) {
                        Long levelCount = (Long)JmxLogService.this.logStatistics.get(level);
                        if (levelCount == null) {
                            JmxLogService.this.logStatistics.put(level, new Long(1L));
                        } else {
                            long updatedVal = levelCount + 1L;
                            JmxLogService.this.logStatistics.put(level, new Long(updatedVal));
                        }
                    }
                    if ((logger = (String)event.get("loggerName")) != null) {
                        Long loggerCount = (Long)JmxLogService.this.logStatistics.get(logger);
                        if (loggerCount == null) {
                            JmxLogService.this.logStatistics.put(logger, new Long(1L));
                        } else {
                            long updatedVal = loggerCount + 1L;
                            JmxLogService.this.logStatistics.put(logger, new Long(updatedVal));
                        }
                    }
                    JmxLogService.this.logStatistics.put("totalLogCounted", new Long(JmxLogService.this.totalLogCounter.incrementAndGet()));
                    event.put("logStats", Collections.unmodifiableMap(JmxLogService.this.logStatistics));
                    HashMap sysStats = new HashMap();
                    JmxLogService.this.queue.put(new JmxEventWrapper(Collections.unmodifiableMap(event)));
                }
            }
        });
    }

    private void setupNoteProducers() {
        this.noteProducers = Executors.newFixedThreadPool(this.producerSize);
    }

    private void setupNoteConsumerTask() {
        this.noteConsumer = Executors.newSingleThreadExecutor();
        this.noteConsumer.execute(new Runnable(){

            public void run() {
                try {
                    while (true) {
                        JmxEventWrapper eventWrapper = (JmxEventWrapper)JmxLogService.this.queue.take();
                        ((JmxLogEmitter)JmxLogService.this.logMBean).sendLog(eventWrapper.unwrap());
                    }
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                    return;
                }
            }
        });
    }
}

