/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sort;

import net.sf.saxon.Configuration;
import net.sf.saxon.Platform;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.sort.AtomicComparer;
import net.sf.saxon.sort.CalendarValueComparer;
import net.sf.saxon.sort.CodepointCollatingComparer;
import net.sf.saxon.sort.CodepointCollator;
import net.sf.saxon.sort.CollatingAtomicComparer;
import net.sf.saxon.sort.ComparisonKey;
import net.sf.saxon.sort.DecimalSortComparer;
import net.sf.saxon.sort.DoubleSortComparer;
import net.sf.saxon.sort.StringCollator;
import net.sf.saxon.trans.NoDynamicContextException;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.CalendarValue;
import net.sf.saxon.value.DurationValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;

public class AtomicSortComparer
implements AtomicComparer {
    private StringCollator collator;
    private transient XPathContext context;
    private int itemType;
    protected static StructuredQName COLLATION_KEY_NaN = new StructuredQName("saxon", "http://saxon.sf.net/collation-key", "NaN");

    public static AtomicComparer makeSortComparer(StringCollator collator, int itemType, XPathContext context) {
        switch (itemType) {
            case 513: 
            case 529: 
            case 631: {
                if (collator instanceof CodepointCollator) {
                    return CodepointCollatingComparer.getInstance();
                }
                return new CollatingAtomicComparer(collator, Configuration.getPlatform());
            }
            case 515: 
            case 532: {
                return DecimalSortComparer.getDecimalSortComparerInstance();
            }
            case 516: 
            case 517: 
            case 635: {
                return DoubleSortComparer.getInstance();
            }
            case 519: 
            case 520: 
            case 521: {
                return new CalendarValueComparer(context);
            }
        }
        return new AtomicSortComparer(collator, itemType, context);
    }

    private AtomicSortComparer(StringCollator collator, int itemType, XPathContext context) {
        this.collator = collator;
        if (collator == null) {
            this.collator = CodepointCollator.getInstance();
        }
        this.context = context;
        this.itemType = itemType;
    }

    public AtomicComparer provideContext(XPathContext context) {
        return new AtomicSortComparer(this.collator, this.itemType, context);
    }

    public StringCollator getStringCollator() {
        return this.collator;
    }

    public int getItemType() {
        return this.itemType;
    }

    public int compareAtomicValues(AtomicValue a, AtomicValue b) throws NoDynamicContextException {
        if (a == null) {
            if (b == null) {
                return 0;
            }
            return -1;
        }
        if (b == null) {
            return 1;
        }
        if (a instanceof UntypedAtomicValue) {
            return ((UntypedAtomicValue)a).compareTo(b, this.collator, this.context);
        }
        if (b instanceof UntypedAtomicValue) {
            return -((UntypedAtomicValue)b).compareTo(a, this.collator, this.context);
        }
        if (a.isNaN()) {
            return b.isNaN() ? 0 : -1;
        }
        if (b.isNaN()) {
            return 1;
        }
        if (a instanceof StringValue && b instanceof StringValue) {
            if (this.collator instanceof CodepointCollator) {
                return ((CodepointCollator)this.collator).compareCS(a.getStringValueCS(), b.getStringValueCS());
            }
            return this.collator.compareStrings(a.getStringValue(), b.getStringValue());
        }
        Comparable ac = (Comparable)a.getXPathComparable(true, this.collator, this.context);
        Comparable bc = (Comparable)b.getXPathComparable(true, this.collator, this.context);
        if (ac == null || bc == null) {
            throw new ClassCastException("Values are not comparable (" + Type.displayTypeName(a) + ", " + Type.displayTypeName(b) + ')');
        }
        return ac.compareTo(bc);
    }

    public boolean comparesEqual(AtomicValue a, AtomicValue b) throws NoDynamicContextException {
        return this.compareAtomicValues(a, b) == 0;
    }

    public ComparisonKey getComparisonKey(AtomicValue a) throws NoDynamicContextException {
        if (a instanceof NumericValue) {
            if (((NumericValue)a).isNaN()) {
                return new ComparisonKey(635, COLLATION_KEY_NaN);
            }
            return new ComparisonKey(635, a);
        }
        if (a instanceof StringValue) {
            Platform platform = Configuration.getPlatform();
            if (platform.canReturnCollationKeys(this.collator)) {
                return new ComparisonKey(513, this.collator.getCollationKey(a.getStringValue()));
            }
            return new ComparisonKey(513, a);
        }
        if (a instanceof CalendarValue) {
            CalendarValue cv = (CalendarValue)a;
            if (cv.hasTimezone()) {
                return new ComparisonKey(a.getTypeLabel().getPrimitiveType(), a);
            }
            cv = (CalendarValue)cv.copyAsSubType(cv.getTypeLabel());
            cv.setTimezoneInMinutes(this.context.getImplicitTimezone());
            return new ComparisonKey(cv.getTypeLabel().getPrimitiveType(), cv);
        }
        if (a instanceof DurationValue) {
            return new ComparisonKey(518, a);
        }
        return new ComparisonKey(a.getTypeLabel().getPrimitiveType(), a);
    }
}

