/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.mock.core.proxy;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import org.unitils.core.UnitilsException;
import org.unitils.mock.core.proxy.ProxyInvocation;
import org.unitils.mock.core.proxy.ProxyInvocationHandler;
import org.unitils.mock.core.proxy.ProxyUtils;
import org.unitils.util.MethodUtils;
import thirdparty.net.sf.cglib.proxy.MethodInterceptor;
import thirdparty.net.sf.cglib.proxy.MethodProxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CglibProxyMethodInterceptor<T>
implements MethodInterceptor {
    private String mockName;
    private Class<T> proxiedType;
    private ProxyInvocationHandler invocationHandler;

    public CglibProxyMethodInterceptor(String mockName, Class<T> proxiedType, ProxyInvocationHandler invocationHandler) {
        this.mockName = mockName;
        this.proxiedType = proxiedType;
        this.invocationHandler = invocationHandler;
    }

    @Override
    public Object intercept(Object proxy, Method method, Object[] arguments, MethodProxy methodProxy) throws Throwable {
        if (MethodUtils.isFinalizeMethod((Method)method)) {
            return null;
        }
        if (MethodUtils.isEqualsMethod((Method)method)) {
            return proxy == arguments[0];
        }
        if (MethodUtils.isHashCodeMethod((Method)method)) {
            return super.hashCode();
        }
        if (MethodUtils.isCloneMethod((Method)method)) {
            return proxy;
        }
        if (MethodUtils.isToStringMethod((Method)method)) {
            return this.getProxiedType().getSimpleName() + "@" + Integer.toHexString(super.hashCode());
        }
        CglibProxyInvocation invocation = new CglibProxyInvocation(this.mockName, method, Arrays.asList(arguments), ProxyUtils.getProxiedMethodStackTrace(), proxy, methodProxy);
        return this.invocationHandler.handleInvocation(invocation);
    }

    public String getMockName() {
        return this.mockName;
    }

    public Class<?> getProxiedType() {
        return this.proxiedType;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CglibProxyInvocation
    extends ProxyInvocation {
        private MethodProxy methodProxy;

        public CglibProxyInvocation(String mockName, Method method, List<Object> arguments, StackTraceElement[] invokedAt, Object proxy, MethodProxy methodProxy) {
            super(mockName, proxy, method, arguments, invokedAt);
            this.methodProxy = methodProxy;
        }

        @Override
        public Object invokeOriginalBehavior() throws Throwable {
            Method method = this.getMethod();
            if (Modifier.isAbstract(method.getModifiers())) {
                throw new UnitilsException("Unable to invoke original behavior. The method is abstract, it does not have any behavior defined: " + this.getMethod());
            }
            return this.methodProxy.invokeSuper(this.getProxy(), this.getArguments().toArray());
        }
    }
}

