/*
 * Copyright (C) 2005 - 2012 Jaspersoft Corporation. All rights reserved.
 * http://www.jaspersoft.com.
 * Unless you have purchased  a commercial license agreement from Jaspersoft,
 * the following license terms  apply:
 *
 * This program is free software: you can redistribute it and/or  modify
 * it under the terms of the GNU Affero General Public License  as
 * published by the Free Software Foundation, either version 3 of  the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero  General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public  License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

package com.jaspersoft.jasperserver.remote.services.impl;

import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.remote.exception.AccessDeniedException;
import com.jaspersoft.jasperserver.remote.exception.ResourceNotFoundException;
import com.jaspersoft.jasperserver.remote.services.BatchRepositoryService;
import org.springframework.security.SpringSecurityException;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * @author Zakhar.Tomchenco
 * @version $Id$
 */
@Component
@Transactional(rollbackFor = Exception.class)
public class BatchRepositoryServiceImpl implements BatchRepositoryService {

    @javax.annotation.Resource(name = "concreteRepository")
    private RepositoryService service;

    public void deleteResources(List<String> uris) throws AccessDeniedException, ResourceNotFoundException {
        for (String uri: uris){
            try{
                Resource resource = service.getResource(null, uri);
                if (resource != null){
                    service.deleteResource(null, uri);
                } else {
                    resource = service.getFolder(null, uri);
                    if (resource != null){
                        service.deleteFolder(null, uri);
                    }
                }
            } catch (SpringSecurityException sse){
                throw new AccessDeniedException(uri);
            }
        }
    }
}
