/*
 * Copyright (C) 2005 - 2012 Jaspersoft Corporation. All rights reserved.
 * http://www.jaspersoft.com.
 * Unless you have purchased  a commercial license agreement from Jaspersoft,
 * the following license terms  apply:
 *
 * This program is free software: you can redistribute it and/or  modify
 * it under the terms of the GNU Affero General Public License  as
 * published by the Free Software Foundation, either version 3 of  the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero  General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public  License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

package com.jaspersoft.jasperserver.remote.services;

import com.jaspersoft.jasperserver.remote.exception.AccessDeniedException;
import com.jaspersoft.jasperserver.remote.exception.ResourceNotFoundException;

import java.util.List;

/**
 * <p>Performs batch operations with resources in transaction</p>
 *
 * @author Zakhar.Tomchenco
 * @version $Id$
 */
public interface BatchRepositoryService {

    /**
     * Removes resources with uris in one transaction
     *
     * @param uris of resources to remove
     * @throws AccessDeniedException if current user cannot delete at least one resource
     */
    void deleteResources(List<String> uris) throws ResourceNotFoundException, AccessDeniedException;

}
