/*
 * Copyright (C) 2005 - 2011 Jaspersoft Corporation. All rights reserved.
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased  a commercial license agreement from Jaspersoft,
 * the following license terms  apply:
 *
 * This program is free software: you can redistribute it and/or  modify
 * it under the terms of the GNU Affero General Public License  as
 * published by the Free Software Foundation, either version 3 of  the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero  General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public  License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

package com.jaspersoft.jasperserver.export;

import com.jaspersoft.jasperserver.export.util.EncryptionUtils;

import java.util.Properties;

import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;

public class DecryptingPropertyPlaceholderConfigurer extends PropertyPlaceholderConfigurer {
	public static final String JS_PASSWORD_PROP = "metadata.jdbc.password";
	public static final String JS_ENCRYPTED_PASSWORD_PROP = "metadata.jdbc.encryptedPassword";

    protected void convertProperties(Properties properties) {
        super.convertProperties(properties);

        // replacing jdbc password with encripted one if assist
        String encPass = properties.getProperty(JS_ENCRYPTED_PASSWORD_PROP);
        if (encPass != null && encPass != "") {
            try {
                properties.setProperty(JS_PASSWORD_PROP, EncryptionUtils.decrypt(encPass));
            } catch (Exception e ) {}
        }
    }

}
