package com.jaspersoft.jasperserver.search.common;

import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.search.QueryModificationEvaluator;
import com.jaspersoft.jasperserver.search.filter.AccessTypeFilter;
import com.jaspersoft.jasperserver.search.filter.SearchAttributesHelper;

/**
 * Implementation of {@link QueryModificationEvaluator}.
 *
 * @author Chaim Arbiv
 * @author Yuriy Plakosh
 * @version $Id: QueryModificationEvaluatorImpl.java 25010 2012-09-26 16:56:35Z sergey.prilukin $
 * @since 4.7
 *
 * @see com.jaspersoft.jasperserver.api.search.QueryModificationEvaluator;
 */
public class QueryModificationEvaluatorImpl implements QueryModificationEvaluator {
    /**
     * In case of filtering by access event we are going from the access events table to the resource table so we will
     * have duplicates. In this case we need to add distinct projection to the query.
     *
     * @param context the execution context.
     * @return <code>true</code> if distinct projection should be applied, <code>false</code> otherwise.
     */
    @Override
    public boolean useDistinctProjection(ExecutionContext context) {
        SearchAttributes searchAttributes = SearchAttributesHelper.extract(context);

        return searchAttributes != null &&
                searchAttributes.getState() != null &&
                searchAttributes.getState().getCustomFiltersMap() != null &&
                searchAttributes.getState().getCustomFiltersMap().
                        get(AccessTypeFilter.ACCESS_TYPE_FILTER_NAME) != null &&
                !searchAttributes.getState().getCustomFiltersMap().get(AccessTypeFilter.ACCESS_TYPE_FILTER_NAME).equals(
                        AccessTypeFilter.ACCESS_TYPE_FILTER_ALL_OPTION);
    }
}
