/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.dto.resources;

import com.jaspersoft.jasperserver.dto.resources.ClientDataSourceHolder;
import com.jaspersoft.jasperserver.dto.resources.ClientFile;
import com.jaspersoft.jasperserver.dto.resources.ClientInputControl;
import com.jaspersoft.jasperserver.dto.resources.ClientQuery;
import com.jaspersoft.jasperserver.dto.resources.ClientReference;
import com.jaspersoft.jasperserver.dto.resources.ClientReferenceableFile;
import com.jaspersoft.jasperserver.dto.resources.ClientReferenceableInputControl;
import com.jaspersoft.jasperserver.dto.resources.ClientReferenceableQuery;
import com.jaspersoft.jasperserver.dto.resources.ClientReportUnitResource;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

@XmlRootElement(name="reportUnit")
public class ClientReportUnit
extends ClientDataSourceHolder {
    private ClientReferenceableQuery query;
    private ClientReferenceableFile jrxml;
    private List<ClientReferenceableInputControl> inputControls;
    private Map<String, ClientReferenceableFile> files;
    private String inputControlRenderingView;
    private String reportRenderingView;
    private boolean alwaysPromptControls;
    private ControlsLayoutType controlsLayout = ControlsLayoutType.popupScreen;
    private Long dataSnapshotId;

    @XmlElements(value={@XmlElement(name="queryReference", type=ClientReference.class), @XmlElement(name="localQuery", type=ClientQuery.class)})
    public ClientReferenceableQuery getQuery() {
        return this.query;
    }

    public void setQuery(ClientReferenceableQuery query) {
        this.query = query;
    }

    @XmlElements(value={@XmlElement(name="jrxmlReference", type=ClientReference.class), @XmlElement(name="localJrxml", type=ClientFile.class)})
    public ClientReferenceableFile getJrxml() {
        return this.jrxml;
    }

    public void setJrxml(ClientReferenceableFile jrxml) {
        this.jrxml = jrxml;
    }

    @XmlElementWrapper(name="inputControls")
    @XmlElements(value={@XmlElement(name="inputControlReference", type=ClientReference.class), @XmlElement(name="localInputControl", type=ClientInputControl.class)})
    public List<ClientReferenceableInputControl> getInputControls() {
        return this.inputControls;
    }

    public void setInputControls(List<ClientReferenceableInputControl> inputControls) {
        this.inputControls = inputControls;
    }

    @XmlElementWrapper(name="files")
    @XmlElement(name="file")
    public List<ClientReportUnitResource> getFilesAsList() {
        ArrayList<ClientReportUnitResource> result = null;
        if (this.files != null && !this.files.isEmpty()) {
            result = new ArrayList<ClientReportUnitResource>(this.files.size());
            for (String name : this.files.keySet()) {
                result.add(new ClientReportUnitResource(name, this.files.get(name)));
            }
        }
        return result;
    }

    public void setFiles(Map<String, ClientReferenceableFile> files) {
        this.files = files;
    }

    @XmlTransient
    public Map<String, ClientReferenceableFile> getFiles() {
        return this.files;
    }

    public String getInputControlRenderingView() {
        return this.inputControlRenderingView;
    }

    public void setInputControlRenderingView(String inputControlRenderingView) {
        this.inputControlRenderingView = inputControlRenderingView;
    }

    public String getReportRenderingView() {
        return this.reportRenderingView;
    }

    public void setReportRenderingView(String reportRenderingView) {
        this.reportRenderingView = reportRenderingView;
    }

    public boolean isAlwaysPromptControls() {
        return this.alwaysPromptControls;
    }

    public void setAlwaysPromptControls(boolean alwaysPromptControls) {
        this.alwaysPromptControls = alwaysPromptControls;
    }

    public ControlsLayoutType getControlsLayout() {
        return this.controlsLayout;
    }

    public void setControlsLayout(ControlsLayoutType controlsLayout) {
        this.controlsLayout = controlsLayout;
    }

    public Long getDataSnapshotId() {
        return this.dataSnapshotId;
    }

    public void setDataSnapshotId(Long dataSnapshotId) {
        this.dataSnapshotId = dataSnapshotId;
    }

    public static enum ControlsLayoutType {
        popupScreen,
        separatePage,
        topOfPage,
        inPage;

    }
}

