/*
 * Decompiled with CFR 0.152.
 */
package nu.xom;

import nu.xom.CDATASection;
import nu.xom.Node;
import nu.xom.Verifier;

public class Text
extends Node {
    private String data;

    public Text(String data) {
        this._setValue(data);
    }

    public Text(Text text) {
        this.data = text.data;
    }

    private Text() {
    }

    static Text build(String data) {
        Text result = new Text();
        result.data = data;
        return result;
    }

    public void setValue(String data) {
        this._setValue(data);
    }

    private void _setValue(String data) {
        if (data == null) {
            this.data = "";
        } else {
            Verifier.checkPCDATA(data);
            this.data = data;
        }
    }

    public final String getValue() {
        return this.data;
    }

    public final Node getChild(int position) {
        throw new IndexOutOfBoundsException("LeafNodes do not have children");
    }

    public final int getChildCount() {
        return 0;
    }

    public Node copy() {
        if (this.isCDATASection()) {
            return new CDATASection(this);
        }
        return new Text(this);
    }

    public final String toXML() {
        return this.escapeText();
    }

    boolean isText() {
        return true;
    }

    public final String toString() {
        return "[" + this.getClass().getName() + ": " + Text.escapeLineBreaksAndTruncate(this.getValue()) + "]";
    }

    static String escapeLineBreaksAndTruncate(String s) {
        boolean tooLong;
        int length = s.length();
        boolean bl = tooLong = length > 40;
        if (length > 40) {
            length = 35;
            s = s.substring(0, 35);
        }
        StringBuffer result = new StringBuffer(length);
        block5: for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\n': {
                    result.append("\\n");
                    continue block5;
                }
                case '\r': {
                    result.append("\\r");
                    continue block5;
                }
                case '\t': {
                    result.append("\\t");
                    continue block5;
                }
                default: {
                    result.append(c);
                }
            }
        }
        if (tooLong) {
            result.append("...");
        }
        return result.toString();
    }

    boolean isCDATASection() {
        return false;
    }

    boolean isEmpty() {
        return this.data.length() == 0;
    }

    String escapeText() {
        String s = this.getValue();
        int length = s.length();
        StringBuffer result = new StringBuffer(length + 12);
        block52: for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\r': {
                    result.append("&#x0D;");
                    continue block52;
                }
                case '\u000e': {
                    continue block52;
                }
                case '\u000f': {
                    continue block52;
                }
                case '\u0010': {
                    continue block52;
                }
                case '\u0011': {
                    continue block52;
                }
                case '\u0012': {
                    continue block52;
                }
                case '\u0013': {
                    continue block52;
                }
                case '\u0014': {
                    continue block52;
                }
                case '\u0015': {
                    continue block52;
                }
                case '\u0016': {
                    continue block52;
                }
                case '\u0017': {
                    continue block52;
                }
                case '\u0018': {
                    continue block52;
                }
                case '\u0019': {
                    continue block52;
                }
                case '\u001a': {
                    continue block52;
                }
                case '\u001b': {
                    continue block52;
                }
                case '\u001c': {
                    continue block52;
                }
                case '\u001d': {
                    continue block52;
                }
                case '\u001e': {
                    continue block52;
                }
                case '\u001f': {
                    continue block52;
                }
                case ' ': {
                    result.append(' ');
                    continue block52;
                }
                case '!': {
                    result.append('!');
                    continue block52;
                }
                case '\"': {
                    result.append('\"');
                    continue block52;
                }
                case '#': {
                    result.append('#');
                    continue block52;
                }
                case '$': {
                    result.append('$');
                    continue block52;
                }
                case '%': {
                    result.append('%');
                    continue block52;
                }
                case '&': {
                    result.append("&amp;");
                    continue block52;
                }
                case '\'': {
                    result.append('\'');
                    continue block52;
                }
                case '(': {
                    result.append('(');
                    continue block52;
                }
                case ')': {
                    result.append(')');
                    continue block52;
                }
                case '*': {
                    result.append('*');
                    continue block52;
                }
                case '+': {
                    result.append('+');
                    continue block52;
                }
                case ',': {
                    result.append(',');
                    continue block52;
                }
                case '-': {
                    result.append('-');
                    continue block52;
                }
                case '.': {
                    result.append('.');
                    continue block52;
                }
                case '/': {
                    result.append('/');
                    continue block52;
                }
                case '0': {
                    result.append('0');
                    continue block52;
                }
                case '1': {
                    result.append('1');
                    continue block52;
                }
                case '2': {
                    result.append('2');
                    continue block52;
                }
                case '3': {
                    result.append('3');
                    continue block52;
                }
                case '4': {
                    result.append('4');
                    continue block52;
                }
                case '5': {
                    result.append('5');
                    continue block52;
                }
                case '6': {
                    result.append('6');
                    continue block52;
                }
                case '7': {
                    result.append('7');
                    continue block52;
                }
                case '8': {
                    result.append('8');
                    continue block52;
                }
                case '9': {
                    result.append('9');
                    continue block52;
                }
                case ':': {
                    result.append(':');
                    continue block52;
                }
                case ';': {
                    result.append(';');
                    continue block52;
                }
                case '<': {
                    result.append("&lt;");
                    continue block52;
                }
                case '=': {
                    result.append('=');
                    continue block52;
                }
                case '>': {
                    result.append("&gt;");
                    continue block52;
                }
                default: {
                    result.append(c);
                }
            }
        }
        return result.toString();
    }
}

