/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.ws.axis2.repository;

import com.jaspersoft.jasperserver.api.metadata.common.domain.ContentResource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.FileResourceData;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.jasperserver.ws.axis2.RepositoryServiceContext;
import com.jaspersoft.jasperserver.ws.axis2.ResourceDataSource;
import com.jaspersoft.jasperserver.ws.axis2.ResultAttachments;
import com.jaspersoft.jasperserver.ws.axis2.WSException;
import com.jaspersoft.jasperserver.ws.axis2.repository.RepositoryResourceHandler;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.soap.SOAPException;
import org.apache.axis.attachments.AttachmentPart;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ContentResourceHandler
extends RepositoryResourceHandler {
    private static final Log log = LogFactory.getLog(ContentResourceHandler.class);
    private static final String MAIN_ATTACHMENT_ID = "attachment";

    @Override
    public Class getResourceType() {
        return ContentResource.class;
    }

    @Override
    protected void doDescribe(Resource resource, ResourceDescriptor descriptor, Map arguments, RepositoryServiceContext serviceContext) throws WSException {
        ContentResource contentRes = (ContentResource)resource;
        descriptor.setWsType("contentResource");
        descriptor.setResourceProperty("CONTENT_TYPE", contentRes.getFileType());
    }

    @Override
    protected void updateResource(Resource resource, ResourceDescriptor descriptor, RepositoryServiceContext serviceContext) throws WSException {
        List children;
        ContentResource contentRes = (ContentResource)resource;
        String fileType = descriptor.getResourcePropertyValue("CONTENT_TYPE");
        if (fileType != null) {
            contentRes.setFileType(fileType);
        }
        if (descriptor.getHasData()) {
            try {
                AttachmentPart attachment = this.locateDataAttachment(descriptor, serviceContext);
                this.readData(contentRes, attachment);
            }
            catch (SOAPException e) {
                throw new WSException((Exception)((Object)e));
            }
        }
        ArrayList<ContentResource> subresources = new ArrayList<ContentResource>((children = descriptor.getChildren()) == null ? 0 : children.size());
        if (children != null) {
            for (ResourceDescriptor subdescriptor : children) {
                ContentResource subresource = (ContentResource)this.toChildResource(subdescriptor, serviceContext);
                subresources.add(subresource);
            }
        }
        contentRes.setResources(subresources);
    }

    protected AttachmentPart locateDataAttachment(ResourceDescriptor resourceDescriptor, RepositoryServiceContext serviceContext) throws WSException, SOAPException {
        String contentName = resourceDescriptor.getResourcePropertyValue("DATA_ATTACHMENT_ID");
        if (contentName == null) {
            contentName = resourceDescriptor.getName();
        }
        AttachmentPart[] attachments = serviceContext.getMessageAttachments();
        AttachmentPart attachment = null;
        if (attachments != null) {
            for (int i = 0; i < attachments.length; ++i) {
                String attachmentId = attachments[i].getContentId();
                if (attachmentId == null || !attachmentId.equals(contentName)) continue;
                attachment = attachments[i];
                break;
            }
        }
        if (attachment == null) {
            throw new WSException(2, serviceContext.getMessage("webservices.error.content.resource.data.not.present", new Object[]{contentName}));
        }
        return attachment;
    }

    protected String getAttachmentContentID(ContentResource contentRes) {
        return contentRes.getName();
    }

    protected void readData(ContentResource resource, AttachmentPart attachment) throws WSException, SOAPException {
        boolean close = true;
        InputStream dataStream = null;
        try {
            dataStream = attachment.getDataHandler().getInputStream();
            resource.readData(dataStream);
            close = false;
            dataStream.close();
        }
        catch (IOException e) {
            throw new WSException(e);
        }
        finally {
            if (close && dataStream != null) {
                try {
                    dataStream.close();
                }
                catch (IOException e) {
                    log.error((Object)"Error closing attachment stream", (Throwable)e);
                }
            }
        }
    }

    @Override
    public void getAttachments(Resource resource, Map arguments, ResourceDescriptor descriptor, ResultAttachments attachments, RepositoryServiceContext serviceContext) {
        super.getAttachments(resource, arguments, descriptor, attachments, serviceContext);
        ContentResource contentRes = (ContentResource)resource;
        if (arguments.containsKey("NO_ATTACHMENT")) {
            descriptor.setHasData(false);
        } else {
            descriptor.setHasData(true);
            this.addMainAttachment(descriptor, attachments, serviceContext);
            if (!arguments.containsKey("NO_SUBRESOURCE_ATTACHMENTS")) {
                this.addSubAttachments(contentRes, attachments, serviceContext);
            }
        }
    }

    protected void addMainAttachment(ResourceDescriptor descriptor, ResultAttachments attachments, RepositoryServiceContext serviceContext) {
        FileResourceData fileData = serviceContext.getRepository().getContentResourceData(null, descriptor.getUriString());
        ResourceDataSource attachmentSource = new ResourceDataSource("", fileData);
        attachments.addAttachment(MAIN_ATTACHMENT_ID, attachmentSource);
        descriptor.setResourceProperty("DATA_ATTACHMENT_ID", MAIN_ATTACHMENT_ID);
    }

    protected void addSubAttachments(ContentResource contentRes, ResultAttachments attachments, RepositoryServiceContext serviceContext) {
        List resources;
        if (contentRes.getFileType().equals("html") && (resources = contentRes.getResources()) != null && !resources.isEmpty()) {
            for (ContentResource subResource : resources) {
                FileResourceData subData = serviceContext.getRepository().getContentResourceData(null, subResource.getURIString());
                ResourceDataSource subAttachment = new ResourceDataSource("", subData);
                attachments.addAttachment(subResource.getName(), subAttachment);
            }
        }
    }
}

