/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.xmla;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.common.util.StaticCharacterEncodingProvider;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceLookup;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryUnsecure;
import com.jaspersoft.jasperserver.api.metadata.olap.domain.MondrianXMLADefinition;
import com.jaspersoft.jasperserver.api.metadata.olap.service.OlapConnectionService;
import com.jaspersoft.jasperserver.api.metadata.olap.service.OlapManagementService;
import com.jaspersoft.jasperserver.api.metadata.user.domain.Tenant;
import com.jaspersoft.jasperserver.api.metadata.user.service.TenantService;
import com.jaspersoft.jasperserver.api.metadata.view.domain.FilterCriteria;
import com.jaspersoft.jasperserver.war.common.JasperServerUtil;
import com.jaspersoft.jasperserver.war.xmla.UpdatableXMLAContainer;
import com.jaspersoft.jasperserver.war.xmla.XMLAUpdateListener;
import com.jaspersoft.jasperserver.war.xmla.XmlaHandlerImpl;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import mondrian.xmla.DataSourcesConfig;
import mondrian.xmla.XmlaException;
import mondrian.xmla.XmlaHandler;
import mondrian.xmla.XmlaServlet;
import mondrian.xmla.impl.DefaultXmlaServlet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class XmlaServletImpl
extends DefaultXmlaServlet
implements UpdatableXMLAContainer {
    private static final Log log = LogFactory.getLog(XmlaServletImpl.class);
    private static ApplicationContext ctx;
    protected TenantService tenantService;
    private Properties springConfiguration;
    protected String servletURL;
    private RepositoryService mRepository;
    private OlapConnectionService mConnectionService;
    private OlapManagementService olapManagementService;

    public static ApplicationContext getContext() {
        return ctx;
    }

    public void init(ServletConfig config) throws ServletException {
        log.debug((Object)"XmlaServletImpl:init");
        ServletContext servletContext = config.getServletContext();
        ctx = WebApplicationContextUtils.getWebApplicationContext((ServletContext)servletContext);
        if (ctx == null) {
            log.error((Object)"XmlaServletImpl:init Unable to obtain ApplicationContext from servletContext");
            ctx = new ClassPathXmlApplicationContext(new String[]{"applicationContext.xml"});
            if (ctx == null) {
                log.error((Object)"XmlaServletImpl:init Unable to obtain ApplicationContext");
            }
        }
        try {
            this.springConfiguration = (Properties)ctx.getBean("springConfiguration");
        }
        catch (NoSuchBeanDefinitionException e) {
            this.springConfiguration = new Properties();
            log.debug((Object)"XmlaServletImpl:init : no spring configuration");
        }
        String tenantServiceName = "tenantService";
        if (this.springConfiguration.containsKey("bean.tenantService")) {
            tenantServiceName = this.springConfiguration.getProperty("bean.tenantService");
        }
        try {
            this.tenantService = (TenantService)ctx.getBean(tenantServiceName);
        }
        catch (NoSuchBeanDefinitionException e) {
            log.debug((Object)"XmlaServletImpl:init : no tenantService");
        }
        super.init(config);
        XMLAUpdateListener updateListener = (XMLAUpdateListener)ctx.getBean("xmlaUpdateListener");
        updateListener.registerListener(this);
        try {
            String defaultPort;
            InetAddress local = InetAddress.getLocalHost();
            String defaultProtocol = servletContext.getInitParameter("defaultProtocol");
            if (defaultProtocol == null || defaultProtocol.trim().length() == 0) {
                defaultProtocol = "http";
            }
            if ((defaultPort = servletContext.getInitParameter("defaultPort")) == null || defaultPort.trim().length() == 0) {
                defaultPort = "-1";
            }
            int port = Integer.parseInt(defaultPort);
            URL root = servletContext.getResource("/");
            int pastHost = root.getPath().indexOf("/", 1);
            String path = root.getPath().substring(pastHost, root.getPath().length());
            this.servletURL = new URL(defaultProtocol, local.getCanonicalHostName(), port, path).toString() + "xmla";
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            if (this.getConnectionService() != null) {
                this.charEncoding = ((StaticCharacterEncodingProvider)ctx.getBean("encodingProvider")).getCharacterEncoding();
                log.debug((Object)("doPost:charEncoding set to " + this.charEncoding));
            }
            super.doPost(request, response);
        }
        catch (Throwable t) {
            log.error((Object)"XMLA Servlet Error, ROOT CAUSE:");
            log.error((Object)XmlaException.getRootCause((Throwable)t).getStackTrace());
            throw new ServletException(t);
        }
    }

    protected void handleFault(HttpServletResponse response, byte[][] responseSoapParts, XmlaServlet.Phase phase, Throwable t) {
        log.error((Object)"XMLA FAULT!!!");
        log.error((Object)XmlaException.getRootCause((Throwable)t).getStackTrace());
        super.handleFault(response, responseSoapParts, phase, t);
    }

    protected DataSourcesConfig.DataSources makeDataSources(ServletConfig servletConfig) {
        return this.makeDataSources(servletConfig, false);
    }

    protected DataSourcesConfig.DataSources makeDataSources(ServletConfig servletConfig, boolean throwIfDuplicatesFound) {
        log.debug((Object)"makeDataSources");
        RepositoryService rep = (RepositoryService)ctx.getBean("unsecureRepositoryService");
        DataSourcesConfig.DataSources datasources = new DataSourcesConfig.DataSources();
        FilterCriteria f = FilterCriteria.createFilter(MondrianXMLADefinition.class);
        ResourceLookup[] lookups = rep.findResource(JasperServerUtil.getExecutionContext(), f);
        if (lookups == null || lookups.length == 0) {
            log.debug((Object)"No XML/A Connections available");
            return datasources;
        }
        LinkedHashMap<String, String> dsURIs = new LinkedHashMap<String, String>();
        ArrayList<DataSourcesConfig.DataSource> dsList = new ArrayList<DataSourcesConfig.DataSource>();
        for (ResourceLookup r : lookups) {
            String alreadyUsed;
            if (r.getURIString().contains("org_template")) {
                log.info((Object)("Disqualifying from XMLA pool : " + r.getURIString()));
                continue;
            }
            MondrianXMLADefinition def = (MondrianXMLADefinition)((RepositoryUnsecure)rep).getResourceUnsecure(null, r.getURIString());
            DataSourcesConfig.DataSource d = this.createDSConfigOutOfDefinition(def);
            if (log.isDebugEnabled()) {
                log.debug((Object)("loading DataSource name=" + d.name + ", info=" + d.dataSourceInfo + ", url=" + d.url));
            }
            if ((alreadyUsed = (String)dsURIs.get(d.dataSourceInfo)) != null) {
                String errorMessage = "XML/A definition " + r.getURIString() + " has the name (" + d.dataSourceInfo + ") as another  XML/A definition (" + alreadyUsed + ")";
                log.error((Object)errorMessage);
                if (throwIfDuplicatesFound) {
                    throw new JSException(errorMessage);
                }
            }
            dsList.add(d);
            dsURIs.put(d.dataSourceInfo, r.getURIString());
        }
        datasources.dataSources = dsList.toArray(new DataSourcesConfig.DataSource[dsList.size()]);
        return datasources;
    }

    protected DataSourcesConfig.DataSource createDSConfigOutOfDefinition(MondrianXMLADefinition def) {
        Tenant tenant;
        DataSourcesConfig.DataSource d = new DataSourcesConfig.DataSource();
        d.description = def.getDescription();
        d.url = this.servletURL;
        d.providerName = "Mondrian";
        d.providerType = "MDP";
        d.authenticationMode = "Unauthenticated";
        d.name = "Provider=" + d.providerName + ";DataSource=" + def.getCatalog() + ";";
        if (this.tenantService != null && (tenant = this.tenantService.getTenantBasedOnRepositoryUri(null, def.getURIString())) != null) {
            d.name = d.name + "TenantID=" + tenant.getId() + ";";
        }
        d.dataSourceInfo = d.name;
        DataSourcesConfig.Catalogs cs = new DataSourcesConfig.Catalogs();
        DataSourcesConfig.Catalog c = new DataSourcesConfig.Catalog();
        c.name = def.getCatalog();
        cs.catalogs = new DataSourcesConfig.Catalog[1];
        cs.catalogs[0] = c;
        d.catalogs = cs;
        c.definition = "JASPERSERVER";
        return d;
    }

    protected synchronized XmlaHandler getXmlaHandler() {
        if (this.xmlaHandler == null) {
            log.debug((Object)"getXmlaHandler");
            this.xmlaHandler = new XmlaHandlerImpl(this.makeDataSources(this.getServletConfig(), true), this.catalogLocator, this.getRepository(), this.getConnectionService(), this.getOlapManagementService());
        }
        return this.xmlaHandler;
    }

    public RepositoryService getRepository() {
        if (this.mRepository == null) {
            log.debug((Object)"getRepository");
            String repositoryServiceName = "repositoryService";
            if (this.springConfiguration.containsKey("bean.repositoryService")) {
                repositoryServiceName = this.springConfiguration.getProperty("bean.repositoryService");
            }
            this.mRepository = (RepositoryService)ctx.getBean(repositoryServiceName);
            if (this.mRepository == null) {
                log.error((Object)("repositoryService not available in context: " + ctx));
            }
        }
        return this.mRepository;
    }

    public void setRepository(RepositoryService repository) {
        this.mRepository = repository;
    }

    public OlapConnectionService getConnectionService() {
        if (this.mConnectionService == null) {
            log.debug((Object)"getConnectionService");
            this.mConnectionService = (OlapConnectionService)ctx.getBean("olapConnectionService");
            if (this.mConnectionService == null) {
                log.error((Object)("repositoryService not available in context: " + ctx));
            }
        }
        return this.mConnectionService;
    }

    public void setConnectionService(OlapConnectionService cs) {
        this.mConnectionService = cs;
    }

    public OlapManagementService getOlapManagementService() {
        if (this.olapManagementService == null) {
            log.debug((Object)"getOlapManagementService");
            this.olapManagementService = (OlapManagementService)ctx.getBean("olapManagementService");
            if (this.olapManagementService == null) {
                log.error((Object)("olapManagementService not available in context: " + ctx));
            }
        }
        return this.olapManagementService;
    }

    public void setOlapManagementService(OlapManagementService olapManagementService) {
        this.olapManagementService = olapManagementService;
    }

    @Override
    public synchronized void updateXMLAConnection(MondrianXMLADefinition oldDef, MondrianXMLADefinition newDef) {
        DataSourcesConfig.DataSource[] dss = this.dataSources.dataSources;
        ArrayList<DataSourcesConfig.DataSource> dsList = new ArrayList<DataSourcesConfig.DataSource>(Arrays.asList(dss));
        if (oldDef != null) {
            DataSourcesConfig.DataSource oldDS = this.createDSConfigOutOfDefinition(oldDef);
            Iterator iter = dsList.iterator();
            while (iter.hasNext()) {
                DataSourcesConfig.DataSource d = (DataSourcesConfig.DataSource)iter.next();
                if (!d.getDataSourceInfo().equals(oldDS.getDataSourceInfo())) continue;
                iter.remove();
                break;
            }
        }
        if (newDef != null) {
            dsList.add(this.createDSConfigOutOfDefinition(newDef));
        }
        this.dataSources.dataSources = dsList.toArray(new DataSourcesConfig.DataSource[dsList.size()]);
    }
}

