/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.util;

import com.jaspersoft.jasperserver.api.security.encryption.EncryptionRequestUtils;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.Authentication;
import org.springframework.security.AuthenticationException;
import org.springframework.security.AuthenticationManager;
import org.springframework.security.context.SecurityContextHolder;
import org.springframework.security.providers.UsernamePasswordAuthenticationToken;
import org.springframework.security.ui.WebAuthenticationDetails;

public class RequestParameterAuthenticationFilter
implements Filter {
    private static final Log log = LogFactory.getLog(RequestParameterAuthenticationFilter.class);
    private AuthenticationManager authenticationManager;
    private String authenticationFailureUrl;
    private String[] excludeUrls;

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        if (this.requiresAuthentication(httpRequest)) {
            Authentication authResult;
            String username = EncryptionRequestUtils.getValue((ServletRequest)httpRequest, (String)"j_username");
            String password = EncryptionRequestUtils.getValue((ServletRequest)httpRequest, (String)"j_password");
            UsernamePasswordAuthenticationToken authRequest = new UsernamePasswordAuthenticationToken((Object)username, (Object)password);
            authRequest.setDetails((Object)new WebAuthenticationDetails(httpRequest));
            try {
                authResult = this.authenticationManager.authenticate((Authentication)authRequest);
            }
            catch (AuthenticationException e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("User " + username + " failed to authenticate: " + e.toString()));
                }
                SecurityContextHolder.getContext().setAuthentication(null);
                httpResponse.sendRedirect(httpResponse.encodeRedirectURL(this.getFullFailureUrl(httpRequest)));
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("User " + username + " authenticated: " + authResult));
            }
            SecurityContextHolder.getContext().setAuthentication(authResult);
        }
        chain.doFilter(request, response);
    }

    protected boolean requiresAuthentication(HttpServletRequest request) {
        Authentication existingAuth;
        String username = EncryptionRequestUtils.getValue((ServletRequest)request, (String)"j_username");
        boolean authenticate = username == null ? false : ((existingAuth = SecurityContextHolder.getContext().getAuthentication()) != null && existingAuth.isAuthenticated() && existingAuth.getName().equals(username) ? false : !this.isUrlExcluded(request));
        return authenticate;
    }

    protected boolean isUrlExcluded(HttpServletRequest request) {
        if (this.excludeUrls == null || this.excludeUrls.length == 0) {
            return false;
        }
        String uri = request.getRequestURI();
        int pathParamIndex = uri.indexOf(59);
        if (pathParamIndex > 0) {
            uri = uri.substring(0, pathParamIndex);
        }
        for (int i = 0; i < this.excludeUrls.length; ++i) {
            String excludedUrl = this.excludeUrls[i];
            if (!uri.endsWith(request.getContextPath() + excludedUrl)) continue;
            return true;
        }
        return false;
    }

    protected String getFullFailureUrl(HttpServletRequest request) {
        return request.getContextPath() + this.authenticationFailureUrl;
    }

    public AuthenticationManager getAuthenticationManager() {
        return this.authenticationManager;
    }

    public void setAuthenticationManager(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }

    public String getAuthenticationFailureUrl() {
        return this.authenticationFailureUrl;
    }

    public void setAuthenticationFailureUrl(String authenticationFailureUrl) {
        this.authenticationFailureUrl = authenticationFailureUrl;
    }

    public String[] getExcludeUrls() {
        return this.excludeUrls;
    }

    public void setExcludeUrls(String[] excludeUrls) {
        this.excludeUrls = excludeUrls;
    }
}

